/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryPerformanceFetcher;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class ExplainAnalyzeOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final QueryPerformanceFetcher queryPerformanceFetcher;
    private final Metadata metadata;
    private final StatsCalculator statsCalculator;
    private final boolean verbose;
    private boolean finishing;
    private boolean outputConsumed;

    public ExplainAnalyzeOperator(OperatorContext operatorContext, QueryPerformanceFetcher queryPerformanceFetcher, Metadata metadata, StatsCalculator statsCalculator, boolean verbose) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.queryPerformanceFetcher = Objects.requireNonNull(queryPerformanceFetcher, "queryPerformanceFetcher is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.verbose = verbose;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return ImmutableList.of((Object)VarcharType.VARCHAR);
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.outputConsumed;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((boolean)this.needsInput());
    }

    @Override
    public Page getOutput() {
        if (!this.finishing) {
            return null;
        }
        QueryInfo queryInfo = this.queryPerformanceFetcher.getQueryInfo(this.operatorContext.getDriverContext().getTaskId().getQueryId());
        Preconditions.checkState((boolean)queryInfo.getOutputStage().isPresent(), (Object)"Output stage is missing");
        if (!this.hasFinalStageInfo(queryInfo.getOutputStage().get())) {
            return null;
        }
        String plan = PlanPrinter.textDistributedPlan(queryInfo.getOutputStage().get(), this.metadata, this.statsCalculator, this.operatorContext.getSession(), this.verbose);
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(new BlockBuilderStatus(), 1);
        VarcharType.VARCHAR.writeString(builder, plan);
        this.outputConsumed = true;
        return new Page(new Block[]{builder.build()});
    }

    private boolean hasFinalStageInfo(StageInfo stageInfo) {
        boolean isFinalStageInfo = this.isFinalStageInfo(stageInfo);
        if (!isFinalStageInfo) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return this.isFinalStageInfo(stageInfo);
    }

    private boolean isFinalStageInfo(StageInfo stageInfo) {
        List<StageInfo> subStages = ExplainAnalyzeOperator.getSubStagesOf(this.operatorContext.getDriverContext().getTaskId().getStageId(), stageInfo);
        return subStages.stream().allMatch(StageInfo::isFinalStageInfo);
    }

    private static List<StageInfo> getSubStagesOf(StageId stageId, StageInfo rootStage) {
        ImmutableList.Builder collector = ImmutableList.builder();
        ExplainAnalyzeOperator.getSubStages(stageId, rootStage, (ImmutableList.Builder<StageInfo>)collector, false);
        return collector.build();
    }

    private static void getSubStages(StageId stageId, StageInfo rootStage, ImmutableList.Builder<StageInfo> collector, boolean add) {
        if (rootStage.getStageId().equals(stageId)) {
            add = true;
        }
        List<StageInfo> subStages = rootStage.getSubStages();
        for (StageInfo subStage : subStages) {
            ExplainAnalyzeOperator.getSubStages(stageId, subStage, collector, add);
        }
        if (add && !rootStage.getStageId().equals(stageId)) {
            collector.add((Object)rootStage);
        }
    }

    public static class ExplainAnalyzeOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final QueryPerformanceFetcher queryPerformanceFetcher;
        private final Metadata metadata;
        private final StatsCalculator statsCalculator;
        private final boolean verbose;
        private boolean closed;

        public ExplainAnalyzeOperatorFactory(int operatorId, PlanNodeId planNodeId, QueryPerformanceFetcher queryPerformanceFetcher, Metadata metadata, StatsCalculator statsCalculator, boolean verbose) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.queryPerformanceFetcher = Objects.requireNonNull(queryPerformanceFetcher, "queryPerformanceFetcher is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
            this.verbose = verbose;
        }

        @Override
        public List<Type> getTypes() {
            return ImmutableList.of((Object)VarcharType.VARCHAR);
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, ExplainAnalyzeOperator.class.getSimpleName());
            return new ExplainAnalyzeOperator(operatorContext, this.queryPerformanceFetcher, this.metadata, this.statsCalculator, this.verbose);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new ExplainAnalyzeOperatorFactory(this.operatorId, this.planNodeId, this.queryPerformanceFetcher, this.metadata, this.statsCalculator, this.verbose);
        }
    }
}

