/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Work;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DistinctLimitOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private final LocalMemoryContext localUserMemoryContext;
    private final PageBuilder pageBuilder;
    private Page inputPage;
    private long remainingLimit;
    private boolean finishing;
    private final GroupByHash groupByHash;
    private long nextDistinctId;
    private GroupByIdBlock groupByIds;
    private Work<GroupByIdBlock> unfinishedWork;

    public DistinctLimitOperator(OperatorContext operatorContext, List<Type> types, List<Integer> distinctChannels, long limit, Optional<Integer> hashChannel, JoinCompiler joinCompiler) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
        Objects.requireNonNull(distinctChannels, "distinctChannels is null");
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be at least zero");
        Objects.requireNonNull(hashChannel, "hashChannel is null");
        ImmutableList.Builder distinctTypes = ImmutableList.builder();
        for (int channel : distinctChannels) {
            distinctTypes.add((Object)types.get(channel));
        }
        this.groupByHash = GroupByHash.createGroupByHash((List<? extends Type>)distinctTypes.build(), Ints.toArray(distinctChannels), hashChannel, Math.min((int)limit, 10000), SystemSessionProperties.isDictionaryAggregationEnabled(operatorContext.getSession()), joinCompiler, this::updateMemoryReservation);
        this.pageBuilder = new PageBuilder(types);
        this.remainingLimit = limit;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
        this.pageBuilder.reset();
    }

    @Override
    public boolean isFinished() {
        return !this.hasUnfinishedInput() && (this.finishing || this.remainingLimit == 0L);
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.remainingLimit > 0L && !this.hasUnfinishedInput();
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((boolean)this.needsInput());
        this.inputPage = page;
        this.unfinishedWork = this.groupByHash.getGroupIds(page);
        this.processUnfinishedWork();
        this.updateMemoryReservation();
    }

    @Override
    public Page getOutput() {
        if (this.unfinishedWork != null && !this.processUnfinishedWork()) {
            return null;
        }
        if (this.groupByIds == null) {
            return null;
        }
        Verify.verify((this.pageBuilder.getPositionCount() == 0 ? 1 : 0) != 0);
        Verify.verify((this.inputPage != null ? 1 : 0) != 0);
        for (int position = 0; position < this.groupByIds.getPositionCount(); ++position) {
            if (this.groupByIds.getGroupId(position) != this.nextDistinctId) continue;
            this.pageBuilder.declarePosition();
            for (int channel = 0; channel < this.types.size(); ++channel) {
                Type type = this.types.get(channel);
                type.appendTo(this.inputPage.getBlock(channel), position, this.pageBuilder.getBlockBuilder(channel));
            }
            --this.remainingLimit;
            ++this.nextDistinctId;
            if (this.remainingLimit == 0L) break;
        }
        this.groupByIds = null;
        this.inputPage = null;
        Page result = null;
        if (!this.pageBuilder.isEmpty()) {
            result = this.pageBuilder.build();
            this.pageBuilder.reset();
        }
        this.updateMemoryReservation();
        return result;
    }

    private boolean processUnfinishedWork() {
        Verify.verify((this.unfinishedWork != null ? 1 : 0) != 0);
        if (!this.unfinishedWork.process()) {
            return false;
        }
        this.groupByIds = this.unfinishedWork.getResult();
        this.unfinishedWork = null;
        return true;
    }

    private boolean hasUnfinishedInput() {
        return this.inputPage != null || this.unfinishedWork != null;
    }

    private boolean updateMemoryReservation() {
        this.localUserMemoryContext.setBytes(this.groupByHash.getEstimatedSize());
        return this.operatorContext.isWaitingForMemory().isDone();
    }

    @VisibleForTesting
    public int getCapacity() {
        return this.groupByHash.getCapacity();
    }

    public static class DistinctLimitOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Integer> distinctChannels;
        private final List<Type> types;
        private final long limit;
        private final Optional<Integer> hashChannel;
        private boolean closed;
        private final JoinCompiler joinCompiler;

        public DistinctLimitOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> types, List<Integer> distinctChannels, long limit, Optional<Integer> hashChannel, JoinCompiler joinCompiler) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            this.distinctChannels = Objects.requireNonNull(distinctChannels, "distinctChannels is null");
            Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be at least zero");
            this.limit = limit;
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, DistinctLimitOperator.class.getSimpleName());
            return new DistinctLimitOperator(operatorContext, this.types, this.distinctChannels, this.limit, this.hashChannel, this.joinCompiler);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new DistinctLimitOperatorFactory(this.operatorId, this.planNodeId, this.types, this.distinctChannels, this.limit, this.hashChannel, this.joinCompiler);
        }
    }
}

