/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;

public final class Split {
    private final ConnectorId connectorId;
    private final ConnectorTransactionHandle transactionHandle;
    private final ConnectorSplit connectorSplit;
    private final Lifespan lifespan;

    public Split(ConnectorId connectorId, ConnectorTransactionHandle transactionHandle, ConnectorSplit connectorSplit) {
        this(connectorId, transactionHandle, connectorSplit, Lifespan.taskWide());
    }

    @JsonCreator
    public Split(@JsonProperty(value="connectorId") ConnectorId connectorId, @JsonProperty(value="transactionHandle") ConnectorTransactionHandle transactionHandle, @JsonProperty(value="connectorSplit") ConnectorSplit connectorSplit, @JsonProperty(value="lifespan") Lifespan lifespan) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.transactionHandle = Objects.requireNonNull(transactionHandle, "transactionHandle is null");
        this.connectorSplit = Objects.requireNonNull(connectorSplit, "connectorSplit is null");
        this.lifespan = Objects.requireNonNull(lifespan, "lifespan is null");
    }

    @JsonProperty
    public ConnectorId getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public ConnectorTransactionHandle getTransactionHandle() {
        return this.transactionHandle;
    }

    @JsonProperty
    public ConnectorSplit getConnectorSplit() {
        return this.connectorSplit;
    }

    @JsonProperty
    public Lifespan getLifespan() {
        return this.lifespan;
    }

    public Object getInfo() {
        return this.connectorSplit.getInfo();
    }

    public List<HostAddress> getAddresses() {
        return this.connectorSplit.getAddresses();
    }

    public boolean isRemotelyAccessible() {
        return this.connectorSplit.isRemotelyAccessible();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("transactionHandle", (Object)this.transactionHandle).add("connectorSplit", (Object)this.connectorSplit).add("lifespan", (Object)this.lifespan).toString();
    }
}

