/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.memory.MemoryPoolListener;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.memory.MemoryPoolInfo;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.weakref.jmx.Managed;

public class MemoryPool {
    private final MemoryPoolId id;
    private final long maxBytes;
    @GuardedBy(value="this")
    private long reservedBytes;
    @GuardedBy(value="this")
    private long reservedRevocableBytes;
    @Nullable
    @GuardedBy(value="this")
    private NonCancellableMemoryFuture<?> future;
    @GuardedBy(value="this")
    private final Map<QueryId, Long> queryMemoryReservations = new HashMap<QueryId, Long>();
    @GuardedBy(value="this")
    private final Map<QueryId, Long> queryMemoryRevocableReservations = new HashMap<QueryId, Long>();
    private final List<MemoryPoolListener> listeners = new CopyOnWriteArrayList<MemoryPoolListener>();

    public MemoryPool(MemoryPoolId id, DataSize size) {
        this.id = Objects.requireNonNull(id, "name is null");
        Objects.requireNonNull(size, "size is null");
        this.maxBytes = size.toBytes();
    }

    public MemoryPoolId getId() {
        return this.id;
    }

    public synchronized MemoryPoolInfo getInfo() {
        return new MemoryPoolInfo(this.maxBytes, this.reservedBytes, this.reservedRevocableBytes, this.queryMemoryReservations, this.queryMemoryRevocableReservations);
    }

    public void addListener(MemoryPoolListener listener) {
        this.listeners.add(Objects.requireNonNull(listener, "listener cannot be null"));
    }

    public void removeListener(MemoryPoolListener listener) {
        this.listeners.remove(Objects.requireNonNull(listener, "listener cannot be null"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> reserve(QueryId queryId, long bytes) {
        Object result;
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        MemoryPool memoryPool = this;
        synchronized (memoryPool) {
            if (bytes != 0L) {
                this.queryMemoryReservations.merge(queryId, bytes, Long::sum);
            }
            this.reservedBytes += bytes;
            if (this.getFreeBytes() <= 0L) {
                if (this.future == null) {
                    this.future = NonCancellableMemoryFuture.create();
                }
                Preconditions.checkState((!this.future.isDone() ? 1 : 0) != 0, (Object)"future is already completed");
                result = this.future;
            } else {
                result = Operator.NOT_BLOCKED;
            }
        }
        this.onMemoryReserved();
        return result;
    }

    private void onMemoryReserved() {
        this.listeners.forEach(listener -> listener.onMemoryReserved(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> reserveRevocable(QueryId queryId, long bytes) {
        Object result;
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        MemoryPool memoryPool = this;
        synchronized (memoryPool) {
            if (bytes != 0L) {
                this.queryMemoryRevocableReservations.merge(queryId, bytes, Long::sum);
            }
            this.reservedRevocableBytes += bytes;
            if (this.getFreeBytes() <= 0L) {
                if (this.future == null) {
                    this.future = NonCancellableMemoryFuture.create();
                }
                Preconditions.checkState((!this.future.isDone() ? 1 : 0) != 0, (Object)"future is already completed");
                result = this.future;
            } else {
                result = Operator.NOT_BLOCKED;
            }
        }
        this.onMemoryReserved();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryReserve(QueryId queryId, long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        MemoryPool memoryPool = this;
        synchronized (memoryPool) {
            if (this.getFreeBytes() - bytes < 0L) {
                return false;
            }
            this.reservedBytes += bytes;
            if (bytes != 0L) {
                this.queryMemoryReservations.merge(queryId, bytes, Long::sum);
            }
        }
        this.onMemoryReserved();
        return true;
    }

    public synchronized void free(QueryId queryId, long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        Preconditions.checkArgument((this.reservedBytes >= bytes ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved");
        if (bytes == 0L) {
            return;
        }
        Long queryReservation = this.queryMemoryReservations.get(queryId);
        Objects.requireNonNull(queryReservation, "queryReservation is null");
        Preconditions.checkArgument((queryReservation - bytes >= 0L ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved by query");
        queryReservation = queryReservation - bytes;
        if (queryReservation == 0L) {
            this.queryMemoryReservations.remove(queryId);
        } else {
            this.queryMemoryReservations.put(queryId, queryReservation);
        }
        this.reservedBytes -= bytes;
        if (this.getFreeBytes() > 0L && this.future != null) {
            this.future.set(null);
            this.future = null;
        }
    }

    public synchronized void freeRevocable(QueryId queryId, long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        Preconditions.checkArgument((this.reservedRevocableBytes >= bytes ? 1 : 0) != 0, (Object)"tried to free more revocable memory than is reserved");
        if (bytes == 0L) {
            return;
        }
        Long queryReservation = this.queryMemoryRevocableReservations.get(queryId);
        Objects.requireNonNull(queryReservation, "queryReservation is null");
        Preconditions.checkArgument((queryReservation - bytes >= 0L ? 1 : 0) != 0, (Object)"tried to free more revocable memory than is reserved by query");
        queryReservation = queryReservation - bytes;
        if (queryReservation == 0L) {
            this.queryMemoryRevocableReservations.remove(queryId);
        } else {
            this.queryMemoryRevocableReservations.put(queryId, queryReservation);
        }
        this.reservedRevocableBytes -= bytes;
        if (this.getFreeBytes() > 0L && this.future != null) {
            this.future.set(null);
            this.future = null;
        }
    }

    @Managed
    public synchronized long getFreeBytes() {
        return this.maxBytes - this.reservedBytes - this.reservedRevocableBytes;
    }

    @Managed
    public synchronized long getMaxBytes() {
        return this.maxBytes;
    }

    @Managed
    public synchronized long getReservedBytes() {
        return this.reservedBytes;
    }

    @Managed
    public synchronized long getReservedRevocableBytes() {
        return this.reservedRevocableBytes;
    }

    synchronized long getQueryUserMemoryReservation(QueryId queryId) {
        return this.queryMemoryReservations.getOrDefault(queryId, 0L);
    }

    synchronized long getQueryRevocableMemoryReservation(QueryId queryId) {
        return this.queryMemoryRevocableReservations.getOrDefault(queryId, 0L);
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("maxBytes", this.maxBytes).add("freeBytes", this.getFreeBytes()).add("reservedBytes", this.reservedBytes).add("reservedRevocableBytes", this.reservedRevocableBytes).add("future", this.future).toString();
    }

    private static class NonCancellableMemoryFuture<V>
    extends AbstractFuture<V> {
        private NonCancellableMemoryFuture() {
        }

        public static <V> NonCancellableMemoryFuture<V> create() {
            return new NonCancellableMemoryFuture<V>();
        }

        public boolean set(@Nullable V value) {
            return super.set(value);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException("cancellation is not supported");
        }
    }
}

