/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.memory.ClusterMemoryPool;
import com.facebook.presto.memory.ForMemoryManager;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.LowMemoryKiller;
import com.facebook.presto.memory.MemoryInfo;
import com.facebook.presto.memory.MemoryManagerConfig;
import com.facebook.presto.memory.MemoryPoolAssignment;
import com.facebook.presto.memory.MemoryPoolAssignmentsRequest;
import com.facebook.presto.memory.NoneLowMemoryKiller;
import com.facebook.presto.memory.RemoteNodeMemory;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeState;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.memory.ClusterMemoryPoolManager;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.memory.MemoryPoolInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.airlift.http.client.HttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.weakref.jmx.JmxException;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.Managed;
import org.weakref.jmx.ObjectNames;

public class ClusterMemoryManager
implements ClusterMemoryPoolManager {
    private static final Logger log = Logger.get(ClusterMemoryManager.class);
    private final ExecutorService listenerExecutor = Executors.newSingleThreadExecutor();
    private final InternalNodeManager nodeManager;
    private final LocationFactory locationFactory;
    private final HttpClient httpClient;
    private final MBeanExporter exporter;
    private final JsonCodec<MemoryInfo> memoryInfoCodec;
    private final JsonCodec<MemoryPoolAssignmentsRequest> assignmentsRequestJsonCodec;
    private final DataSize maxQueryMemory;
    private final boolean enabled;
    private final LowMemoryKiller lowMemoryKiller;
    private final Duration killOnOutOfMemoryDelay;
    private final String coordinatorId;
    private final AtomicLong memoryPoolAssignmentsVersion = new AtomicLong();
    private final AtomicLong clusterMemoryUsageBytes = new AtomicLong();
    private final AtomicLong clusterMemoryBytes = new AtomicLong();
    private final AtomicLong queriesKilledDueToOutOfMemory = new AtomicLong();
    private final Map<String, RemoteNodeMemory> nodes = new HashMap<String, RemoteNodeMemory>();
    @GuardedBy(value="this")
    private final Map<MemoryPoolId, List<Consumer<MemoryPoolInfo>>> changeListeners = new HashMap<MemoryPoolId, List<Consumer<MemoryPoolInfo>>>();
    @GuardedBy(value="this")
    private final Map<MemoryPoolId, ClusterMemoryPool> pools = new HashMap<MemoryPoolId, ClusterMemoryPool>();
    @GuardedBy(value="this")
    private long lastTimeNotOutOfMemory = System.nanoTime();
    @GuardedBy(value="this")
    private QueryId lastKilledQuery;

    @Inject
    public ClusterMemoryManager(@ForMemoryManager HttpClient httpClient, InternalNodeManager nodeManager, LocationFactory locationFactory, MBeanExporter exporter, JsonCodec<MemoryInfo> memoryInfoCodec, JsonCodec<MemoryPoolAssignmentsRequest> assignmentsRequestJsonCodec, QueryIdGenerator queryIdGenerator, LowMemoryKiller lowMemoryKiller, ServerConfig serverConfig, MemoryManagerConfig config) {
        Objects.requireNonNull(config, "config is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.exporter = Objects.requireNonNull(exporter, "exporter is null");
        this.memoryInfoCodec = Objects.requireNonNull(memoryInfoCodec, "memoryInfoCodec is null");
        this.assignmentsRequestJsonCodec = Objects.requireNonNull(assignmentsRequestJsonCodec, "assignmentsRequestJsonCodec is null");
        this.lowMemoryKiller = Objects.requireNonNull(lowMemoryKiller, "lowMemoryKiller is null");
        this.maxQueryMemory = config.getMaxQueryMemory();
        this.coordinatorId = queryIdGenerator.getCoordinatorId();
        this.enabled = serverConfig.isCoordinator();
        this.killOnOutOfMemoryDelay = config.getKillOnOutOfMemoryDelay();
    }

    public synchronized void addChangeListener(MemoryPoolId poolId, Consumer<MemoryPoolInfo> listener) {
        this.changeListeners.computeIfAbsent(poolId, id -> new ArrayList()).add(listener);
    }

    public synchronized void process(Iterable<QueryExecution> queries) {
        Optional chosenQuery;
        List nodeMemoryInfos;
        List queryMemoryInfoList;
        Optional<QueryId> chosenQueryId;
        if (!this.enabled) {
            return;
        }
        boolean outOfMemory = this.isClusterOutOfMemory();
        if (!outOfMemory) {
            this.lastTimeNotOutOfMemory = System.nanoTime();
        }
        boolean queryKilled = false;
        long totalBytes = 0L;
        for (QueryExecution query2 : queries) {
            long bytes = query2.getTotalMemoryReservation();
            DataSize sessionMaxQueryMemory = SystemSessionProperties.getQueryMaxMemory(query2.getSession());
            long queryMemoryLimit = Math.min(this.maxQueryMemory.toBytes(), sessionMaxQueryMemory.toBytes());
            totalBytes += bytes;
            if (SystemSessionProperties.resourceOvercommit(query2.getSession()) && outOfMemory) {
                DataSize memory = DataSize.succinctBytes((long)bytes);
                query2.fail((Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.CLUSTER_OUT_OF_MEMORY, String.format("The cluster is out of memory and %s=true, so this query was killed. It was using %s of memory", "resource_overcommit", memory)));
                queryKilled = true;
            }
            if (SystemSessionProperties.resourceOvercommit(query2.getSession()) || bytes <= queryMemoryLimit) continue;
            DataSize maxMemory = DataSize.succinctBytes((long)queryMemoryLimit);
            query2.fail((Throwable)((Object)ExceededMemoryLimitException.exceededGlobalLimit(maxMemory)));
            queryKilled = true;
        }
        this.clusterMemoryUsageBytes.set(totalBytes);
        if (!(this.lowMemoryKiller instanceof NoneLowMemoryKiller) && outOfMemory && !queryKilled && Duration.nanosSince((long)this.lastTimeNotOutOfMemory).compareTo(this.killOnOutOfMemoryDelay) > 0 && this.isLastKilledQueryGone() && (chosenQueryId = this.lowMemoryKiller.chooseQueryToKill(queryMemoryInfoList = (List)Streams.stream(queries).map(query -> new LowMemoryKiller.QueryMemoryInfo(query.getQueryId(), query.getMemoryPool().getId(), query.getTotalMemoryReservation())).collect(ImmutableList.toImmutableList()), nodeMemoryInfos = (List)this.nodes.values().stream().map(RemoteNodeMemory::getInfo).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList()))).isPresent() && (chosenQuery = (Optional)Streams.stream(queries).filter(query -> ((QueryId)chosenQueryId.get()).equals((Object)query.getQueryId())).collect(MoreCollectors.toOptional())).isPresent()) {
            ((QueryExecution)chosenQuery.get()).fail((Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.CLUSTER_OUT_OF_MEMORY, "Query killed because the cluster is out of memory. Please try again in a few minutes."));
            this.queriesKilledDueToOutOfMemory.incrementAndGet();
            this.lastKilledQuery = chosenQueryId.get();
            this.logQueryKill(chosenQueryId.get(), nodeMemoryInfos);
        }
        HashMap<MemoryPoolId, Integer> countByPool = new HashMap<MemoryPoolId, Integer>();
        for (QueryExecution query3 : queries) {
            MemoryPoolId id = query3.getMemoryPool().getId();
            countByPool.put(id, countByPool.getOrDefault(id, 0) + 1);
        }
        this.updatePools(countByPool);
        this.updateNodes(this.updateAssignments(queries));
    }

    @GuardedBy(value="this")
    private boolean isLastKilledQueryGone() {
        if (this.lastKilledQuery == null) {
            return true;
        }
        ClusterMemoryPool generalPool = this.pools.get(LocalMemoryManager.GENERAL_POOL);
        if (generalPool == null) {
            return false;
        }
        return !generalPool.getQueryMemoryReservations().containsKey(this.lastKilledQuery);
    }

    private void logQueryKill(QueryId killedQueryId, List<MemoryInfo> nodes) {
        if (!log.isInfoEnabled()) {
            return;
        }
        StringBuilder nodeDescription = new StringBuilder();
        nodeDescription.append("Query Kill Decision: Killed ").append(killedQueryId).append("\n");
        for (MemoryInfo node : nodes) {
            MemoryPoolInfo memoryPoolInfo = node.getPools().get(LocalMemoryManager.GENERAL_POOL);
            if (memoryPoolInfo == null) continue;
            nodeDescription.append("Query Kill Scenario: ");
            nodeDescription.append("MaxBytes ").append(memoryPoolInfo.getMaxBytes()).append(' ');
            nodeDescription.append("FreeBytes ").append(memoryPoolInfo.getFreeBytes() + memoryPoolInfo.getReservedRevocableBytes()).append(' ');
            nodeDescription.append("Queries ");
            Joiner.on((String)",").withKeyValueSeparator("=").appendTo(nodeDescription, memoryPoolInfo.getQueryMemoryReservations());
            nodeDescription.append('\n');
        }
        log.info(nodeDescription.toString());
    }

    @VisibleForTesting
    synchronized Map<MemoryPoolId, ClusterMemoryPool> getPools() {
        return ImmutableMap.copyOf(this.pools);
    }

    private synchronized boolean isClusterOutOfMemory() {
        ClusterMemoryPool reservedPool = this.pools.get(LocalMemoryManager.RESERVED_POOL);
        ClusterMemoryPool generalPool = this.pools.get(LocalMemoryManager.GENERAL_POOL);
        return reservedPool != null && generalPool != null && reservedPool.getAssignedQueries() > 0 && generalPool.getBlockedNodes() > 0;
    }

    private synchronized MemoryPoolAssignmentsRequest updateAssignments(Iterable<QueryExecution> queries) {
        ClusterMemoryPool reservedPool = this.pools.get(LocalMemoryManager.RESERVED_POOL);
        ClusterMemoryPool generalPool = this.pools.get(LocalMemoryManager.GENERAL_POOL);
        long version = this.memoryPoolAssignmentsVersion.incrementAndGet();
        if (reservedPool != null && generalPool != null && this.allAssignmentsHavePropagated(queries) && reservedPool.getAssignedQueries() == 0 && generalPool.getBlockedNodes() > 0) {
            QueryExecution biggestQuery = null;
            long maxMemory = -1L;
            for (QueryExecution queryExecution : queries) {
                long bytesUsed;
                if (SystemSessionProperties.resourceOvercommit(queryExecution.getSession()) || (bytesUsed = queryExecution.getTotalMemoryReservation()) <= maxMemory) continue;
                biggestQuery = queryExecution;
                maxMemory = bytesUsed;
            }
            if (biggestQuery != null) {
                biggestQuery.setMemoryPool(new VersionedMemoryPoolId(LocalMemoryManager.RESERVED_POOL, version));
            }
        }
        ImmutableList.Builder assignments = ImmutableList.builder();
        for (QueryExecution queryExecution : queries) {
            assignments.add((Object)new MemoryPoolAssignment(queryExecution.getQueryId(), queryExecution.getMemoryPool().getId()));
        }
        return new MemoryPoolAssignmentsRequest(this.coordinatorId, version, (List<MemoryPoolAssignment>)assignments.build());
    }

    private boolean allAssignmentsHavePropagated(Iterable<QueryExecution> queries) {
        long mostOutOfDateNode;
        if (this.nodes.isEmpty()) {
            return false;
        }
        long newestAssignment = ImmutableList.copyOf(queries).stream().map(QueryExecution::getMemoryPool).mapToLong(VersionedMemoryPoolId::getVersion).min().orElse(-1L);
        return newestAssignment <= (mostOutOfDateNode = this.nodes.values().stream().mapToLong(RemoteNodeMemory::getCurrentAssignmentVersion).min().orElse(Long.MAX_VALUE));
    }

    private void updateNodes(MemoryPoolAssignmentsRequest assignments) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableSet aliveNodes = builder.addAll(this.nodeManager.getNodes(NodeState.ACTIVE)).addAll(this.nodeManager.getNodes(NodeState.SHUTTING_DOWN)).build();
        ImmutableSet aliveNodeIds = (ImmutableSet)aliveNodes.stream().map(Node::getNodeIdentifier).collect(ImmutableSet.toImmutableSet());
        ImmutableSet deadNodes = ImmutableSet.copyOf((Collection)Sets.difference(this.nodes.keySet(), (Set)aliveNodeIds));
        this.nodes.keySet().removeAll((Collection<?>)deadNodes);
        for (Node node : aliveNodes) {
            if (this.nodes.containsKey(node.getNodeIdentifier())) continue;
            this.nodes.put(node.getNodeIdentifier(), new RemoteNodeMemory(this.httpClient, this.memoryInfoCodec, this.assignmentsRequestJsonCodec, this.locationFactory.createMemoryInfoLocation(node)));
        }
        for (RemoteNodeMemory remoteNodeMemory : this.nodes.values()) {
            remoteNodeMemory.asyncRefresh(assignments);
        }
    }

    private synchronized void updatePools(Map<MemoryPoolId, Integer> queryCounts) {
        List nodeMemoryInfos = (List)this.nodes.values().stream().map(RemoteNodeMemory::getInfo).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
        long totalClusterMemory = nodeMemoryInfos.stream().map(MemoryInfo::getTotalNodeMemory).mapToLong(DataSize::toBytes).sum();
        this.clusterMemoryBytes.set(totalClusterMemory);
        Set activePoolIds = (Set)nodeMemoryInfos.stream().flatMap(info -> info.getPools().keySet().stream()).collect(ImmutableSet.toImmutableSet());
        ImmutableSet removedPools = ImmutableSet.copyOf((Collection)Sets.difference(this.pools.keySet(), (Set)activePoolIds));
        for (MemoryPoolId removed : removedPools) {
            this.unexport(this.pools.get(removed));
            this.pools.remove(removed);
            if (!this.changeListeners.containsKey(removed)) continue;
            for (Consumer<MemoryPoolInfo> listener : this.changeListeners.get(removed)) {
                this.listenerExecutor.execute(() -> listener.accept(new MemoryPoolInfo(0L, 0L, 0L, (Map)ImmutableMap.of(), (Map)ImmutableMap.of())));
            }
        }
        for (MemoryPoolId id : activePoolIds) {
            ClusterMemoryPool pool = this.pools.computeIfAbsent(id, poolId -> {
                ClusterMemoryPool newPool = new ClusterMemoryPool((MemoryPoolId)poolId);
                String objectName = ObjectNames.builder(ClusterMemoryPool.class, (String)newPool.getId().toString()).build();
                try {
                    this.exporter.export(objectName, (Object)newPool);
                }
                catch (JmxException e) {
                    log.error((Throwable)e, "Error exporting memory pool %s", new Object[]{poolId});
                }
                return newPool;
            });
            pool.update(nodeMemoryInfos, queryCounts.getOrDefault(pool.getId(), 0));
            if (!this.changeListeners.containsKey(id)) continue;
            MemoryPoolInfo info2 = pool.getInfo();
            for (Consumer<MemoryPoolInfo> listener : this.changeListeners.get(id)) {
                this.listenerExecutor.execute(() -> listener.accept(info2));
            }
        }
    }

    @PreDestroy
    public synchronized void destroy() {
        try {
            for (ClusterMemoryPool pool : this.pools.values()) {
                this.unexport(pool);
            }
            this.pools.clear();
        }
        finally {
            this.listenerExecutor.shutdownNow();
        }
    }

    private void unexport(ClusterMemoryPool pool) {
        try {
            String objectName = ObjectNames.builder(ClusterMemoryPool.class, (String)pool.getId().toString()).build();
            this.exporter.unexport(objectName);
        }
        catch (JmxException e) {
            log.error((Throwable)e, "Failed to unexport pool %s", new Object[]{pool.getId()});
        }
    }

    @Managed
    public long getClusterMemoryUsageBytes() {
        return this.clusterMemoryUsageBytes.get();
    }

    @Managed
    public long getClusterMemoryBytes() {
        return this.clusterMemoryBytes.get();
    }

    @Managed
    public long getQueriesKilledDueToOutOfMemory() {
        return this.queriesKilledDueToOutOfMemory.get();
    }
}

