/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.execution.resourceGroups.Queue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

final class WeightedFairQueue<E>
implements Queue<E> {
    private final Map<E, Node<E>> index = new LinkedHashMap<E, Node<E>>();

    WeightedFairQueue() {
    }

    public boolean addOrUpdate(E element, Usage usage) {
        Node<E> node = this.index.get(element);
        if (node != null) {
            node.update(usage);
            return false;
        }
        node = new Node(element, usage);
        this.index.put(element, node);
        return true;
    }

    @Override
    public E peek() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(E element) {
        return this.index.containsKey(element);
    }

    @Override
    public boolean remove(E element) {
        Node<E> node = this.index.remove(element);
        return node != null;
    }

    @Override
    public E poll() {
        Collection<Node<E>> candidates = this.index.values();
        long totalShare = 0L;
        long totalUtilization = 1L;
        for (Node<E> candidate : candidates) {
            totalShare += (long)candidate.getShare();
            totalUtilization += (long)candidate.getUtilization();
        }
        ArrayList<Node<Node<E>>> winners = new ArrayList<Node<Node<E>>>();
        double winnerDelta = 1.0;
        for (Node<E> candidate : candidates) {
            double expectedFraction;
            double actualFraction = 1.0 * (double)candidate.getUtilization() / (double)totalUtilization;
            double delta = actualFraction / (expectedFraction = 1.0 * (double)candidate.getShare() / (double)totalShare);
            if (!(delta <= winnerDelta)) continue;
            if (delta < winnerDelta) {
                winnerDelta = delta;
                winners.clear();
            }
            winners.add(candidate);
        }
        E winner = this.pickWinner(winners);
        this.index.remove(winner);
        return winner;
    }

    private E pickWinner(List<Node<E>> winners) {
        if (winners.isEmpty()) {
            return null;
        }
        if (winners.size() == 1) {
            return winners.get(0).getValue();
        }
        long totalShares = winners.stream().mapToLong(Node::getShare).sum();
        long winningTicket = ThreadLocalRandom.current().nextLong(0L, totalShares);
        long cumulativeShare = 0L;
        for (Node<E> winner : winners) {
            if (cumulativeShare + (long)winner.getShare() > winningTicket) {
                return winner.getValue();
            }
            cumulativeShare += (long)winner.getShare();
        }
        throw new IllegalStateException("A winner should already have been picked");
    }

    @Override
    public int size() {
        return this.index.size();
    }

    @Override
    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.index.keySet().iterator();
    }

    private static final class Node<E> {
        private final E value;
        private Usage usage;

        private Node(E value, Usage usage) {
            this.value = Objects.requireNonNull(value, "value is null");
            this.usage = Objects.requireNonNull(usage, "usage is null");
        }

        public E getValue() {
            return this.value;
        }

        public void update(Usage usage) {
            this.usage = Objects.requireNonNull(usage, "usage is null");
        }

        public int getShare() {
            return this.usage.getShare();
        }

        public int getUtilization() {
            return this.usage.getUtilization();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("usage", (Object)this.usage).toString();
        }
    }

    public static class Usage {
        private final int share;
        private final int utilization;

        public Usage(int share, int utilization) {
            Preconditions.checkArgument((share > 0 ? 1 : 0) != 0, (Object)"share must be positive");
            Preconditions.checkArgument((utilization >= 0 ? 1 : 0) != 0, (Object)"utilization must be zero or positive");
            this.share = share;
            this.utilization = utilization;
        }

        public int getShare() {
            return this.share;
        }

        public int getUtilization() {
            return this.utilization;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("share", this.share).add("utilization", this.utilization).toString();
        }
    }
}

