/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.resourceGroups.QueryType;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public interface QueryExecution {
    public QueryId getQueryId();

    public QueryInfo getQueryInfo();

    public QueryState getState();

    public ListenableFuture<QueryState> getStateChange(QueryState var1);

    public void addOutputInfoListener(Consumer<QueryOutputInfo> var1);

    public Optional<ResourceGroupId> getResourceGroup();

    public void setResourceGroup(ResourceGroupId var1);

    public Plan getQueryPlan();

    public VersionedMemoryPoolId getMemoryPool();

    public void setMemoryPool(VersionedMemoryPoolId var1);

    public long getTotalMemoryReservation();

    public Duration getTotalCpuTime();

    public Session getSession();

    public void start();

    public void fail(Throwable var1);

    public void cancelQuery();

    public void cancelStage(StageId var1);

    public void recordHeartbeat();

    public void pruneInfo();

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> var1);

    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> var1);

    public Optional<QueryType> getQueryType();

    public static class QueryOutputInfo {
        private final List<String> columnNames;
        private final List<Type> columnTypes;
        private final Set<URI> bufferLocations;
        private final boolean noMoreBufferLocations;

        public QueryOutputInfo(List<String> columnNames, List<Type> columnTypes, Set<URI> bufferLocations, boolean noMoreBufferLocations) {
            this.columnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames, "columnNames is null"));
            this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
            this.bufferLocations = ImmutableSet.copyOf((Collection)Objects.requireNonNull(bufferLocations, "bufferLocations is null"));
            this.noMoreBufferLocations = noMoreBufferLocations;
        }

        public List<String> getColumnNames() {
            return this.columnNames;
        }

        public List<Type> getColumnTypes() {
            return this.columnTypes;
        }

        public Set<URI> getBufferLocations() {
            return this.bufferLocations;
        }

        public boolean isNoMoreBufferLocations() {
            return this.noMoreBufferLocations;
        }
    }

    public static interface QueryExecutionFactory<T extends QueryExecution> {
        public T createQueryExecution(QueryId var1, String var2, Session var3, Statement var4, List<Expression> var5);
    }
}

