/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SimplePlanVisitor;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class PlanFlattener {
    private final QueryExplainer explainer;
    private final FlatteningVisitor visitor;

    @Inject
    public PlanFlattener(QueryExplainer explainer, ObjectMapper objectMapper) {
        this.explainer = Objects.requireNonNull(explainer, "explainer is null");
        this.visitor = new FlatteningVisitor(Objects.requireNonNull(objectMapper, "objectMapper is null"));
    }

    public FlattenedPlan flatten(SubPlan rootStage, Session session) {
        return new FlattenedPlan(rootStage.getAllFragments().stream().map(fragment -> FlattenedPlanFragment.fromPlanFragment(fragment, this.explainer, session, this.visitor)).collect(Collectors.toList()));
    }

    private static class PlanNodeFlatteningSerializer
    extends JsonSerializer<PlanNode> {
        private final SerializerProvider provider;
        private final JsonSerializer<Object> superTypeSerializer;
        private boolean rootLevel = true;

        public PlanNodeFlatteningSerializer(SerializerProvider provider) {
            this.provider = provider;
            try {
                this.superTypeSerializer = provider.findTypedValueSerializer(PlanNode.class, false, null);
            }
            catch (JsonMappingException e) {
                throw new RuntimeException("Unable to serialize plan node", e);
            }
        }

        public void serialize(PlanNode value, JsonGenerator jgen, SerializerProvider provider) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serializeWithType(PlanNode value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            if (this.rootLevel) {
                this.rootLevel = false;
                try {
                    JsonSerializer subTypeSerializer = this.provider.findTypedValueSerializer(value.getClass(), true, null);
                    subTypeSerializer.serializeWithType((Object)value, gen, serializers, typeSer);
                }
                finally {
                    this.rootLevel = true;
                }
                return;
            }
            this.superTypeSerializer.serializeWithType((Object)value, gen, serializers, typeSer);
        }
    }

    private static class FlatteningVisitor
    extends SimplePlanVisitor<ImmutableList.Builder<FlattenedNode>> {
        private final ObjectMapper flatteningMapper;

        public FlatteningVisitor(ObjectMapper originalMapper) {
            this.flatteningMapper = originalMapper.copy();
            PlanNodeFlatteningSerializer flattener = new PlanNodeFlatteningSerializer(originalMapper.getSerializerProviderInstance());
            this.flatteningMapper.registerModule((Module)new SimpleModule().addSerializer(PlanNode.class, (JsonSerializer)flattener));
        }

        @Override
        protected Void visitPlan(PlanNode node, ImmutableList.Builder<FlattenedNode> context) {
            try {
                context.add((Object)new FlattenedNode(this.flatteningMapper.writeValueAsString((Object)node)));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Unable to flatten plan node", e);
            }
            return super.visitPlan(node, context);
        }
    }

    public static class FlattenedNode {
        private final String node;

        public FlattenedNode(String node) {
            this.node = Objects.requireNonNull(node, "node is null");
        }

        @JsonValue
        @JsonRawValue
        public String getNode() {
            return this.node;
        }
    }

    public static class FlattenedPlanFragment {
        private final String textPlan;
        private final List<FlattenedNode> nodes;
        private final PlanFragment fragment;

        public static FlattenedPlanFragment fromPlanFragment(PlanFragment fragment, QueryExplainer explainer, Session session, FlatteningVisitor visitor) {
            ImmutableList.Builder nodes = ImmutableList.builder();
            fragment.getRoot().accept(visitor, nodes);
            return new FlattenedPlanFragment(explainer.getPlan(fragment, session), fragment, (List<FlattenedNode>)nodes.build());
        }

        private FlattenedPlanFragment(String textPlan, PlanFragment fragment, List<FlattenedNode> nodes) {
            this.textPlan = Objects.requireNonNull(textPlan, "textPlan is null");
            this.fragment = Objects.requireNonNull(fragment, "fragment is null");
            this.nodes = ImmutableList.copyOf((Collection)Objects.requireNonNull(nodes, "nodes is null"));
        }

        @JsonProperty
        public PlanFragmentId getId() {
            return this.fragment.getId();
        }

        @JsonProperty
        public String getTextPlan() {
            return this.textPlan;
        }

        @JsonProperty
        public PlanNode getTree() {
            return this.fragment.getRoot();
        }

        @JsonProperty
        public List<FlattenedNode> getNodes() {
            return this.nodes;
        }

        @JsonProperty
        public Map<Symbol, Type> getSymbols() {
            return this.fragment.getSymbols();
        }

        @JsonProperty
        public PartitioningHandle getPartitioning() {
            return this.fragment.getPartitioning();
        }

        @JsonProperty
        public List<PlanNodeId> getPartitionedSources() {
            return this.fragment.getPartitionedSources();
        }

        @JsonProperty
        public List<Type> getTypes() {
            return this.fragment.getTypes();
        }

        @JsonProperty
        public Set<PlanNode> getPartitionedSourceNodes() {
            return this.fragment.getPartitionedSourceNodes();
        }

        @JsonProperty
        public List<RemoteSourceNode> getRemoteSourceNodes() {
            return this.fragment.getRemoteSourceNodes();
        }

        @JsonProperty
        public PartitioningScheme getPartitioningScheme() {
            return this.fragment.getPartitioningScheme();
        }
    }

    public static class FlattenedPlan {
        private final List<FlattenedPlanFragment> fragments;

        private FlattenedPlan(List<FlattenedPlanFragment> fragments) {
            this.fragments = ImmutableList.copyOf((Collection)Objects.requireNonNull(fragments, "fragments is null"));
        }

        @JsonProperty
        public List<FlattenedPlanFragment> getFragments() {
            return this.fragments;
        }
    }
}

