/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.event.query;

import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.event.query.QueryMonitorConfig;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.execution.Column;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.TableFinishInfo;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.eventlistener.QueryCompletedEvent;
import com.facebook.presto.spi.eventlistener.QueryContext;
import com.facebook.presto.spi.eventlistener.QueryCreatedEvent;
import com.facebook.presto.spi.eventlistener.QueryFailureInfo;
import com.facebook.presto.spi.eventlistener.QueryIOMetadata;
import com.facebook.presto.spi.eventlistener.QueryInputMetadata;
import com.facebook.presto.spi.eventlistener.QueryMetadata;
import com.facebook.presto.spi.eventlistener.QueryOutputMetadata;
import com.facebook.presto.spi.eventlistener.QueryStatistics;
import com.facebook.presto.spi.eventlistener.SplitCompletedEvent;
import com.facebook.presto.spi.eventlistener.SplitFailureInfo;
import com.facebook.presto.spi.eventlistener.SplitStatistics;
import com.facebook.presto.spi.eventlistener.StageCpuDistribution;
import com.facebook.presto.transaction.TransactionId;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.airlift.stats.Distribution;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.joda.time.DateTime;

public class QueryMonitor {
    private static final Logger log = Logger.get(QueryMonitor.class);
    private final JsonCodec<StageInfo> stageInfoCodec;
    private final ObjectMapper objectMapper;
    private final EventListenerManager eventListenerManager;
    private final String serverVersion;
    private final String serverAddress;
    private final String environment;
    private final QueryMonitorConfig config;

    @Inject
    public QueryMonitor(ObjectMapper objectMapper, JsonCodec<StageInfo> stageInfoCodec, EventListenerManager eventListenerManager, NodeInfo nodeInfo, NodeVersion nodeVersion, QueryMonitorConfig config) {
        this.eventListenerManager = Objects.requireNonNull(eventListenerManager, "eventListenerManager is null");
        this.stageInfoCodec = Objects.requireNonNull(stageInfoCodec, "stageInfoCodec is null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
        this.serverVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null").toString();
        this.serverAddress = Objects.requireNonNull(nodeInfo, "nodeInfo is null").getExternalAddress();
        this.environment = Objects.requireNonNull(nodeInfo, "nodeInfo is null").getEnvironment();
        this.config = Objects.requireNonNull(config, "config is null");
    }

    public void queryCreatedEvent(QueryInfo queryInfo) {
        Optional<Object> plan = Optional.empty();
        try {
            if (queryInfo.getPlan().isPresent()) {
                plan = Optional.of(this.objectMapper.writeValueAsString((Object)queryInfo.getPlan().get()));
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        this.eventListenerManager.queryCreated(new QueryCreatedEvent(queryInfo.getQueryStats().getCreateTime().toDate().toInstant(), new QueryContext(queryInfo.getSession().getUser(), queryInfo.getSession().getPrincipal(), queryInfo.getSession().getRemoteUserAddress(), queryInfo.getSession().getUserAgent(), queryInfo.getSession().getClientInfo(), queryInfo.getSession().getClientTags(), queryInfo.getSession().getSource(), queryInfo.getSession().getCatalog(), queryInfo.getSession().getSchema(), queryInfo.getResourceGroupName(), QueryMonitor.mergeSessionAndCatalogProperties(queryInfo), this.serverAddress, this.serverVersion, this.environment), new QueryMetadata(queryInfo.getQueryId().toString(), queryInfo.getSession().getTransactionId().map(TransactionId::toString), queryInfo.getQuery(), queryInfo.getState().toString(), queryInfo.getSelf(), plan, Optional.empty())));
    }

    public void queryCompletedEvent(QueryInfo queryInfo) {
        try {
            Optional<Object> queryFailureInfo = Optional.empty();
            if (queryInfo.getFailureInfo() != null) {
                FailureInfo failureInfo = queryInfo.getFailureInfo();
                Optional failedTask = queryInfo.getOutputStage().flatMap(QueryMonitor::findFailedTask);
                queryFailureInfo = Optional.of(new QueryFailureInfo(queryInfo.getErrorCode(), Optional.ofNullable(failureInfo.getType()), Optional.ofNullable(failureInfo.getMessage()), failedTask.map(task -> task.getTaskStatus().getTaskId().toString()), failedTask.map(task -> task.getTaskStatus().getSelf().getHost()), this.objectMapper.writeValueAsString((Object)queryInfo.getFailureInfo())));
            }
            ImmutableList.Builder inputs = ImmutableList.builder();
            for (Input input : queryInfo.getInputs()) {
                inputs.add((Object)new QueryInputMetadata(input.getConnectorId().getCatalogName(), input.getSchema(), input.getTable(), input.getColumns().stream().map(Column::getName).collect(Collectors.toList()), input.getConnectorInfo()));
            }
            QueryStats queryStats = queryInfo.getQueryStats();
            Optional<Object> output = Optional.empty();
            if (queryInfo.getOutput().isPresent()) {
                Optional<TableFinishInfo> tableFinishInfo = queryStats.getOperatorSummaries().stream().map(OperatorStats::getInfo).filter(TableFinishInfo.class::isInstance).map(TableFinishInfo.class::cast).findFirst();
                output = Optional.of(new QueryOutputMetadata(queryInfo.getOutput().get().getConnectorId().getCatalogName(), queryInfo.getOutput().get().getSchema(), queryInfo.getOutput().get().getTable(), tableFinishInfo.map(TableFinishInfo::getConnectorOutputMetadata), tableFinishInfo.map(TableFinishInfo::isJsonLengthLimitExceeded)));
            }
            ImmutableList.Builder operatorSummaries = ImmutableList.builder();
            for (OperatorStats summary : queryInfo.getQueryStats().getOperatorSummaries()) {
                operatorSummaries.add((Object)this.objectMapper.writeValueAsString((Object)summary));
            }
            Optional<Object> plan = Optional.empty();
            if (queryInfo.getPlan().isPresent()) {
                plan = Optional.of(this.objectMapper.writeValueAsString((Object)queryInfo.getPlan().get()));
            }
            this.eventListenerManager.queryCompleted(new QueryCompletedEvent(new QueryMetadata(queryInfo.getQueryId().toString(), queryInfo.getSession().getTransactionId().map(TransactionId::toString), queryInfo.getQuery(), queryInfo.getState().toString(), queryInfo.getSelf(), plan, queryInfo.getOutputStage().flatMap(stage -> this.stageInfoCodec.toJsonWithLengthLimit(stage, Math.toIntExact(this.config.getMaxOutputStageJsonSize().toBytes())))), new QueryStatistics(Duration.ofMillis(queryStats.getTotalCpuTime().toMillis()), Duration.ofMillis(queryStats.getTotalScheduledTime().toMillis()), Duration.ofMillis(queryStats.getQueuedTime().toMillis()), Optional.ofNullable(queryStats.getAnalysisTime()).map(duration -> Duration.ofMillis(duration.toMillis())), Optional.ofNullable(queryStats.getDistributedPlanningTime()).map(duration -> Duration.ofMillis(duration.toMillis())), queryStats.getPeakUserMemoryReservation().toBytes(), queryStats.getPeakTotalMemoryReservation().toBytes(), queryStats.getRawInputDataSize().toBytes(), queryStats.getRawInputPositions(), queryStats.getOutputDataSize().toBytes(), queryStats.getOutputPositions(), queryStats.getLogicalWrittenDataSize().toBytes(), queryStats.getWrittenPositions(), queryStats.getCumulativeMemory(), queryStats.getCompletedDrivers(), queryInfo.isCompleteInfo(), QueryMonitor.getCpuDistributions(queryInfo), (List)operatorSummaries.build()), new QueryContext(queryInfo.getSession().getUser(), queryInfo.getSession().getPrincipal(), queryInfo.getSession().getRemoteUserAddress(), queryInfo.getSession().getUserAgent(), queryInfo.getSession().getClientInfo(), queryInfo.getSession().getClientTags(), queryInfo.getSession().getSource(), queryInfo.getSession().getCatalog(), queryInfo.getSession().getSchema(), queryInfo.getResourceGroupName(), QueryMonitor.mergeSessionAndCatalogProperties(queryInfo), this.serverAddress, this.serverVersion, this.environment), new QueryIOMetadata((List)inputs.build(), output), queryFailureInfo, Instant.ofEpochMilli(queryStats.getCreateTime().getMillis()), Instant.ofEpochMilli(queryStats.getExecutionStartTime().getMillis()), Instant.ofEpochMilli(queryStats.getEndTime().getMillis())));
            QueryMonitor.logQueryTimeline(queryInfo);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static Optional<TaskInfo> findFailedTask(StageInfo stageInfo) {
        for (StageInfo subStage : stageInfo.getSubStages()) {
            Optional<TaskInfo> task = QueryMonitor.findFailedTask(subStage);
            if (!task.isPresent()) continue;
            return task;
        }
        return stageInfo.getTasks().stream().filter(taskInfo -> taskInfo.getTaskStatus().getState() == TaskState.FAILED).findFirst();
    }

    private static Map<String, String> mergeSessionAndCatalogProperties(QueryInfo queryInfo) {
        ImmutableMap.Builder mergedProperties = ImmutableMap.builder();
        mergedProperties.putAll(queryInfo.getSession().getSystemProperties());
        for (Map.Entry<ConnectorId, Map<String, String>> catalogEntry : queryInfo.getSession().getCatalogProperties().entrySet()) {
            for (Map.Entry<String, String> entry : catalogEntry.getValue().entrySet()) {
                mergedProperties.put((Object)(catalogEntry.getKey().getCatalogName() + "." + entry.getKey()), (Object)entry.getValue());
            }
        }
        return mergedProperties.build();
    }

    private static void logQueryTimeline(QueryInfo queryInfo) {
        try {
            QueryStats queryStats = queryInfo.getQueryStats();
            DateTime queryStartTime = queryStats.getCreateTime();
            DateTime queryEndTime = queryStats.getEndTime();
            if (queryStartTime == null || queryEndTime == null) {
                return;
            }
            long planning = queryStats.getTotalPlanningTime() == null ? 0L : queryStats.getTotalPlanningTime().toMillis();
            List<StageInfo> stages = StageInfo.getAllStages(queryInfo.getOutputStage());
            long firstTaskStartTime = queryEndTime.getMillis();
            long lastTaskStartTime = queryStartTime.getMillis() + planning;
            long lastTaskEndTime = queryStartTime.getMillis() + planning;
            for (StageInfo stage : stages) {
                if (!stage.getSubStages().isEmpty()) continue;
                for (TaskInfo taskInfo : stage.getTasks()) {
                    DateTime endTime;
                    DateTime lastStartTime;
                    TaskStats taskStats = taskInfo.getStats();
                    DateTime firstStartTime = taskStats.getFirstStartTime();
                    if (firstStartTime != null) {
                        firstTaskStartTime = Math.min(firstStartTime.getMillis(), firstTaskStartTime);
                    }
                    if ((lastStartTime = taskStats.getLastStartTime()) != null) {
                        lastTaskStartTime = Math.max(lastStartTime.getMillis(), lastTaskStartTime);
                    }
                    if ((endTime = taskStats.getEndTime()) == null) continue;
                    lastTaskEndTime = Math.max(endTime.getMillis(), lastTaskEndTime);
                }
            }
            long elapsed = queryEndTime.getMillis() - queryStartTime.getMillis();
            long scheduling = firstTaskStartTime - queryStartTime.getMillis() - planning;
            long running = lastTaskEndTime - firstTaskStartTime;
            long finishing = queryEndTime.getMillis() - lastTaskEndTime;
            log.info("TIMELINE: Query %s :: Transaction:[%s] :: elapsed %sms :: planning %sms :: scheduling %sms :: running %sms :: finishing %sms :: begin %s :: end %s", new Object[]{queryInfo.getQueryId(), queryInfo.getSession().getTransactionId().map(TransactionId::toString).orElse(""), Math.max(elapsed, 0L), Math.max(planning, 0L), Math.max(scheduling, 0L), Math.max(running, 0L), Math.max(finishing, 0L), queryStartTime, queryEndTime});
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error logging query timeline");
        }
    }

    public void splitCompletedEvent(TaskId taskId, DriverStats driverStats) {
        this.splitCompletedEvent(taskId, driverStats, null, null);
    }

    public void splitFailedEvent(TaskId taskId, DriverStats driverStats, Throwable cause) {
        this.splitCompletedEvent(taskId, driverStats, cause.getClass().getName(), cause.getMessage());
    }

    private void splitCompletedEvent(TaskId taskId, DriverStats driverStats, @Nullable String failureType, @Nullable String failureMessage) {
        Optional<Object> timeToStart = Optional.empty();
        if (driverStats.getStartTime() != null) {
            timeToStart = Optional.of(Duration.ofMillis(driverStats.getStartTime().getMillis() - driverStats.getCreateTime().getMillis()));
        }
        Optional<Object> timeToEnd = Optional.empty();
        if (driverStats.getEndTime() != null) {
            timeToEnd = Optional.of(Duration.ofMillis(driverStats.getEndTime().getMillis() - driverStats.getCreateTime().getMillis()));
        }
        Optional<Object> splitFailureMetadata = Optional.empty();
        if (failureType != null) {
            splitFailureMetadata = Optional.of(new SplitFailureInfo(failureType, failureMessage != null ? failureMessage : ""));
        }
        try {
            this.eventListenerManager.splitCompleted(new SplitCompletedEvent(taskId.getQueryId().toString(), taskId.getStageId().toString(), Integer.toString(taskId.getId()), driverStats.getCreateTime().toDate().toInstant(), Optional.ofNullable(driverStats.getStartTime()).map(startTime -> startTime.toDate().toInstant()), Optional.ofNullable(driverStats.getEndTime()).map(endTime -> endTime.toDate().toInstant()), new SplitStatistics(Duration.ofMillis(driverStats.getTotalCpuTime().toMillis()), Duration.ofMillis(driverStats.getElapsedTime().toMillis()), Duration.ofMillis(driverStats.getQueuedTime().toMillis()), Duration.ofMillis(driverStats.getTotalUserTime().toMillis()), Duration.ofMillis(driverStats.getRawInputReadTime().toMillis()), driverStats.getRawInputPositions(), driverStats.getRawInputDataSize().toBytes(), timeToStart, timeToEnd), splitFailureMetadata, this.objectMapper.writeValueAsString((Object)driverStats)));
        }
        catch (JsonProcessingException e) {
            log.error((Throwable)e, "Error processing split completion event for task %s", new Object[]{taskId});
        }
    }

    private static List<StageCpuDistribution> getCpuDistributions(QueryInfo queryInfo) {
        if (!queryInfo.getOutputStage().isPresent()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        QueryMonitor.populateDistribution(queryInfo.getOutputStage().get(), (ImmutableList.Builder<StageCpuDistribution>)builder);
        return builder.build();
    }

    private static void populateDistribution(StageInfo stageInfo, ImmutableList.Builder<StageCpuDistribution> distributions) {
        distributions.add((Object)QueryMonitor.computeCpuDistribution(stageInfo));
        for (StageInfo subStage : stageInfo.getSubStages()) {
            QueryMonitor.populateDistribution(subStage, distributions);
        }
    }

    private static StageCpuDistribution computeCpuDistribution(StageInfo stageInfo) {
        Distribution cpuDistribution = new Distribution();
        for (TaskInfo taskInfo : stageInfo.getTasks()) {
            cpuDistribution.add(taskInfo.getStats().getTotalCpuTime().toMillis());
        }
        Distribution.DistributionSnapshot snapshot = cpuDistribution.snapshot();
        return new StageCpuDistribution(stageInfo.getStageId().getId(), stageInfo.getTasks().size(), snapshot.getP25(), snapshot.getP50(), snapshot.getP75(), snapshot.getP90(), snapshot.getP95(), snapshot.getP99(), snapshot.getMin(), snapshot.getMax(), (long)snapshot.getTotal(), snapshot.getTotal() / snapshot.getCount());
    }
}

