/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.ComposableStatsCalculator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.cost.StatsUtil;
import com.facebook.presto.cost.SymbolStatsEstimate;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.DomainTranslator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;

public class TableScanStatsRule
implements ComposableStatsCalculator.Rule {
    private static final Pattern<TableScanNode> PATTERN = Pattern.typeOf(TableScanNode.class);
    private final Metadata metadata;

    public TableScanStatsRule(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata can not be null");
    }

    public Pattern<TableScanNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Optional<PlanNodeStatsEstimate> calculate(PlanNode node, StatsProvider sourceStats, Lookup lookup, Session session, Map<Symbol, Type> types) {
        TableScanNode tableScanNode = (TableScanNode)node;
        Constraint<ColumnHandle> constraint = this.getConstraint(tableScanNode, (Expression)BooleanLiteral.TRUE_LITERAL, session, types);
        TableStatistics tableStatistics = this.metadata.getTableStatistics(session, tableScanNode.getTable(), constraint);
        HashMap<Symbol, SymbolStatsEstimate> outputSymbolStats = new HashMap<Symbol, SymbolStatsEstimate>();
        for (Map.Entry<Symbol, ColumnHandle> entry : tableScanNode.getAssignments().entrySet()) {
            Symbol symbol = entry.getKey();
            Type symbolType = types.get(symbol);
            Optional columnStatistics = Optional.ofNullable(tableStatistics.getColumnStatistics().get(entry.getValue()));
            outputSymbolStats.put(symbol, columnStatistics.map(statistics -> this.toSymbolStatistics(tableStatistics, (ColumnStatistics)statistics, session, symbolType)).orElse(SymbolStatsEstimate.UNKNOWN_STATS));
        }
        return Optional.of(PlanNodeStatsEstimate.builder().setOutputRowCount(tableStatistics.getRowCount().getValue()).addSymbolStatistics(outputSymbolStats).build());
    }

    private SymbolStatsEstimate toSymbolStatistics(TableStatistics tableStatistics, ColumnStatistics columnStatistics, Session session, Type type) {
        return SymbolStatsEstimate.builder().setLowValue(this.asDouble(session, type, columnStatistics.getOnlyRangeColumnStatistics().getLowValue()).orElse(Double.NEGATIVE_INFINITY)).setHighValue(this.asDouble(session, type, columnStatistics.getOnlyRangeColumnStatistics().getHighValue()).orElse(Double.POSITIVE_INFINITY)).setNullsFraction(columnStatistics.getNullsFraction().getValue() / (columnStatistics.getNullsFraction().getValue() + columnStatistics.getOnlyRangeColumnStatistics().getFraction().getValue())).setDistinctValuesCount(columnStatistics.getOnlyRangeColumnStatistics().getDistinctValuesCount().getValue()).setAverageRowSize(columnStatistics.getOnlyRangeColumnStatistics().getDataSize().getValue() / tableStatistics.getRowCount().getValue()).build();
    }

    private OptionalDouble asDouble(Session session, Type type, Optional<Object> optionalValue) {
        return optionalValue.map(value -> StatsUtil.toStatsRepresentation(this.metadata, session, type, value)).orElseGet(OptionalDouble::empty);
    }

    private Constraint<ColumnHandle> getConstraint(TableScanNode node, Expression predicate, Session session, Map<Symbol, Type> types) {
        DomainTranslator.ExtractionResult decomposedPredicate = DomainTranslator.fromPredicate(this.metadata, session, predicate, types);
        TupleDomain simplifiedConstraint = decomposedPredicate.getTupleDomain().transform(node.getAssignments()::get).intersect(node.getCurrentConstraint());
        return new Constraint(simplifiedConstraint, bindings -> true);
    }
}

