/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.StatisticRange;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Function;

public class SymbolStatsEstimate {
    public static final SymbolStatsEstimate UNKNOWN_STATS = SymbolStatsEstimate.builder().build();
    public static final SymbolStatsEstimate ZERO_STATS = SymbolStatsEstimate.builder().setLowValue(Double.NaN).setHighValue(Double.NaN).setDistinctValuesCount(0.0).setNullsFraction(1.0).setAverageRowSize(0.0).build();
    private final double lowValue;
    private final double highValue;
    private final double nullsFraction;
    private final double averageRowSize;
    private final double distinctValuesCount;

    public SymbolStatsEstimate(double lowValue, double highValue, double nullsFraction, double averageRowSize, double distinctValuesCount) {
        Preconditions.checkArgument((lowValue <= highValue || Double.isNaN(lowValue) && Double.isNaN(highValue) ? 1 : 0) != 0, (String)"low value must be less than or equal to high value or both values have to be NaN, got %s and %s respectively", (Object)lowValue, (Object)highValue);
        this.lowValue = lowValue;
        this.highValue = highValue;
        Preconditions.checkArgument((0.0 <= nullsFraction && nullsFraction <= 1.0 || Double.isNaN(nullsFraction) ? 1 : 0) != 0, (String)"Nulls fraction should be within [0, 1] or NaN, got: %s", (Object)nullsFraction);
        boolean isEmptyRange = Double.isNaN(lowValue) && Double.isNaN(highValue);
        this.nullsFraction = isEmptyRange ? 1.0 : nullsFraction;
        Preconditions.checkArgument((averageRowSize >= 0.0 || Double.isNaN(averageRowSize) ? 1 : 0) != 0, (String)"Average row size should be non-negative or NaN, got: %s", (Object)averageRowSize);
        this.averageRowSize = averageRowSize;
        Preconditions.checkArgument((distinctValuesCount >= 0.0 || Double.isNaN(distinctValuesCount) ? 1 : 0) != 0, (String)"Distinct values count should be non-negative, got: %s", (Object)distinctValuesCount);
        this.distinctValuesCount = distinctValuesCount;
    }

    public double getLowValue() {
        return this.lowValue;
    }

    public double getHighValue() {
        return this.highValue;
    }

    public boolean isRangeEmpty() {
        return Double.isNaN(this.lowValue) && Double.isNaN(this.highValue);
    }

    public double getNullsFraction() {
        return this.nullsFraction;
    }

    public StatisticRange statisticRange() {
        return new StatisticRange(this.lowValue, this.highValue, this.distinctValuesCount);
    }

    public double getValuesFraction() {
        return 1.0 - this.nullsFraction;
    }

    public double getAverageRowSize() {
        return this.averageRowSize;
    }

    public double getDistinctValuesCount() {
        return this.distinctValuesCount;
    }

    public SymbolStatsEstimate mapLowValue(Function<Double, Double> mappingFunction) {
        return SymbolStatsEstimate.buildFrom(this).setLowValue(mappingFunction.apply(this.lowValue)).build();
    }

    public SymbolStatsEstimate mapHighValue(Function<Double, Double> mappingFunction) {
        return SymbolStatsEstimate.buildFrom(this).setHighValue(mappingFunction.apply(this.highValue)).build();
    }

    public SymbolStatsEstimate mapNullsFraction(Function<Double, Double> mappingFunction) {
        return SymbolStatsEstimate.buildFrom(this).setNullsFraction(mappingFunction.apply(this.nullsFraction)).build();
    }

    public SymbolStatsEstimate mapDistinctValuesCount(Function<Double, Double> mappingFunction) {
        return SymbolStatsEstimate.buildFrom(this).setDistinctValuesCount(mappingFunction.apply(this.distinctValuesCount)).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymbolStatsEstimate that = (SymbolStatsEstimate)o;
        return Double.compare(this.nullsFraction, that.nullsFraction) == 0 && Double.compare(this.averageRowSize, that.averageRowSize) == 0 && Double.compare(this.distinctValuesCount, that.distinctValuesCount) == 0 && Double.compare(this.lowValue, that.lowValue) == 0 && Double.compare(this.highValue, that.highValue) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.lowValue, this.highValue, this.nullsFraction, this.averageRowSize, this.distinctValuesCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("range", (Object)String.format("[%s-%s]", this.lowValue, this.highValue)).add("nulls", this.nullsFraction).add("ndv", this.distinctValuesCount).add("rowSize", this.averageRowSize).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder buildFrom(SymbolStatsEstimate other) {
        return SymbolStatsEstimate.builder().setLowValue(other.getLowValue()).setHighValue(other.getHighValue()).setNullsFraction(other.getNullsFraction()).setAverageRowSize(other.getAverageRowSize()).setDistinctValuesCount(other.getDistinctValuesCount());
    }

    public static final class Builder {
        private double lowValue = Double.NEGATIVE_INFINITY;
        private double highValue = Double.POSITIVE_INFINITY;
        private double nullsFraction = Double.NaN;
        private double averageRowSize = Double.NaN;
        private double distinctValuesCount = Double.NaN;

        public Builder setStatisticsRange(StatisticRange range) {
            return this.setLowValue(range.getLow()).setHighValue(range.getHigh()).setDistinctValuesCount(range.getDistinctValuesCount());
        }

        public Builder setLowValue(double lowValue) {
            this.lowValue = lowValue;
            return this;
        }

        public Builder setHighValue(double highValue) {
            this.highValue = highValue;
            return this;
        }

        public Builder setNullsFraction(double nullsFraction) {
            this.nullsFraction = nullsFraction;
            return this;
        }

        public Builder setAverageRowSize(double averageRowSize) {
            this.averageRowSize = averageRowSize;
            return this;
        }

        public Builder setDistinctValuesCount(double distinctValuesCount) {
            this.distinctValuesCount = distinctValuesCount;
            return this;
        }

        public SymbolStatsEstimate build() {
            return new SymbolStatsEstimate(this.lowValue, this.highValue, this.nullsFraction, this.averageRowSize, this.distinctValuesCount);
        }
    }
}

