/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.FunctionInvoker;
import java.util.Collections;
import java.util.OptionalDouble;

final class StatsUtil {
    private StatsUtil() {
    }

    static OptionalDouble toStatsRepresentation(Metadata metadata, Session session, Type type, Object value) {
        return StatsUtil.toStatsRepresentation(metadata.getFunctionRegistry(), session.toConnectorSession(), type, value);
    }

    static OptionalDouble toStatsRepresentation(FunctionRegistry functionRegistry, ConnectorSession session, Type type, Object value) {
        if (StatsUtil.convertibleToDoubleWithCast(type)) {
            FunctionInvoker functionInvoker = new FunctionInvoker(functionRegistry);
            Signature castSignature = functionRegistry.getCoercion(type, (Type)DoubleType.DOUBLE);
            return OptionalDouble.of((Double)functionInvoker.invoke(castSignature, session, Collections.singletonList(value)));
        }
        if (DateType.DATE.equals((Object)type)) {
            return OptionalDouble.of(((Long)value).doubleValue());
        }
        return OptionalDouble.empty();
    }

    private static boolean convertibleToDoubleWithCast(Type type) {
        return type instanceof DecimalType || DoubleType.DOUBLE.equals((Object)type) || RealType.REAL.equals((Object)type) || BigintType.BIGINT.equals((Object)type) || IntegerType.INTEGER.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || TinyintType.TINYINT.equals((Object)type) || BooleanType.BOOLEAN.equals((Object)type);
    }
}

