/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.SymbolStatsEstimate;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class StatisticRange {
    private static final double INFINITE_TO_FINITE_RANGE_INTERSECT_OVERLAP_HEURISTIC_FACTOR = 0.25;
    private static final double INFINITE_TO_INFINITE_RANGE_INTERSECT_OVERLAP_HEURISTIC_FACTOR = 0.5;
    private final double low;
    private final double high;
    private final double distinctValues;

    public StatisticRange(double low, double high, double distinctValues) {
        Preconditions.checkArgument((low <= high || Double.isNaN(low) && Double.isNaN(high) ? 1 : 0) != 0, (String)"low value must be less than or equal to high value or both values have to be NaN, got %s and %s respectively", (Object)low, (Object)high);
        this.low = low;
        this.high = high;
        Preconditions.checkArgument((distinctValues >= 0.0 || Double.isNaN(distinctValues) ? 1 : 0) != 0, (String)"Distinct values count should be non-negative, got: %s", (Object)distinctValues);
        this.distinctValues = distinctValues;
    }

    public static StatisticRange empty() {
        return new StatisticRange(Double.NaN, Double.NaN, 0.0);
    }

    public static StatisticRange from(SymbolStatsEstimate estimate) {
        return new StatisticRange(estimate.getLowValue(), estimate.getHighValue(), estimate.getDistinctValuesCount());
    }

    public double getLow() {
        return this.low;
    }

    public double getHigh() {
        return this.high;
    }

    public double getDistinctValuesCount() {
        return this.distinctValues;
    }

    public double length() {
        return this.high - this.low;
    }

    public boolean isEmpty() {
        return Double.isNaN(this.low) && Double.isNaN(this.high);
    }

    public double overlapPercentWith(StatisticRange other) {
        Objects.requireNonNull(other, "other is null");
        if (this.equals(other)) {
            return 1.0;
        }
        if (this.isEmpty() || other.isEmpty()) {
            return 0.0;
        }
        double lengthOfIntersect = Math.min(this.high, other.high) - Math.max(this.low, other.low);
        if (Double.isInfinite(lengthOfIntersect)) {
            if (Double.isFinite(this.distinctValues) && Double.isFinite(other.distinctValues)) {
                return Math.min(other.distinctValues / this.distinctValues, 1.0);
            }
            return 0.5;
        }
        if (lengthOfIntersect == 0.0) {
            return 1.0 / Math.max(this.distinctValues, 1.0);
        }
        if (lengthOfIntersect < 0.0) {
            return 0.0;
        }
        if (Double.isInfinite(this.length()) && Double.isFinite(lengthOfIntersect)) {
            return 0.25;
        }
        if (lengthOfIntersect > 0.0) {
            return lengthOfIntersect / this.length();
        }
        return Double.NaN;
    }

    private double overlappingDistinctValues(StatisticRange other) {
        double overlapPercentOfLeft = this.overlapPercentWith(other);
        double overlapPercentOfRight = other.overlapPercentWith(this);
        double overlapDistinctValuesLeft = overlapPercentOfLeft * this.distinctValues;
        double overlapDistinctValuesRight = overlapPercentOfRight * other.distinctValues;
        return StatisticRange.maxExcludeNaN(overlapDistinctValuesLeft, overlapDistinctValuesRight);
    }

    public StatisticRange intersect(StatisticRange other) {
        double newHigh;
        double newLow = Math.max(this.low, other.low);
        if (newLow <= (newHigh = Math.min(this.high, other.high))) {
            return new StatisticRange(newLow, newHigh, this.overlappingDistinctValues(other));
        }
        return StatisticRange.empty();
    }

    public StatisticRange addAndSumDistinctValues(StatisticRange other) {
        double newDistinctValues = this.distinctValues + other.distinctValues;
        return new StatisticRange(StatisticRange.minExcludeNaN(this.low, other.low), StatisticRange.maxExcludeNaN(this.high, other.high), newDistinctValues);
    }

    public StatisticRange addAndCollapseDistinctValues(StatisticRange other) {
        double overlapPercentOfThis = this.overlapPercentWith(other);
        double overlapPercentOfOther = other.overlapPercentWith(this);
        double overlapDistinctValuesThis = overlapPercentOfThis * this.distinctValues;
        double overlapDistinctValuesOther = overlapPercentOfOther * other.distinctValues;
        double maxOverlappingValues = Math.max(overlapDistinctValuesThis, overlapDistinctValuesOther);
        double newDistinctValues = maxOverlappingValues + (1.0 - overlapPercentOfThis) * this.distinctValues + (1.0 - overlapPercentOfOther) * other.distinctValues;
        return new StatisticRange(StatisticRange.minExcludeNaN(this.low, other.low), StatisticRange.maxExcludeNaN(this.high, other.high), newDistinctValues);
    }

    public StatisticRange subtract(StatisticRange rightRange) {
        StatisticRange intersect = this.intersect(rightRange);
        double newLow = this.low;
        double newHigh = this.high;
        if (intersect.low == this.low) {
            newLow = intersect.high;
        }
        if (intersect.high == this.high) {
            newHigh = intersect.low;
        }
        if (newLow > newHigh) {
            newLow = Double.NaN;
            newHigh = Double.NaN;
        }
        double newDistinctValues = Math.max(this.distinctValues, rightRange.distinctValues) - intersect.distinctValues;
        return new StatisticRange(newLow, newHigh, newDistinctValues);
    }

    private static double minExcludeNaN(double v1, double v2) {
        if (Double.isNaN(v1)) {
            return v2;
        }
        if (Double.isNaN(v2)) {
            return v1;
        }
        return Math.min(v1, v2);
    }

    private static double maxExcludeNaN(double v1, double v2) {
        if (Double.isNaN(v1)) {
            return v2;
        }
        if (Double.isNaN(v2)) {
            return v1;
        }
        return Math.max(v1, v2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StatisticRange)) {
            return false;
        }
        StatisticRange other = (StatisticRange)obj;
        return this.low == other.low && this.high == other.high && this.distinctValues == other.distinctValues;
    }

    public int hashCode() {
        return Objects.hash(this.low, this.high, this.distinctValues);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("range", (Object)String.format("[%s-%s]", this.low, this.high)).add("ndv", this.distinctValues).toString();
    }
}

