/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsUtil;
import com.facebook.presto.cost.SymbolStatsEstimate;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.util.MoreMath;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import javax.inject.Inject;

public class ScalarStatsCalculator {
    private final Metadata metadata;

    @Inject
    public ScalarStatsCalculator(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata can not be null");
    }

    public SymbolStatsEstimate calculate(Expression scalarExpression, PlanNodeStatsEstimate inputStatistics, Session session) {
        return (SymbolStatsEstimate)new Visitor(inputStatistics, session).process((Node)scalarExpression);
    }

    private class Visitor
    extends AstVisitor<SymbolStatsEstimate, Void> {
        private final PlanNodeStatsEstimate input;
        private final Session session;

        Visitor(PlanNodeStatsEstimate input, Session session) {
            this.input = input;
            this.session = session;
        }

        protected SymbolStatsEstimate visitNode(Node node, Void context) {
            return SymbolStatsEstimate.UNKNOWN_STATS;
        }

        protected SymbolStatsEstimate visitSymbolReference(SymbolReference node, Void context) {
            return this.input.getSymbolStatistics(Symbol.from((Expression)node));
        }

        protected SymbolStatsEstimate visitNullLiteral(NullLiteral node, Void context) {
            return SymbolStatsEstimate.builder().setDistinctValuesCount(0.0).setNullsFraction(1.0).build();
        }

        protected SymbolStatsEstimate visitLiteral(Literal node, Void context) {
            Object value = LiteralInterpreter.evaluate(ScalarStatsCalculator.this.metadata, this.session.toConnectorSession(), (Expression)node);
            Type type = ExpressionAnalyzer.createConstantAnalyzer(ScalarStatsCalculator.this.metadata, this.session, (List<Expression>)ImmutableList.of()).analyze((Expression)node, Scope.create());
            OptionalDouble doubleValue = StatsUtil.toStatsRepresentation(ScalarStatsCalculator.this.metadata, this.session, type, value);
            SymbolStatsEstimate.Builder estimate = SymbolStatsEstimate.builder().setNullsFraction(0.0).setDistinctValuesCount(1.0);
            if (doubleValue.isPresent()) {
                estimate.setLowValue(doubleValue.getAsDouble());
                estimate.setHighValue(doubleValue.getAsDouble());
            }
            return estimate.build();
        }

        protected SymbolStatsEstimate visitCast(Cast node, Void context) {
            SymbolStatsEstimate sourceStats = (SymbolStatsEstimate)this.process((Node)node.getExpression());
            TypeSignature targetType = TypeSignature.parseTypeSignature((String)node.getType());
            double distinctValuesCount = sourceStats.getDistinctValuesCount();
            double lowValue = sourceStats.getLowValue();
            double highValue = sourceStats.getHighValue();
            if (this.isIntegralType(targetType)) {
                if (Double.isFinite(lowValue)) {
                    lowValue = Math.round(lowValue);
                }
                if (Double.isFinite(highValue)) {
                    highValue = Math.round(highValue);
                }
                if (Double.isFinite(lowValue) && Double.isFinite(highValue)) {
                    double integersInRange = highValue - lowValue + 1.0;
                    if (!Double.isNaN(distinctValuesCount) && distinctValuesCount > integersInRange) {
                        distinctValuesCount = integersInRange;
                    }
                }
            }
            return SymbolStatsEstimate.builder().setNullsFraction(sourceStats.getNullsFraction()).setLowValue(lowValue).setHighValue(highValue).setDistinctValuesCount(distinctValuesCount).build();
        }

        private boolean isIntegralType(TypeSignature targetType) {
            switch (targetType.getBase()) {
                case "bigint": 
                case "integer": 
                case "smallint": 
                case "tinyint": {
                    return true;
                }
                case "decimal": {
                    DecimalType decimalType = (DecimalType)ScalarStatsCalculator.this.metadata.getType(targetType);
                    return decimalType.getScale() == 0;
                }
            }
            return false;
        }

        protected SymbolStatsEstimate visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            Objects.requireNonNull(node, "node is null");
            SymbolStatsEstimate left = (SymbolStatsEstimate)this.process((Node)node.getLeft());
            SymbolStatsEstimate right = (SymbolStatsEstimate)this.process((Node)node.getRight());
            SymbolStatsEstimate.Builder result = SymbolStatsEstimate.builder().setAverageRowSize(Math.max(left.getAverageRowSize(), right.getAverageRowSize())).setNullsFraction(left.getNullsFraction() + right.getNullsFraction() - left.getNullsFraction() * right.getNullsFraction()).setDistinctValuesCount(MoreMath.min(left.getDistinctValuesCount() * right.getDistinctValuesCount(), this.input.getOutputRowCount()));
            double leftLow = left.getLowValue();
            double leftHigh = left.getHighValue();
            double rightLow = right.getLowValue();
            double rightHigh = right.getHighValue();
            if (node.getType() == ArithmeticBinaryExpression.Type.DIVIDE && rightLow < 0.0 && rightHigh > 0.0) {
                result.setLowValue(Double.NEGATIVE_INFINITY).setHighValue(Double.POSITIVE_INFINITY);
            } else if (node.getType() == ArithmeticBinaryExpression.Type.MODULUS) {
                double maxDivisor = MoreMath.max(Math.abs(rightLow), Math.abs(rightHigh));
                if (leftHigh <= 0.0) {
                    result.setLowValue(MoreMath.max(-maxDivisor, leftLow)).setHighValue(0.0);
                } else if (leftLow >= 0.0) {
                    result.setLowValue(0.0).setHighValue(MoreMath.min(maxDivisor, leftHigh));
                } else {
                    result.setLowValue(MoreMath.max(-maxDivisor, leftLow)).setHighValue(MoreMath.min(maxDivisor, leftHigh));
                }
            } else {
                double v1 = this.operate(node.getType(), leftLow, rightLow);
                double v2 = this.operate(node.getType(), leftLow, rightHigh);
                double v3 = this.operate(node.getType(), leftHigh, rightLow);
                double v4 = this.operate(node.getType(), leftHigh, rightHigh);
                double lowValue = MoreMath.min(v1, v2, v3, v4);
                double highValue = MoreMath.max(v1, v2, v3, v4);
                result.setLowValue(lowValue).setHighValue(highValue);
            }
            return result.build();
        }

        private double operate(ArithmeticBinaryExpression.Type type, double left, double right) {
            switch (type) {
                case ADD: {
                    return left + right;
                }
                case SUBTRACT: {
                    return left - right;
                }
                case MULTIPLY: {
                    return left * right;
                }
                case DIVIDE: {
                    return left / right;
                }
                case MODULUS: {
                    return left % right;
                }
            }
            throw new IllegalStateException("Unsupported ArithmeticBinaryExpression.Type: " + type);
        }

        protected SymbolStatsEstimate visitCoalesceExpression(CoalesceExpression node, Void context) {
            Objects.requireNonNull(node, "node is null");
            SymbolStatsEstimate result = null;
            for (Expression operand : node.getOperands()) {
                SymbolStatsEstimate operandEstimates = (SymbolStatsEstimate)this.process((Node)operand);
                if (result != null) {
                    result = this.estimateCoalesce(result, operandEstimates);
                    continue;
                }
                result = operandEstimates;
            }
            return Objects.requireNonNull(result, "result is null");
        }

        private SymbolStatsEstimate estimateCoalesce(SymbolStatsEstimate left, SymbolStatsEstimate right) {
            if (left.getNullsFraction() == 0.0) {
                return left;
            }
            if (left.getNullsFraction() == 1.0) {
                return right;
            }
            return SymbolStatsEstimate.builder().setLowValue(MoreMath.min(left.getLowValue(), right.getLowValue())).setHighValue(MoreMath.max(left.getHighValue(), right.getHighValue())).setDistinctValuesCount(left.getDistinctValuesCount() + MoreMath.min(right.getDistinctValuesCount(), this.input.getOutputRowCount() * left.getNullsFraction())).setNullsFraction(left.getNullsFraction() * right.getNullsFraction()).setAverageRowSize(MoreMath.max(left.getAverageRowSize(), right.getAverageRowSize())).build();
        }
    }
}

