/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.ComposableStatsCalculator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.ScalarStatsCalculator;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.Expression;
import java.util.Map;
import java.util.Optional;

public class ProjectStatsRule
implements ComposableStatsCalculator.Rule {
    private static final Pattern<ProjectNode> PATTERN = Pattern.typeOf(ProjectNode.class);
    private final ScalarStatsCalculator scalarStatsCalculator;

    public ProjectStatsRule(ScalarStatsCalculator scalarStatsCalculator) {
        this.scalarStatsCalculator = scalarStatsCalculator;
    }

    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Optional<PlanNodeStatsEstimate> calculate(PlanNode node, StatsProvider statsProvider, Lookup lookup, Session session, Map<Symbol, Type> types) {
        ProjectNode projectNode = (ProjectNode)node;
        PlanNodeStatsEstimate sourceStats = statsProvider.getStats(projectNode.getSource());
        PlanNodeStatsEstimate.Builder calculatedStats = PlanNodeStatsEstimate.builder().setOutputRowCount(sourceStats.getOutputRowCount());
        for (Map.Entry<Symbol, Expression> entry : projectNode.getAssignments().entrySet()) {
            calculatedStats.addSymbolStatistics(entry.getKey(), this.scalarStatsCalculator.calculate(entry.getValue(), sourceStats, session));
        }
        return Optional.of(calculatedStats.build());
    }
}

