/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.ComposableStatsCalculator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import java.util.Map;
import java.util.Optional;

public class LimitStatsRule
implements ComposableStatsCalculator.Rule {
    private static final Pattern<LimitNode> PATTERN = Pattern.typeOf(LimitNode.class);

    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Optional<PlanNodeStatsEstimate> calculate(PlanNode node, StatsProvider statsProvider, Lookup lookup, Session session, Map<Symbol, Type> types) {
        LimitNode limitNode = (LimitNode)node;
        PlanNodeStatsEstimate sourceStats = statsProvider.getStats(limitNode.getSource());
        if (sourceStats.getOutputRowCount() <= (double)limitNode.getCount()) {
            return Optional.of(sourceStats);
        }
        return Optional.of(PlanNodeStatsEstimate.buildFrom(sourceStats).setOutputRowCount(limitNode.getCount()).build());
    }
}

