/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.ComposableStatsCalculator;
import com.facebook.presto.cost.FilterStatsCalculator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import java.util.Map;
import java.util.Optional;

public class FilterStatsRule
implements ComposableStatsCalculator.Rule {
    private static final Pattern<FilterNode> PATTERN = Pattern.typeOf(FilterNode.class);
    private final FilterStatsCalculator filterStatsCalculator;

    public FilterStatsRule(FilterStatsCalculator filterStatsCalculator) {
        this.filterStatsCalculator = filterStatsCalculator;
    }

    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Optional<PlanNodeStatsEstimate> calculate(PlanNode node, StatsProvider statsProvider, Lookup lookup, Session session, Map<Symbol, Type> types) {
        FilterNode filterNode = (FilterNode)node;
        PlanNodeStatsEstimate sourceStats = statsProvider.getStats(filterNode.getSource());
        return Optional.of(this.filterStatsCalculator.filterStats(sourceStats, filterNode.getPredicate(), session, types));
    }
}

