/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;

public class FairBatchExecutor {
    private static final Logger log = Logger.get(FairBatchExecutor.class);
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private final int threads;
    private final ExecutorService executor;
    private final PriorityBlockingQueue<PrioritizedFutureTask> queue = new PriorityBlockingQueue();
    @GuardedBy(value="this")
    private long basePriority;

    public FairBatchExecutor(int threads, ThreadFactory threadFactory) {
        this.threads = threads;
        this.executor = new ThreadPoolExecutor(threads, threads, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.DiscardPolicy());
    }

    public void shutdown() {
        this.shutdown.set(true);
        this.executor.shutdown();
        for (int i = 0; i < this.threads; ++i) {
            this.queue.add(new PrioritizedFutureTask(-1L, new Callable<Void>(){

                @Override
                public Void call() {
                    return null;
                }
            }));
        }
    }

    public <T> List<FutureTask<T>> processBatch(Collection<? extends Callable<T>> tasks) {
        Preconditions.checkState((!this.shutdown.get() ? 1 : 0) != 0, (Object)"Executor is already shut down");
        long priority = this.computeStartingPriority();
        ImmutableList.Builder result = ImmutableList.builder();
        for (Callable<T> task : tasks) {
            PrioritizedFutureTask future = new PrioritizedFutureTask(priority++, task);
            this.queue.add(future);
            result.add(future);
        }
        for (int i = 0; i < Math.min(this.threads, tasks.size()); ++i) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    FairBatchExecutor.this.trigger();
                }
            });
        }
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long computeStartingPriority() {
        FairBatchExecutor fairBatchExecutor = this;
        synchronized (fairBatchExecutor) {
            ++this.basePriority;
            return this.basePriority;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStartingPriority(long newBase) {
        FairBatchExecutor fairBatchExecutor = this;
        synchronized (fairBatchExecutor) {
            if (this.basePriority < newBase) {
                this.basePriority = newBase;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void trigger() {
        interrupted = false;
        try {
            while (!Thread.currentThread().isInterrupted() && !this.shutdown.get()) {
                task = this.queue.take();
                try {
                    task.run();
                }
                finally {
                    this.updateStartingPriority(PrioritizedFutureTask.access$200(task));
                }
            }
            ** if (this.shutdown.get()) goto lbl-1000
        }
        catch (InterruptedException e) {
            try {
                interrupted = true;
                ** if (this.shutdown.get()) goto lbl-1000
            }
            catch (Throwable var4_5) {
                if (!this.shutdown.get()) {
                    this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            FairBatchExecutor.this.trigger();
                        }
                    });
                }
                throw var4_5;
            }
lbl-1000:
            // 1 sources

            {
                this.executor.execute(new /* invalid duplicate definition of identical inner class */);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            this.executor.execute(new /* invalid duplicate definition of identical inner class */);
        }
lbl-1000:
        // 2 sources

        {
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private static class PrioritizedFutureTask<T>
    extends FutureTask<T>
    implements Comparable<PrioritizedFutureTask> {
        private final long priority;

        private PrioritizedFutureTask(long priority, Callable<T> callable) {
            super(callable);
            this.priority = priority;
        }

        @Override
        public int compareTo(PrioritizedFutureTask o) {
            return Long.compare(this.priority, o.priority);
        }

        static /* synthetic */ long access$200(PrioritizedFutureTask x0) {
            return x0.priority;
        }
    }
}

