/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.security.BasicPrincipal;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.transaction.TransactionId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class SessionRepresentation {
    private final String queryId;
    private final Optional<TransactionId> transactionId;
    private final boolean clientTransactionSupport;
    private final String user;
    private final Optional<String> principal;
    private final Optional<String> source;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    private final Optional<String> remoteUserAddress;
    private final Optional<String> userAgent;
    private final Optional<String> clientInfo;
    private final Set<String> clientTags;
    private final long startTime;
    private final Map<String, String> systemProperties;
    private final Map<ConnectorId, Map<String, String>> catalogProperties;
    private final Map<String, String> preparedStatements;

    @JsonCreator
    public SessionRepresentation(@JsonProperty(value="queryId") String queryId, @JsonProperty(value="transactionId") Optional<TransactionId> transactionId, @JsonProperty(value="clientTransactionSupport") boolean clientTransactionSupport, @JsonProperty(value="user") String user, @JsonProperty(value="principal") Optional<String> principal, @JsonProperty(value="source") Optional<String> source, @JsonProperty(value="catalog") Optional<String> catalog, @JsonProperty(value="schema") Optional<String> schema, @JsonProperty(value="timeZoneKey") TimeZoneKey timeZoneKey, @JsonProperty(value="locale") Locale locale, @JsonProperty(value="remoteUserAddress") Optional<String> remoteUserAddress, @JsonProperty(value="userAgent") Optional<String> userAgent, @JsonProperty(value="clientInfo") Optional<String> clientInfo, @JsonProperty(value="clientTags") Set<String> clientTags, @JsonProperty(value="startTime") long startTime, @JsonProperty(value="systemProperties") Map<String, String> systemProperties, @JsonProperty(value="catalogProperties") Map<ConnectorId, Map<String, String>> catalogProperties, @JsonProperty(value="preparedStatements") Map<String, String> preparedStatements) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.clientTransactionSupport = clientTransactionSupport;
        this.user = Objects.requireNonNull(user, "user is null");
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.remoteUserAddress = Objects.requireNonNull(remoteUserAddress, "remoteUserAddress is null");
        this.userAgent = Objects.requireNonNull(userAgent, "userAgent is null");
        this.clientInfo = Objects.requireNonNull(clientInfo, "clientInfo is null");
        this.clientTags = Objects.requireNonNull(clientTags, "clientTags is null");
        this.startTime = startTime;
        this.systemProperties = ImmutableMap.copyOf(systemProperties);
        this.preparedStatements = ImmutableMap.copyOf(preparedStatements);
        ImmutableMap.Builder catalogPropertiesBuilder = ImmutableMap.builder();
        for (Map.Entry<ConnectorId, Map<String, String>> entry : catalogProperties.entrySet()) {
            catalogPropertiesBuilder.put((Object)entry.getKey(), (Object)ImmutableMap.copyOf(entry.getValue()));
        }
        this.catalogProperties = catalogPropertiesBuilder.build();
    }

    @JsonProperty
    public String getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public Optional<TransactionId> getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty
    public boolean isClientTransactionSupport() {
        return this.clientTransactionSupport;
    }

    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @JsonProperty
    public Optional<String> getPrincipal() {
        return this.principal;
    }

    @JsonProperty
    public Optional<String> getSource() {
        return this.source;
    }

    @JsonProperty
    public Optional<String> getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public Optional<String> getSchema() {
        return this.schema;
    }

    @JsonProperty
    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    @JsonProperty
    public Locale getLocale() {
        return this.locale;
    }

    @JsonProperty
    public Optional<String> getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    @JsonProperty
    public Optional<String> getUserAgent() {
        return this.userAgent;
    }

    @JsonProperty
    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    @JsonProperty
    public Set<String> getClientTags() {
        return this.clientTags;
    }

    @JsonProperty
    public long getStartTime() {
        return this.startTime;
    }

    @JsonProperty
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @JsonProperty
    public Map<ConnectorId, Map<String, String>> getCatalogProperties() {
        return this.catalogProperties;
    }

    @JsonProperty
    public Map<String, String> getPreparedStatements() {
        return this.preparedStatements;
    }

    public Session toSession(SessionPropertyManager sessionPropertyManager) {
        return new Session(new QueryId(this.queryId), this.transactionId, this.clientTransactionSupport, new Identity(this.user, this.principal.map(BasicPrincipal::new)), this.source, this.catalog, this.schema, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.clientInfo, this.clientTags, this.startTime, this.systemProperties, this.catalogProperties, (Map<String, Map<String, String>>)ImmutableMap.of(), sessionPropertyManager, this.preparedStatements);
    }
}

