/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.FullConnectorSession;
import com.facebook.presto.SessionRepresentation;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.Failures;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;

public final class Session {
    private final QueryId queryId;
    private final Optional<TransactionId> transactionId;
    private final boolean clientTransactionSupport;
    private final Identity identity;
    private final Optional<String> source;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    private final Optional<String> remoteUserAddress;
    private final Optional<String> userAgent;
    private final Optional<String> clientInfo;
    private final Set<String> clientTags;
    private final long startTime;
    private final Map<String, String> systemProperties;
    private final Map<ConnectorId, Map<String, String>> connectorProperties;
    private final Map<String, Map<String, String>> unprocessedCatalogProperties;
    private final SessionPropertyManager sessionPropertyManager;
    private final Map<String, String> preparedStatements;

    public Session(QueryId queryId, Optional<TransactionId> transactionId, boolean clientTransactionSupport, Identity identity, Optional<String> source, Optional<String> catalog, Optional<String> schema, TimeZoneKey timeZoneKey, Locale locale, Optional<String> remoteUserAddress, Optional<String> userAgent, Optional<String> clientInfo, Set<String> clientTags, long startTime, Map<String, String> systemProperties, Map<ConnectorId, Map<String, String>> connectorProperties, Map<String, Map<String, String>> unprocessedCatalogProperties, SessionPropertyManager sessionPropertyManager, Map<String, String> preparedStatements) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.clientTransactionSupport = clientTransactionSupport;
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.remoteUserAddress = Objects.requireNonNull(remoteUserAddress, "remoteUserAddress is null");
        this.userAgent = Objects.requireNonNull(userAgent, "userAgent is null");
        this.clientInfo = Objects.requireNonNull(clientInfo, "clientInfo is null");
        this.clientTags = ImmutableSet.copyOf((Collection)Objects.requireNonNull(clientTags, "clientTags is null"));
        this.startTime = startTime;
        this.systemProperties = ImmutableMap.copyOf(Objects.requireNonNull(systemProperties, "systemProperties is null"));
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.preparedStatements = Objects.requireNonNull(preparedStatements, "preparedStatements is null");
        ImmutableMap.Builder catalogPropertiesBuilder = ImmutableMap.builder();
        connectorProperties.entrySet().stream().map(entry -> Maps.immutableEntry(entry.getKey(), (Object)ImmutableMap.copyOf((Map)((Map)entry.getValue())))).forEach(arg_0 -> ((ImmutableMap.Builder)catalogPropertiesBuilder).put(arg_0));
        this.connectorProperties = catalogPropertiesBuilder.build();
        ImmutableMap.Builder unprocessedCatalogPropertiesBuilder = ImmutableMap.builder();
        unprocessedCatalogProperties.entrySet().stream().map(entry -> Maps.immutableEntry(entry.getKey(), (Object)ImmutableMap.copyOf((Map)((Map)entry.getValue())))).forEach(arg_0 -> ((ImmutableMap.Builder)unprocessedCatalogPropertiesBuilder).put(arg_0));
        this.unprocessedCatalogProperties = unprocessedCatalogPropertiesBuilder.build();
        Preconditions.checkArgument((!transactionId.isPresent() || unprocessedCatalogProperties.isEmpty() ? 1 : 0) != 0, (Object)"Catalog session properties cannot be set if there is an open transaction");
        Preconditions.checkArgument((catalog.isPresent() || !schema.isPresent() ? 1 : 0) != 0, (Object)"schema is set but catalog is not");
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public String getUser() {
        return this.identity.getUser();
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public Optional<String> getCatalog() {
        return this.catalog;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Optional<String> getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    public Optional<String> getUserAgent() {
        return this.userAgent;
    }

    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    public Set<String> getClientTags() {
        return this.clientTags;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Optional<TransactionId> getTransactionId() {
        return this.transactionId;
    }

    public TransactionId getRequiredTransactionId() {
        Preconditions.checkState((boolean)this.transactionId.isPresent(), (Object)"Not in a transaction");
        return this.transactionId.get();
    }

    public boolean isClientTransactionSupport() {
        return this.clientTransactionSupport;
    }

    public <T> T getSystemProperty(String name, Class<T> type) {
        return this.sessionPropertyManager.decodeSystemPropertyValue(name, this.systemProperties.get(name), type);
    }

    public Map<ConnectorId, Map<String, String>> getConnectorProperties() {
        return this.connectorProperties;
    }

    public Map<String, String> getConnectorProperties(ConnectorId connectorId) {
        return this.connectorProperties.getOrDefault(connectorId, (Map<String, String>)ImmutableMap.of());
    }

    public Map<String, Map<String, String>> getUnprocessedCatalogProperties() {
        return this.unprocessedCatalogProperties;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, String> getPreparedStatements() {
        return this.preparedStatements;
    }

    public String getPreparedStatementFromExecute(Execute execute) {
        return this.getPreparedStatement(execute.getName().getValue());
    }

    public String getPreparedStatement(String name) {
        String sql = this.preparedStatements.get(name);
        Failures.checkCondition(sql != null, (ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Prepared statement not found: " + name, new Object[0]);
        return sql;
    }

    public Session beginTransactionId(TransactionId transactionId, TransactionManager transactionManager, AccessControl accessControl) {
        Objects.requireNonNull(transactionId, "transactionId is null");
        Preconditions.checkArgument((!this.transactionId.isPresent() ? 1 : 0) != 0, (Object)"Session already has an active transaction");
        Objects.requireNonNull(transactionManager, "transactionManager is null");
        Objects.requireNonNull(accessControl, "accessControl is null");
        for (Map.Entry<String, String> property : this.systemProperties.entrySet()) {
            accessControl.checkCanSetSystemSessionProperty(this.identity, property.getKey());
            this.sessionPropertyManager.validateSystemSessionProperty(property.getKey(), property.getValue());
        }
        ImmutableMap.Builder connectorProperties = ImmutableMap.builder();
        for (Map.Entry<String, Map<String, String>> catalogEntry : this.unprocessedCatalogProperties.entrySet()) {
            String catalogName = catalogEntry.getKey();
            Map<String, String> catalogProperties = catalogEntry.getValue();
            if (catalogProperties.isEmpty()) continue;
            ConnectorId connectorId = transactionManager.getOptionalCatalogMetadata(transactionId, catalogName).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Session property catalog does not exist: " + catalogName)).getConnectorId();
            for (Map.Entry<String, String> property : catalogProperties.entrySet()) {
                accessControl.checkCanSetCatalogSessionProperty(transactionId, this.identity, catalogName, property.getKey());
                this.sessionPropertyManager.validateCatalogSessionProperty(connectorId, catalogName, property.getKey(), property.getValue());
            }
            connectorProperties.put((Object)connectorId, catalogProperties);
        }
        return new Session(this.queryId, Optional.of(transactionId), this.clientTransactionSupport, this.identity, this.source, this.catalog, this.schema, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.clientInfo, this.clientTags, this.startTime, this.systemProperties, (Map<ConnectorId, Map<String, String>>)connectorProperties.build(), (Map<String, Map<String, String>>)ImmutableMap.of(), this.sessionPropertyManager, this.preparedStatements);
    }

    public ConnectorSession toConnectorSession() {
        return new FullConnectorSession(this.queryId.toString(), this.identity, this.source, this.timeZoneKey, this.locale, this.startTime, SystemSessionProperties.isLegacyTimestamp(this));
    }

    public ConnectorSession toConnectorSession(ConnectorId connectorId) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        return new FullConnectorSession(this.queryId.toString(), this.identity, this.source, this.timeZoneKey, this.locale, this.startTime, this.connectorProperties.getOrDefault(connectorId, (Map<String, String>)ImmutableMap.of()), connectorId, connectorId.getCatalogName(), this.sessionPropertyManager, SystemSessionProperties.isLegacyTimestamp(this));
    }

    public SessionRepresentation toSessionRepresentation() {
        return new SessionRepresentation(this.queryId.toString(), this.transactionId, this.clientTransactionSupport, this.identity.getUser(), this.identity.getPrincipal().map(Principal::toString), this.source, this.catalog, this.schema, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.clientInfo, this.clientTags, this.startTime, this.systemProperties, this.connectorProperties, this.preparedStatements);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("transactionId", this.transactionId).add("user", (Object)this.getUser()).add("principal", this.getIdentity().getPrincipal().orElse(null)).add("source", this.source.orElse(null)).add("catalog", this.catalog.orElse(null)).add("schema", this.schema.orElse(null)).add("timeZoneKey", (Object)this.timeZoneKey).add("locale", (Object)this.locale).add("remoteUserAddress", this.remoteUserAddress.orElse(null)).add("userAgent", this.userAgent.orElse(null)).add("clientInfo", this.clientInfo.orElse(null)).add("clientTags", this.clientTags).add("startTime", this.startTime).omitNullValues().toString();
    }

    public static SessionBuilder builder(SessionPropertyManager sessionPropertyManager) {
        return new SessionBuilder(sessionPropertyManager);
    }

    @VisibleForTesting
    public static SessionBuilder builder(Session session) {
        return new SessionBuilder(session);
    }

    public static class SessionBuilder {
        private QueryId queryId;
        private TransactionId transactionId;
        private boolean clientTransactionSupport;
        private Identity identity;
        private String source;
        private String catalog;
        private String schema;
        private TimeZoneKey timeZoneKey = TimeZoneKey.getTimeZoneKey((String)TimeZone.getDefault().getID());
        private Locale locale = Locale.getDefault();
        private String remoteUserAddress;
        private String userAgent;
        private String clientInfo;
        private Set<String> clientTags = ImmutableSet.of();
        private long startTime = System.currentTimeMillis();
        private final Map<String, String> systemProperties = new HashMap<String, String>();
        private final Map<String, Map<String, String>> catalogSessionProperties = new HashMap<String, Map<String, String>>();
        private final SessionPropertyManager sessionPropertyManager;
        private final Map<String, String> preparedStatements = new HashMap<String, String>();

        private SessionBuilder(SessionPropertyManager sessionPropertyManager) {
            this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        }

        private SessionBuilder(Session session) {
            Objects.requireNonNull(session, "session is null");
            Preconditions.checkArgument((!session.getTransactionId().isPresent() ? 1 : 0) != 0, (Object)"Session builder cannot be created from a session in a transaction");
            this.sessionPropertyManager = session.sessionPropertyManager;
            this.queryId = session.queryId;
            this.transactionId = session.transactionId.orElse(null);
            this.clientTransactionSupport = session.clientTransactionSupport;
            this.identity = session.identity;
            this.source = session.source.orElse(null);
            this.catalog = session.catalog.orElse(null);
            this.schema = session.schema.orElse(null);
            this.timeZoneKey = session.timeZoneKey;
            this.locale = session.locale;
            this.remoteUserAddress = session.remoteUserAddress.orElse(null);
            this.userAgent = session.userAgent.orElse(null);
            this.clientInfo = session.clientInfo.orElse(null);
            this.clientTags = ImmutableSet.copyOf((Collection)session.clientTags);
            this.startTime = session.startTime;
            this.systemProperties.putAll(session.systemProperties);
            this.catalogSessionProperties.putAll(session.unprocessedCatalogProperties);
            this.preparedStatements.putAll(session.preparedStatements);
        }

        public SessionBuilder setQueryId(QueryId queryId) {
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            return this;
        }

        public SessionBuilder setTransactionId(TransactionId transactionId) {
            Preconditions.checkArgument((boolean)this.catalogSessionProperties.isEmpty(), (Object)"Catalog session properties cannot be set if there is an open transaction");
            this.transactionId = transactionId;
            return this;
        }

        public SessionBuilder setClientTransactionSupport() {
            this.clientTransactionSupport = true;
            return this;
        }

        public SessionBuilder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public SessionBuilder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public SessionBuilder setRemoteUserAddress(String remoteUserAddress) {
            this.remoteUserAddress = remoteUserAddress;
            return this;
        }

        public SessionBuilder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public SessionBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public SessionBuilder setStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public SessionBuilder setTimeZoneKey(TimeZoneKey timeZoneKey) {
            this.timeZoneKey = timeZoneKey;
            return this;
        }

        public SessionBuilder setIdentity(Identity identity) {
            this.identity = identity;
            return this;
        }

        public SessionBuilder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public SessionBuilder setClientInfo(String clientInfo) {
            this.clientInfo = clientInfo;
            return this;
        }

        public SessionBuilder setClientTags(Set<String> clientTags) {
            this.clientTags = ImmutableSet.copyOf(clientTags);
            return this;
        }

        public SessionBuilder setSystemProperty(String propertyName, String propertyValue) {
            this.systemProperties.put(propertyName, propertyValue);
            return this;
        }

        public SessionBuilder setCatalogSessionProperty(String catalogName, String propertyName, String propertyValue) {
            Preconditions.checkArgument((this.transactionId == null ? 1 : 0) != 0, (Object)"Catalog session properties cannot be set if there is an open transaction");
            this.catalogSessionProperties.computeIfAbsent(catalogName, id -> new HashMap()).put(propertyName, propertyValue);
            return this;
        }

        public SessionBuilder addPreparedStatement(String statementName, String query) {
            this.preparedStatements.put(statementName, query);
            return this;
        }

        public Session build() {
            return new Session(this.queryId, Optional.ofNullable(this.transactionId), this.clientTransactionSupport, this.identity, Optional.ofNullable(this.source), Optional.ofNullable(this.catalog), Optional.ofNullable(this.schema), this.timeZoneKey, this.locale, Optional.ofNullable(this.remoteUserAddress), Optional.ofNullable(this.userAgent), Optional.ofNullable(this.clientInfo), this.clientTags, this.startTime, this.systemProperties, (Map<ConnectorId, Map<String, String>>)ImmutableMap.of(), this.catalogSessionProperties, this.sessionPropertyManager, this.preparedStatements);
        }
    }
}

