/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.booleans.BooleanOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleHash;
import it.unimi.dsi.fastutil.doubles.DoubleOpenCustomHashSet;
import it.unimi.dsi.fastutil.longs.LongHash;
import it.unimi.dsi.fastutil.longs.LongOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Set;

public final class FastutilSetHelper {
    private FastutilSetHelper() {
    }

    public static Set<?> toFastutilHashSet(Set<?> set, Type type, FunctionRegistry registry) {
        Class javaElementType = type.getJavaType();
        if (javaElementType == Long.TYPE) {
            return new LongOpenCustomHashSet(set, 0.25f, (LongHash.Strategy)new LongStrategy(registry, type));
        }
        if (javaElementType == Double.TYPE) {
            return new DoubleOpenCustomHashSet(set, 0.25f, (DoubleHash.Strategy)new DoubleStrategy(registry, type));
        }
        if (javaElementType == Boolean.TYPE) {
            return new BooleanOpenHashSet(set, 0.25f);
        }
        if (!type.getJavaType().isPrimitive()) {
            return new ObjectOpenCustomHashSet(set, 0.25f, (Hash.Strategy)new ObjectStrategy(registry, type));
        }
        throw new UnsupportedOperationException("Unsupported native type in set: " + type.getJavaType() + " with type " + type.getTypeSignature());
    }

    public static boolean in(boolean booleanValue, BooleanOpenHashSet set) {
        return set.contains(booleanValue);
    }

    public static boolean in(double doubleValue, DoubleOpenCustomHashSet set) {
        return set.contains(doubleValue);
    }

    public static boolean in(long longValue, LongOpenCustomHashSet set) {
        return set.contains(longValue);
    }

    public static boolean in(Object objectValue, ObjectOpenCustomHashSet<?> set) {
        return set.contains(objectValue);
    }

    private static final class ObjectStrategy
    implements Hash.Strategy {
        private final MethodHandle hashCodeHandle;
        private final MethodHandle equalsHandle;

        private ObjectStrategy(FunctionRegistry registry, Type type) {
            this.hashCodeHandle = registry.getScalarFunctionImplementation(registry.resolveOperator(OperatorType.HASH_CODE, (List<? extends Type>)ImmutableList.of((Object)type))).getMethodHandle().asType(MethodType.methodType(Long.TYPE, Object.class));
            this.equalsHandle = registry.getScalarFunctionImplementation(registry.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))).getMethodHandle().asType(MethodType.methodType(Boolean.TYPE, Object.class, Object.class));
        }

        public int hashCode(Object value) {
            try {
                return Math.toIntExact(Long.hashCode(this.hashCodeHandle.invokeExact(value)));
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }

        public boolean equals(Object a, Object b) {
            try {
                return this.equalsHandle.invokeExact(a, b);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }

    private static final class DoubleStrategy
    implements DoubleHash.Strategy {
        private final MethodHandle hashCodeHandle;
        private final MethodHandle equalsHandle;

        private DoubleStrategy(FunctionRegistry registry, Type type) {
            this.hashCodeHandle = registry.getScalarFunctionImplementation(registry.resolveOperator(OperatorType.HASH_CODE, (List<? extends Type>)ImmutableList.of((Object)type))).getMethodHandle();
            this.equalsHandle = registry.getScalarFunctionImplementation(registry.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))).getMethodHandle();
        }

        public int hashCode(double value) {
            try {
                return Long.hashCode(this.hashCodeHandle.invokeExact(value));
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }

        public boolean equals(double a, double b) {
            try {
                return this.equalsHandle.invokeExact(a, b);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }

    private static final class LongStrategy
    implements LongHash.Strategy {
        private final MethodHandle hashCodeHandle;
        private final MethodHandle equalsHandle;

        private LongStrategy(FunctionRegistry registry, Type type) {
            this.hashCodeHandle = registry.getScalarFunctionImplementation(registry.resolveOperator(OperatorType.HASH_CODE, (List<? extends Type>)ImmutableList.of((Object)type))).getMethodHandle();
            this.equalsHandle = registry.getScalarFunctionImplementation(registry.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))).getMethodHandle();
        }

        public int hashCode(long value) {
            try {
                return Long.hashCode(this.hashCodeHandle.invokeExact(value));
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }

        public boolean equals(long a, long b) {
            try {
                return this.equalsHandle.invokeExact(a, b);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }
}

