/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.block.MethodHandleUtil;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.ParameterKind;
import com.facebook.presto.spi.type.ParametricType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeParameter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class MapParametricType
implements ParametricType {
    public static final MapParametricType MAP = new MapParametricType();

    public String getName() {
        return "map";
    }

    public Type createType(TypeManager typeManager, List<TypeParameter> parameters) {
        Preconditions.checkArgument((parameters.size() == 2 ? 1 : 0) != 0, (String)"Expected two parameters, got %s", parameters);
        TypeParameter firstParameter = parameters.get(0);
        TypeParameter secondParameter = parameters.get(1);
        Preconditions.checkArgument((firstParameter.getKind() == ParameterKind.TYPE && secondParameter.getKind() == ParameterKind.TYPE ? 1 : 0) != 0, (String)"Expected key and type to be types, got %s", parameters);
        Type keyType = firstParameter.getType();
        Type valueType = secondParameter.getType();
        MethodHandle keyNativeEquals = typeManager.resolveOperator(OperatorType.EQUAL, (List)ImmutableList.of((Object)keyType, (Object)keyType));
        MethodHandle keyBlockNativeEquals = MethodHandleUtil.compose((MethodHandle)keyNativeEquals, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType));
        MethodHandle keyNativeHashCode = typeManager.resolveOperator(OperatorType.HASH_CODE, (List)ImmutableList.of((Object)keyType));
        MethodHandle keyBlockHashCode = MethodHandleUtil.compose((MethodHandle)keyNativeHashCode, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType));
        return new MapType(keyType, valueType, keyBlockNativeEquals, keyNativeHashCode, keyBlockHashCode);
    }
}

