/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.google.common.net.InetAddresses;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class IpAddressOperators {
    private IpAddressOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="ipaddress") Slice left, @SqlType(value="ipaddress") Slice right) {
        return left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="ipaddress") Slice left, @SqlType(value="ipaddress") Slice right) {
        return !left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="ipaddress") Slice left, @SqlType(value="ipaddress") Slice right) {
        return left.compareTo(right) < 0;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="ipaddress") Slice left, @SqlType(value="ipaddress") Slice right) {
        return left.compareTo(right) <= 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="ipaddress") Slice left, @SqlType(value="ipaddress") Slice right) {
        return left.compareTo(right) > 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="ipaddress") Slice left, @SqlType(value="ipaddress") Slice right) {
        return left.compareTo(right) >= 0;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="ipaddress") Slice value, @SqlType(value="ipaddress") Slice min, @SqlType(value="ipaddress") Slice max) {
        return min.compareTo(value) <= 0 && value.compareTo(max) <= 0;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="ipaddress") Slice value) {
        return XxHash64.hash((Slice)value);
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="ipaddress")
    public static Slice castFromVarcharToIpAddress(@SqlType(value="varchar(x)") Slice slice) {
        byte[] bytes;
        byte[] address;
        try {
            address = InetAddresses.forString((String)slice.toStringUtf8()).getAddress();
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast value to IPADDRESS: " + slice.toStringUtf8());
        }
        if (address.length == 4) {
            bytes = new byte[16];
            bytes[10] = -1;
            bytes[11] = -1;
            System.arraycopy(address, 0, bytes, 12, 4);
        } else if (address.length == 16) {
            bytes = address;
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Invalid InetAddress length: " + address.length);
        }
        return Slices.wrappedBuffer((byte[])bytes);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar")
    public static Slice castFromIpAddressToVarchar(@SqlType(value="ipaddress") Slice slice) {
        try {
            return Slices.utf8Slice((String)InetAddresses.toAddrString((InetAddress)InetAddress.getByAddress(slice.getBytes())));
        }
        catch (UnknownHostException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Invalid IP address binary length: " + slice.length(), (Throwable)e);
        }
    }
}

