/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SignatureBuilder;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.SqlScalarFunctionBuilder;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.UnscaledDecimal128Arithmetic;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class DecimalOperators {
    public static final SqlScalarFunction DECIMAL_ADD_OPERATOR = DecimalOperators.decimalAddOperator();
    public static final SqlScalarFunction DECIMAL_SUBTRACT_OPERATOR = DecimalOperators.decimalSubtractOperator();
    public static final SqlScalarFunction DECIMAL_MULTIPLY_OPERATOR = DecimalOperators.decimalMultiplyOperator();
    public static final SqlScalarFunction DECIMAL_DIVIDE_OPERATOR = DecimalOperators.decimalDivideOperator();
    public static final SqlScalarFunction DECIMAL_MODULUS_OPERATOR = DecimalOperators.decimalModulusOperator();

    private DecimalOperators() {
    }

    private static SqlScalarFunction decimalAddOperator() {
        TypeSignature decimalLeftSignature = TypeSignature.parseTypeSignature((String)"decimal(a_precision, a_scale)", (Set)ImmutableSet.of((Object)"a_precision", (Object)"a_scale"));
        TypeSignature decimalRightSignature = TypeSignature.parseTypeSignature((String)"decimal(b_precision, b_scale)", (Set)ImmutableSet.of((Object)"b_precision", (Object)"b_scale"));
        TypeSignature decimalResultSignature = TypeSignature.parseTypeSignature((String)"decimal(r_precision, r_scale)", (Set)ImmutableSet.of((Object)"r_precision", (Object)"r_scale"));
        Signature signature = Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.ADD).longVariableConstraints(Signature.longVariableExpression("r_precision", "min(38, max(a_precision - a_scale, b_precision - b_scale) + max(a_scale, b_scale) + 1)"), Signature.longVariableExpression("r_scale", "max(a_scale, b_scale)")).argumentTypes(decimalLeftSignature, decimalRightSignature).returnType(decimalResultSignature).build();
        return SqlScalarFunction.builder(DecimalOperators.class).signature(signature).implementation(b -> b.methods("addShortShortShort").withExtraParameters(DecimalOperators::calculateShortRescaleParameters)).implementation(b -> b.methods("addShortShortLong", "addLongLongLong", "addShortLongLong", "addLongShortLong").withExtraParameters(DecimalOperators::calculateLongRescaleParameters)).build();
    }

    @UsedByGeneratedCode
    public static long addShortShortShort(long a, long b, long aRescale, long bRescale) {
        return a * aRescale + b * bRescale;
    }

    @UsedByGeneratedCode
    public static Slice addShortShortLong(long a, long b, int rescale, boolean left) {
        return DecimalOperators.internalAddLongLongLong(UnscaledDecimal128Arithmetic.unscaledDecimal((long)a), UnscaledDecimal128Arithmetic.unscaledDecimal((long)b), rescale, left);
    }

    @UsedByGeneratedCode
    public static Slice addLongLongLong(Slice a, Slice b, int rescale, boolean left) {
        return DecimalOperators.internalAddLongLongLong(a, b, rescale, left);
    }

    @UsedByGeneratedCode
    public static Slice addShortLongLong(long a, Slice b, int rescale, boolean left) {
        return DecimalOperators.internalAddLongLongLong(UnscaledDecimal128Arithmetic.unscaledDecimal((long)a), b, rescale, left);
    }

    @UsedByGeneratedCode
    public static Slice addLongShortLong(Slice a, long b, int rescale, boolean left) {
        return DecimalOperators.internalAddLongLongLong(a, UnscaledDecimal128Arithmetic.unscaledDecimal((long)b), rescale, left);
    }

    private static Slice internalAddLongLongLong(Slice a, Slice b, int rescale, boolean rescaleLeft) {
        try {
            Slice right;
            Slice left = UnscaledDecimal128Arithmetic.unscaledDecimal();
            if (rescaleLeft) {
                UnscaledDecimal128Arithmetic.rescale((Slice)a, (int)rescale, (Slice)left);
                right = b;
            } else {
                UnscaledDecimal128Arithmetic.rescale((Slice)b, (int)rescale, (Slice)left);
                right = a;
            }
            UnscaledDecimal128Arithmetic.add((Slice)left, (Slice)right, (Slice)left);
            UnscaledDecimal128Arithmetic.throwIfOverflows((Slice)left);
            return left;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    private static SqlScalarFunction decimalSubtractOperator() {
        TypeSignature decimalLeftSignature = TypeSignature.parseTypeSignature((String)"decimal(a_precision, a_scale)", (Set)ImmutableSet.of((Object)"a_precision", (Object)"a_scale"));
        TypeSignature decimalRightSignature = TypeSignature.parseTypeSignature((String)"decimal(b_precision, b_scale)", (Set)ImmutableSet.of((Object)"b_precision", (Object)"b_scale"));
        TypeSignature decimalResultSignature = TypeSignature.parseTypeSignature((String)"decimal(r_precision, r_scale)", (Set)ImmutableSet.of((Object)"r_precision", (Object)"r_scale"));
        Signature signature = Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.SUBTRACT).longVariableConstraints(Signature.longVariableExpression("r_precision", "min(38, max(a_precision - a_scale, b_precision - b_scale) + max(a_scale, b_scale) + 1)"), Signature.longVariableExpression("r_scale", "max(a_scale, b_scale)")).argumentTypes(decimalLeftSignature, decimalRightSignature).returnType(decimalResultSignature).build();
        return SqlScalarFunction.builder(DecimalOperators.class).signature(signature).implementation(b -> b.methods("subtractShortShortShort").withExtraParameters(DecimalOperators::calculateShortRescaleParameters)).implementation(b -> b.methods("subtractShortShortLong", "subtractLongLongLong", "subtractShortLongLong", "subtractLongShortLong").withExtraParameters(DecimalOperators::calculateLongRescaleParameters)).build();
    }

    @UsedByGeneratedCode
    public static long subtractShortShortShort(long a, long b, long aRescale, long bRescale) {
        return a * aRescale - b * bRescale;
    }

    @UsedByGeneratedCode
    public static Slice subtractShortShortLong(long a, long b, int rescale, boolean left) {
        return DecimalOperators.internalSubtractLongLongLong(UnscaledDecimal128Arithmetic.unscaledDecimal((long)a), UnscaledDecimal128Arithmetic.unscaledDecimal((long)b), rescale, left);
    }

    @UsedByGeneratedCode
    public static Slice subtractLongLongLong(Slice a, Slice b, int rescale, boolean left) {
        return DecimalOperators.internalSubtractLongLongLong(a, b, rescale, left);
    }

    @UsedByGeneratedCode
    public static Slice subtractShortLongLong(long a, Slice b, int rescale, boolean left) {
        return DecimalOperators.internalSubtractLongLongLong(UnscaledDecimal128Arithmetic.unscaledDecimal((long)a), b, rescale, left);
    }

    @UsedByGeneratedCode
    public static Slice subtractLongShortLong(Slice a, long b, int rescale, boolean left) {
        return DecimalOperators.internalSubtractLongLongLong(a, UnscaledDecimal128Arithmetic.unscaledDecimal((long)b), rescale, left);
    }

    private static Slice internalSubtractLongLongLong(Slice a, Slice b, int rescale, boolean rescaleLeft) {
        try {
            Slice tmp = UnscaledDecimal128Arithmetic.unscaledDecimal();
            if (rescaleLeft) {
                UnscaledDecimal128Arithmetic.rescale((Slice)a, (int)rescale, (Slice)tmp);
                UnscaledDecimal128Arithmetic.subtract((Slice)tmp, (Slice)b, (Slice)tmp);
            } else {
                UnscaledDecimal128Arithmetic.rescale((Slice)b, (int)rescale, (Slice)tmp);
                UnscaledDecimal128Arithmetic.subtract((Slice)a, (Slice)tmp, (Slice)tmp);
            }
            UnscaledDecimal128Arithmetic.throwIfOverflows((Slice)tmp);
            return tmp;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    private static SqlScalarFunction decimalMultiplyOperator() {
        TypeSignature decimalLeftSignature = TypeSignature.parseTypeSignature((String)"decimal(a_precision, a_scale)", (Set)ImmutableSet.of((Object)"a_precision", (Object)"a_scale"));
        TypeSignature decimalRightSignature = TypeSignature.parseTypeSignature((String)"decimal(b_precision, b_scale)", (Set)ImmutableSet.of((Object)"b_precision", (Object)"b_scale"));
        TypeSignature decimalResultSignature = TypeSignature.parseTypeSignature((String)"decimal(r_precision, r_scale)", (Set)ImmutableSet.of((Object)"r_precision", (Object)"r_scale"));
        Signature signature = Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.MULTIPLY).longVariableConstraints(Signature.longVariableExpression("r_precision", "min(38, a_precision + b_precision)"), Signature.longVariableExpression("r_scale", "a_scale + b_scale")).argumentTypes(decimalLeftSignature, decimalRightSignature).returnType(decimalResultSignature).build();
        return SqlScalarFunction.builder(DecimalOperators.class).signature(signature).implementation(b -> b.methods("multiplyShortShortShort", "multiplyShortShortLong", "multiplyLongLongLong", "multiplyShortLongLong", "multiplyLongShortLong")).build();
    }

    @UsedByGeneratedCode
    public static long multiplyShortShortShort(long a, long b) {
        return a * b;
    }

    @UsedByGeneratedCode
    public static Slice multiplyShortShortLong(long a, long b) {
        return DecimalOperators.multiplyLongLongLong(Decimals.encodeUnscaledValue((long)a), Decimals.encodeUnscaledValue((long)b));
    }

    @UsedByGeneratedCode
    public static Slice multiplyLongLongLong(Slice a, Slice b) {
        try {
            Slice result = UnscaledDecimal128Arithmetic.multiply((Slice)a, (Slice)b);
            UnscaledDecimal128Arithmetic.throwIfOverflows((Slice)result);
            return result;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Slice multiplyShortLongLong(long a, Slice b) {
        return DecimalOperators.multiplyLongLongLong(Decimals.encodeUnscaledValue((long)a), b);
    }

    @UsedByGeneratedCode
    public static Slice multiplyLongShortLong(Slice a, long b) {
        return DecimalOperators.multiplyLongLongLong(a, Decimals.encodeUnscaledValue((long)b));
    }

    private static SqlScalarFunction decimalDivideOperator() {
        TypeSignature decimalLeftSignature = TypeSignature.parseTypeSignature((String)"decimal(a_precision, a_scale)", (Set)ImmutableSet.of((Object)"a_precision", (Object)"a_scale"));
        TypeSignature decimalRightSignature = TypeSignature.parseTypeSignature((String)"decimal(b_precision, b_scale)", (Set)ImmutableSet.of((Object)"b_precision", (Object)"b_scale"));
        TypeSignature decimalResultSignature = TypeSignature.parseTypeSignature((String)"decimal(r_precision, r_scale)", (Set)ImmutableSet.of((Object)"r_precision", (Object)"r_scale"));
        Signature signature = Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.DIVIDE).longVariableConstraints(Signature.longVariableExpression("r_precision", "min(38, a_precision + b_scale + max(b_scale - a_scale, 0))"), Signature.longVariableExpression("r_scale", "max(a_scale, b_scale)")).argumentTypes(decimalLeftSignature, decimalRightSignature).returnType(decimalResultSignature).build();
        return SqlScalarFunction.builder(DecimalOperators.class).signature(signature).implementation(b -> b.methods("divideShortShortShort", "divideShortLongShort", "divideLongShortShort", "divideShortShortLong", "divideLongLongLong", "divideShortLongLong", "divideLongShortLong").withExtraParameters(DecimalOperators::divideRescaleFactor)).build();
    }

    private static List<Object> divideRescaleFactor(SqlScalarFunctionBuilder.SpecializeContext context) {
        DecimalType returnType = (DecimalType)context.getReturnType();
        int dividendScale = Math.toIntExact(Objects.requireNonNull(context.getLiteral("a_scale"), "a_scale is null"));
        int divisorScale = Math.toIntExact(Objects.requireNonNull(context.getLiteral("b_scale"), "b_scale is null"));
        int resultScale = returnType.getScale();
        int rescaleFactor = resultScale - dividendScale + divisorScale;
        return ImmutableList.of((Object)rescaleFactor);
    }

    @UsedByGeneratedCode
    public static long divideShortShortShort(long dividend, long divisor, int rescaleFactor) {
        long quotient;
        if (divisor == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        if (dividend == 0L) {
            return 0L;
        }
        int resultSignum = Long.signum(dividend) * Long.signum(divisor);
        long unsignedDividend = Math.abs(dividend);
        long unsignedDivisor = Math.abs(divisor);
        long rescaledUnsignedDividend = unsignedDividend * Decimals.longTenToNth((int)rescaleFactor);
        long remainder = rescaledUnsignedDividend - (quotient = rescaledUnsignedDividend / unsignedDivisor) * unsignedDivisor;
        if (Long.compareUnsigned(remainder * 2L, unsignedDivisor) >= 0) {
            ++quotient;
        }
        return (long)resultSignum * quotient;
    }

    @UsedByGeneratedCode
    public static long divideShortLongShort(long dividend, Slice divisor, int rescaleFactor) {
        if (UnscaledDecimal128Arithmetic.isZero((Slice)divisor)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLong((Slice)UnscaledDecimal128Arithmetic.divideRoundUp((long)dividend, (int)rescaleFactor, (Slice)divisor));
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static long divideLongShortShort(Slice dividend, long divisor, int rescaleFactor) {
        if (divisor == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLong((Slice)UnscaledDecimal128Arithmetic.divideRoundUp((Slice)dividend, (int)rescaleFactor, (long)divisor));
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Slice divideShortShortLong(long dividend, long divisor, int rescaleFactor) {
        if (divisor == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return UnscaledDecimal128Arithmetic.divideRoundUp((long)dividend, (int)rescaleFactor, (long)divisor);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Slice divideLongLongLong(Slice dividend, Slice divisor, int rescaleFactor) {
        if (UnscaledDecimal128Arithmetic.isZero((Slice)divisor)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return UnscaledDecimal128Arithmetic.divideRoundUp((Slice)dividend, (int)rescaleFactor, (Slice)divisor);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Slice divideShortLongLong(long dividend, Slice divisor, int rescaleFactor) {
        if (UnscaledDecimal128Arithmetic.isZero((Slice)divisor)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return UnscaledDecimal128Arithmetic.divideRoundUp((long)dividend, (int)rescaleFactor, (Slice)divisor);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Slice divideLongShortLong(Slice dividend, long divisor, int rescaleFactor) {
        if (divisor == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return UnscaledDecimal128Arithmetic.divideRoundUp((Slice)dividend, (int)rescaleFactor, (long)divisor);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    private static SqlScalarFunction decimalModulusOperator() {
        Signature signature = DecimalOperators.modulusSignatureBuilder().operatorType(OperatorType.MODULUS).build();
        return DecimalOperators.modulusScalarFunction(signature);
    }

    public static SqlScalarFunction modulusScalarFunction(Signature signature) {
        return SqlScalarFunction.builder(DecimalOperators.class).signature(signature).implementation(b -> b.methods("modulusShortShortShort", "modulusLongLongLong", "modulusShortLongLong", "modulusShortLongShort", "modulusLongShortShort", "modulusLongShortLong").withExtraParameters(DecimalOperators::modulusRescaleParameters)).build();
    }

    public static SignatureBuilder modulusSignatureBuilder() {
        TypeSignature decimalLeftSignature = TypeSignature.parseTypeSignature((String)"decimal(a_precision, a_scale)", (Set)ImmutableSet.of((Object)"a_precision", (Object)"a_scale"));
        TypeSignature decimalRightSignature = TypeSignature.parseTypeSignature((String)"decimal(b_precision, b_scale)", (Set)ImmutableSet.of((Object)"b_precision", (Object)"b_scale"));
        TypeSignature decimalResultSignature = TypeSignature.parseTypeSignature((String)"decimal(r_precision, r_scale)", (Set)ImmutableSet.of((Object)"r_precision", (Object)"r_scale"));
        return Signature.builder().longVariableConstraints(Signature.longVariableExpression("r_precision", "min(b_precision - b_scale, a_precision - a_scale) + max(a_scale, b_scale)"), Signature.longVariableExpression("r_scale", "max(a_scale, b_scale)")).argumentTypes(decimalLeftSignature, decimalRightSignature).returnType(decimalResultSignature);
    }

    private static List<Object> calculateShortRescaleParameters(SqlScalarFunctionBuilder.SpecializeContext context) {
        long aRescale = Decimals.longTenToNth((int)DecimalOperators.rescaleFactor(context.getLiteral("a_scale"), context.getLiteral("b_scale")));
        long bRescale = Decimals.longTenToNth((int)DecimalOperators.rescaleFactor(context.getLiteral("b_scale"), context.getLiteral("a_scale")));
        return ImmutableList.of((Object)aRescale, (Object)bRescale);
    }

    private static List<Object> calculateLongRescaleParameters(SqlScalarFunctionBuilder.SpecializeContext context) {
        boolean left;
        int rescale;
        long aScale = context.getLiteral("a_scale");
        long bScale = context.getLiteral("b_scale");
        int aRescale = DecimalOperators.rescaleFactor(aScale, bScale);
        int bRescale = DecimalOperators.rescaleFactor(bScale, aScale);
        if (aRescale == 0) {
            rescale = bRescale;
            left = false;
        } else if (bRescale == 0) {
            rescale = aRescale;
            left = true;
        } else {
            throw new IllegalStateException();
        }
        return ImmutableList.of((Object)rescale, (Object)left);
    }

    private static List<Object> modulusRescaleParameters(SqlScalarFunctionBuilder.SpecializeContext context) {
        int dividendScale = Math.toIntExact(Objects.requireNonNull(context.getLiteral("a_scale"), "a_scale is null"));
        int divisorScale = Math.toIntExact(Objects.requireNonNull(context.getLiteral("b_scale"), "b_scale is null"));
        int dividendRescaleFactor = DecimalOperators.rescaleFactor(dividendScale, divisorScale);
        int divisorRescaleFactor = DecimalOperators.rescaleFactor(divisorScale, dividendScale);
        return ImmutableList.of((Object)dividendRescaleFactor, (Object)divisorRescaleFactor);
    }

    private static int rescaleFactor(long fromScale, long toScale) {
        return Integer.max(0, (int)toScale - (int)fromScale);
    }

    @UsedByGeneratedCode
    public static long modulusShortShortShort(long dividend, long divisor, int dividendRescaleFactor, int divisorRescaleFactor) {
        if (divisor == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLong((Slice)UnscaledDecimal128Arithmetic.remainder((long)dividend, (int)dividendRescaleFactor, (long)divisor, (int)divisorRescaleFactor));
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static long modulusShortLongShort(long dividend, Slice divisor, int dividendRescaleFactor, int divisorRescaleFactor) {
        if (UnscaledDecimal128Arithmetic.isZero((Slice)divisor)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLong((Slice)UnscaledDecimal128Arithmetic.remainder((long)dividend, (int)dividendRescaleFactor, (Slice)divisor, (int)divisorRescaleFactor));
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static long modulusLongShortShort(Slice dividend, long divisor, int dividendRescaleFactor, int divisorRescaleFactor) {
        if (divisor == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLong((Slice)UnscaledDecimal128Arithmetic.remainder((Slice)dividend, (int)dividendRescaleFactor, (long)divisor, (int)divisorRescaleFactor));
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Slice modulusShortLongLong(long dividend, Slice divisor, int dividendRescaleFactor, int divisorRescaleFactor) {
        if (UnscaledDecimal128Arithmetic.isZero((Slice)divisor)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return UnscaledDecimal128Arithmetic.remainder((long)dividend, (int)dividendRescaleFactor, (Slice)divisor, (int)divisorRescaleFactor);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Slice modulusLongShortLong(Slice dividend, long divisor, int dividendRescaleFactor, int divisorRescaleFactor) {
        if (divisor == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return UnscaledDecimal128Arithmetic.remainder((Slice)dividend, (int)dividendRescaleFactor, (long)divisor, (int)divisorRescaleFactor);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Slice modulusLongLongLong(Slice dividend, Slice divisor, int dividendRescaleFactor, int divisorRescaleFactor) {
        if (UnscaledDecimal128Arithmetic.isZero((Slice)divisor)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return UnscaledDecimal128Arithmetic.remainder((Slice)dividend, (int)dividendRescaleFactor, (Slice)divisor, (int)divisorRescaleFactor);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    public static final class HashCode {
        @LiteralParameters(value={"p", "s"})
        @SqlType(value="bigint")
        public static long hashCode(@SqlType(value="decimal(p, s)") long value) {
            return value;
        }

        @LiteralParameters(value={"p", "s"})
        @SqlType(value="bigint")
        public static long hashCode(@SqlType(value="decimal(p, s)") Slice value) {
            return UnscaledDecimal128Arithmetic.hash((Slice)value);
        }
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    public static final class Negation {
        @LiteralParameters(value={"p", "s"})
        @SqlType(value="decimal(p, s)")
        public static long negate(@SqlType(value="decimal(p, s)") long arg) {
            return -arg;
        }

        @LiteralParameters(value={"p", "s"})
        @SqlType(value="decimal(p, s)")
        public static Slice negate(@SqlType(value="decimal(p, s)") Slice arg) {
            BigInteger argBigInteger = Decimals.decodeUnscaledValue((Slice)arg);
            return Decimals.encodeUnscaledValue((BigInteger)argBigInteger.negate());
        }
    }
}

