/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class PageConsumerOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final Consumer<Page> pageConsumer;
    private final Function<Page, Page> pagePreprocessor;
    private boolean finished;
    private boolean closed;

    public PageConsumerOperator(OperatorContext operatorContext, Consumer<Page> pageConsumer, Function<Page, Page> pagePreprocessor) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.pageConsumer = Objects.requireNonNull(pageConsumer, "pageConsumer is null");
        this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return ImmutableList.of();
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"operator finished");
        page = this.pagePreprocessor.apply(page);
        this.pageConsumer.accept(page);
        this.operatorContext.recordGeneratedOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public static class PageConsumerOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Consumer<Page> pageConsumer;
        private final Function<Page, Page> pagePreprocessor;
        private boolean closed;

        public PageConsumerOperatorFactory(int operatorId, PlanNodeId planNodeId, Consumer<Page> pageConsumer, Function<Page, Page> pagePreprocessor) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.pageConsumer = Objects.requireNonNull(pageConsumer, "pageConsumer is null");
            this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
        }

        @Override
        public List<Type> getTypes() {
            return ImmutableList.of();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, PageConsumerOperator.class.getSimpleName());
            return new PageConsumerOperator(operatorContext, this.pageConsumer, this.pagePreprocessor);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new PageConsumerOperatorFactory(this.operatorId, this.planNodeId, this.pageConsumer, this.pagePreprocessor);
        }
    }

    public static class PageConsumerOutputFactory
    implements OutputFactory {
        private final Function<List<Type>, Consumer<Page>> pageConsumerFactory;

        public PageConsumerOutputFactory(Function<List<Type>, Consumer<Page>> pageConsumerFactory) {
            this.pageConsumerFactory = Objects.requireNonNull(pageConsumerFactory, "pageConsumerFactory is null");
        }

        @Override
        public OperatorFactory createOutputOperator(int operatorId, PlanNodeId planNodeId, List<Type> types, Function<Page, Page> pagePreprocessor, PagesSerdeFactory serdeFactory) {
            return new PageConsumerOperatorFactory(operatorId, planNodeId, this.pageConsumerFactory.apply(types), pagePreprocessor);
        }
    }
}

