/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.util.MoreLists;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public class GroupIdNode
extends PlanNode {
    private final PlanNode source;
    private final List<List<Symbol>> groupingSets;
    private final Map<Symbol, Symbol> groupingSetMappings;
    private final Map<Symbol, Symbol> argumentMappings;
    private final Symbol groupIdSymbol;

    @JsonCreator
    public GroupIdNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="groupingSets") List<List<Symbol>> groupingSets, @JsonProperty(value="groupingSetMappings") Map<Symbol, Symbol> groupingSetMappings, @JsonProperty(value="argumentMappings") Map<Symbol, Symbol> argumentMappings, @JsonProperty(value="groupIdSymbol") Symbol groupIdSymbol) {
        super(id);
        this.source = Objects.requireNonNull(source);
        this.groupingSets = MoreLists.listOfListsCopy(Objects.requireNonNull(groupingSets, "groupingSets is null"));
        this.groupingSetMappings = ImmutableMap.copyOf(Objects.requireNonNull(groupingSetMappings));
        this.argumentMappings = ImmutableMap.copyOf(Objects.requireNonNull(argumentMappings));
        this.groupIdSymbol = Objects.requireNonNull(groupIdSymbol);
        Preconditions.checkArgument((boolean)Sets.intersection(groupingSetMappings.keySet(), argumentMappings.keySet()).isEmpty(), (Object)"argument outputs and grouping outputs must be a disjoint set");
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll((Iterable)this.groupingSets.stream().flatMap(Collection::stream).collect(Collectors.toSet())).addAll(this.argumentMappings.keySet()).add((Object)this.groupIdSymbol).build();
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public List<List<Symbol>> getGroupingSets() {
        return this.groupingSets;
    }

    @JsonProperty
    public Map<Symbol, Symbol> getGroupingSetMappings() {
        return this.groupingSetMappings;
    }

    @JsonProperty
    public Map<Symbol, Symbol> getArgumentMappings() {
        return this.argumentMappings;
    }

    @JsonProperty
    public Symbol getGroupIdSymbol() {
        return this.groupIdSymbol;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitGroupId(this, context);
    }

    public Set<Symbol> getInputSymbols() {
        return ImmutableSet.builder().addAll(this.argumentMappings.values()).addAll((Iterable)this.groupingSets.stream().map(set -> set.stream().map(this.groupingSetMappings::get).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet())).build();
    }

    public Set<Symbol> getCommonGroupingColumns() {
        HashSet intersection = new HashSet(this.groupingSets.get(0));
        for (int i = 1; i < this.groupingSets.size(); ++i) {
            intersection.retainAll((Collection)this.groupingSets.get(i));
        }
        return ImmutableSet.copyOf(intersection);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new GroupIdNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.groupingSets, this.groupingSetMappings, this.argumentMappings, this.groupIdSymbol);
    }
}

