/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ApplyNode
extends PlanNode {
    private final PlanNode input;
    private final PlanNode subquery;
    private final List<Symbol> correlation;
    private final Assignments subqueryAssignments;
    private final Node originSubquery;

    @JsonCreator
    public ApplyNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="input") PlanNode input, @JsonProperty(value="subquery") PlanNode subquery, @JsonProperty(value="subqueryAssignments") Assignments subqueryAssignments, @JsonProperty(value="correlation") List<Symbol> correlation, @JsonProperty(value="originSubquery") Node originSubquery) {
        super(id);
        Objects.requireNonNull(input, "input is null");
        Objects.requireNonNull(subquery, "right is null");
        Objects.requireNonNull(subqueryAssignments, "assignments is null");
        Objects.requireNonNull(correlation, "correlation is null");
        Objects.requireNonNull(originSubquery, "originSubquery is null");
        Preconditions.checkArgument((boolean)input.getOutputSymbols().containsAll(correlation), (Object)"Input does not contain symbols from correlation");
        Preconditions.checkArgument((boolean)subqueryAssignments.getExpressions().stream().allMatch(ApplyNode::isSupportedSubqueryExpression), (Object)"Unexpected expression used for subquery expression");
        this.input = input;
        this.subquery = subquery;
        this.subqueryAssignments = subqueryAssignments;
        this.correlation = ImmutableList.copyOf(correlation);
        this.originSubquery = originSubquery;
    }

    private static boolean isSupportedSubqueryExpression(Expression expression) {
        return expression instanceof InPredicate || expression instanceof ExistsPredicate || expression instanceof QuantifiedComparisonExpression;
    }

    @JsonProperty(value="input")
    public PlanNode getInput() {
        return this.input;
    }

    @JsonProperty(value="subquery")
    public PlanNode getSubquery() {
        return this.subquery;
    }

    @JsonProperty(value="subqueryAssignments")
    public Assignments getSubqueryAssignments() {
        return this.subqueryAssignments;
    }

    @JsonProperty(value="correlation")
    public List<Symbol> getCorrelation() {
        return this.correlation;
    }

    @JsonProperty(value="originSubquery")
    public Node getOriginSubquery() {
        return this.originSubquery;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.input, (Object)this.subquery);
    }

    @Override
    @JsonProperty(value="outputSymbols")
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.input.getOutputSymbols()).addAll(this.subqueryAssignments.getOutputs()).build();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitApply(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new ApplyNode(this.getId(), newChildren.get(0), newChildren.get(1), this.subqueryAssignments, this.correlation, this.originSubquery);
    }
}

