/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.sql.planner.SymbolsExtractor;
import com.facebook.presto.sql.planner.plan.WindowNode;

public final class WindowNodeUtil {
    private WindowNodeUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean dependsOn(WindowNode parent, WindowNode child) {
        if (parent.getPartitionBy().stream().anyMatch(child.getCreatedSymbols()::contains)) return true;
        if (parent.getOrderBy().stream().anyMatch(child.getCreatedSymbols()::contains)) return true;
        if (!parent.getWindowFunctions().values().stream().map(WindowNode.Function::getFunctionCall).map(SymbolsExtractor::extractUnique).flatMap(symbols -> symbols.stream()).anyMatch(child.getCreatedSymbols()::contains)) return false;
        return true;
    }
}

