/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.optimizations.PlanNodeDecorrelator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TransformCorrelatedNoAggregationSubqueryToJoin
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        return SimplePlanRewriter.rewriteWith(new Rewriter(idAllocator), plan, null);
    }

    private static class Rewriter
    extends SimplePlanRewriter<PlanNode> {
        private final PlanNodeIdAllocator idAllocator;

        public Rewriter(PlanNodeIdAllocator idAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        }

        @Override
        public PlanNode visitLateralJoin(LateralJoinNode node, SimplePlanRewriter.RewriteContext<PlanNode> context) {
            LateralJoinNode rewrittenNode = (LateralJoinNode)context.defaultRewrite(node, context.get());
            if (!rewrittenNode.getCorrelation().isEmpty()) {
                return this.rewriteNoAggregationSubquery(rewrittenNode);
            }
            return rewrittenNode;
        }

        private PlanNode rewriteNoAggregationSubquery(LateralJoinNode lateral) {
            List<Symbol> correlation = lateral.getCorrelation();
            PlanNodeDecorrelator decorrelator = new PlanNodeDecorrelator(this.idAllocator, Lookup.noLookup());
            Optional<PlanNodeDecorrelator.DecorrelatedNode> source = decorrelator.decorrelateFilters(lateral.getSubquery(), correlation);
            if (!source.isPresent()) {
                return lateral;
            }
            return new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.INNER, lateral.getInput(), source.get().getNode(), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), lateral.getOutputSymbols(), source.get().getCorrelatedPredicates(), Optional.empty(), Optional.empty(), Optional.empty());
        }
    }
}

