/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.ComparisonExpressionType;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TransformExistsApplyToLateralNode
implements Rule<ApplyNode> {
    private static final Pattern<ApplyNode> PATTERN = Patterns.applyNode();
    private static final QualifiedName COUNT = QualifiedName.of((String)"count");
    private static final FunctionCall COUNT_CALL = new FunctionCall(COUNT, (List)ImmutableList.of());
    private final Signature countSignature;

    public TransformExistsApplyToLateralNode(FunctionRegistry functionRegistry) {
        Objects.requireNonNull(functionRegistry, "functionRegistry is null");
        this.countSignature = functionRegistry.resolveFunction(COUNT, (List<TypeSignatureProvider>)ImmutableList.of());
    }

    @Override
    public Pattern<ApplyNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ApplyNode parent, Captures captures, Rule.Context context) {
        if (parent.getSubqueryAssignments().size() != 1) {
            return Rule.Result.empty();
        }
        Expression expression = (Expression)Iterables.getOnlyElement(parent.getSubqueryAssignments().getExpressions());
        if (!(expression instanceof ExistsPredicate)) {
            return Rule.Result.empty();
        }
        Symbol count = context.getSymbolAllocator().newSymbol(COUNT.toString(), (Type)BigintType.BIGINT);
        Symbol exists = (Symbol)Iterables.getOnlyElement(parent.getSubqueryAssignments().getSymbols());
        return Rule.Result.ofPlanNode(new LateralJoinNode(parent.getId(), parent.getInput(), new ProjectNode(context.getIdAllocator().getNextId(), new AggregationNode(context.getIdAllocator().getNextId(), parent.getSubquery(), (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of((Object)count, (Object)new AggregationNode.Aggregation(COUNT_CALL, this.countSignature, Optional.empty())), (List<List<Symbol>>)ImmutableList.of((Object)ImmutableList.of()), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty()), Assignments.of(exists, (Expression)new ComparisonExpression(ComparisonExpressionType.GREATER_THAN, (Expression)count.toSymbolReference(), (Expression)new Cast((Expression)new LongLiteral("0"), BigintType.BIGINT.toString())))), parent.getCorrelation(), LateralJoinNode.Type.INNER, parent.getOriginSubquery()));
    }
}

