/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.NoOpSymbolResolver;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import com.facebook.presto.sql.planner.iterative.rule.ExtractCommonPredicatesExpressionRewriter;
import com.facebook.presto.sql.planner.iterative.rule.PushDownNegationsExpressionRewriter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SimplifyExpressions
extends ExpressionRewriteRuleSet {
    @VisibleForTesting
    static Expression rewrite(Expression expression, Session session, SymbolAllocator symbolAllocator, Metadata metadata, SqlParser sqlParser) {
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(sqlParser, "sqlParser is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        expression = PushDownNegationsExpressionRewriter.pushDownNegations(expression);
        expression = ExtractCommonPredicatesExpressionRewriter.extractCommonPredicates(expression);
        Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(session, metadata, sqlParser, symbolAllocator.getTypes(), expression, Collections.emptyList());
        ExpressionInterpreter interpreter = ExpressionInterpreter.expressionOptimizer(expression, metadata, session, expressionTypes);
        return LiteralInterpreter.toExpression(interpreter.optimize(NoOpSymbolResolver.INSTANCE), expressionTypes.get(NodeRef.of((Node)expression)));
    }

    public SimplifyExpressions(Metadata metadata, SqlParser sqlParser) {
        super(SimplifyExpressions.createRewrite(metadata, sqlParser));
    }

    @Override
    public Set<Rule<?>> rules() {
        return ImmutableSet.of(this.projectExpressionRewrite(), this.filterExpressionRewrite(), this.tableScanExpressionRewrite(), this.joinExpressionRewrite(), this.valuesExpressionRewrite());
    }

    private static ExpressionRewriteRuleSet.ExpressionRewriter createRewrite(Metadata metadata, SqlParser sqlParser) {
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(sqlParser, "sqlParser is null");
        return (expression, context) -> SimplifyExpressions.rewrite(expression, context.getSession(), context.getSymbolAllocator(), metadata, sqlParser);
    }
}

