/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.TableLayoutRewriter;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;

public class PickTableLayout {
    private final Metadata metadata;

    public PickTableLayout(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public Set<Rule<?>> rules() {
        return ImmutableSet.of((Object)this.pickTableLayoutForPredicate(), (Object)this.pickTableLayoutWithoutPredicate());
    }

    public PickTableLayoutForPredicate pickTableLayoutForPredicate() {
        return new PickTableLayoutForPredicate(this.metadata);
    }

    public PickTableLayoutWithoutPredicate pickTableLayoutWithoutPredicate() {
        return new PickTableLayoutWithoutPredicate(this.metadata);
    }

    private static final class PickTableLayoutWithoutPredicate
    implements Rule<TableScanNode> {
        private final Metadata metadata;
        private static final Pattern<TableScanNode> PATTERN = Patterns.tableScan();

        private PickTableLayoutWithoutPredicate(Metadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        @Override
        public Pattern<TableScanNode> getPattern() {
            return PATTERN;
        }

        @Override
        public Rule.Result apply(TableScanNode tableScanNode, Captures captures, Rule.Context context) {
            if (tableScanNode.getLayout().isPresent()) {
                return Rule.Result.empty();
            }
            TableLayoutRewriter tableLayoutRewriter = new TableLayoutRewriter(this.metadata, context.getSession(), context.getSymbolAllocator(), context.getIdAllocator());
            return Rule.Result.ofPlanNode(tableLayoutRewriter.planTableScan(tableScanNode, (Expression)BooleanLiteral.TRUE_LITERAL));
        }
    }

    private static final class PickTableLayoutForPredicate
    implements Rule<FilterNode> {
        private final Metadata metadata;
        private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
        private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.tableScan().matching(PickTableLayoutForPredicate::shouldRewriteTableLayout).capturedAs(TABLE_SCAN)));

        private PickTableLayoutForPredicate(Metadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        private static boolean shouldRewriteTableLayout(TableScanNode source) {
            return !source.getLayout().isPresent() || source.getOriginalConstraint() == BooleanLiteral.TRUE_LITERAL;
        }

        @Override
        public Pattern<FilterNode> getPattern() {
            return PATTERN;
        }

        @Override
        public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
            TableLayoutRewriter tableLayoutRewriter = new TableLayoutRewriter(this.metadata, context.getSession(), context.getSymbolAllocator(), context.getIdAllocator());
            PlanNode rewrittenTableScan = tableLayoutRewriter.planTableScan((TableScanNode)captures.get(TABLE_SCAN), filterNode.getPredicate());
            if (rewrittenTableScan instanceof TableScanNode || rewrittenTableScan instanceof ValuesNode || ((FilterNode)rewrittenTableScan).getPredicate() != filterNode.getPredicate()) {
                return Rule.Result.ofPlanNode(rewrittenTableScan);
            }
            return Rule.Result.empty();
        }
    }
}

