/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.TopNNode;

public class MergeLimitWithTopN
implements Rule<LimitNode> {
    private static final Capture<TopNNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.topN().capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        TopNNode child = (TopNNode)captures.get(CHILD);
        return Rule.Result.ofPlanNode(new TopNNode(parent.getId(), child.getSource(), Math.min(parent.getCount(), child.getCount()), child.getOrderBy(), child.getOrderings(), parent.isPartial() ? TopNNode.Step.PARTIAL : TopNNode.Step.SINGLE));
    }
}

