/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.ExpressionSymbolInliner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolsExtractor;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.util.AstUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InlineProjections
implements Rule<ProjectNode> {
    private static final Capture<ProjectNode> CHILD = Capture.newCapture();
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().with(Patterns.source().matching(Patterns.project().capturedAs(CHILD)));

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ProjectNode parent, Captures captures, Rule.Context context) {
        ProjectNode child = (ProjectNode)captures.get(CHILD);
        Sets.SetView<Symbol> targets = this.extractInliningTargets(parent, child);
        if (targets.isEmpty()) {
            return Rule.Result.empty();
        }
        Assignments assignments = child.getAssignments().filter((Predicate<Symbol>)((Predicate)arg_0 -> targets.contains(arg_0)));
        Map<Symbol, Expression> parentAssignments = parent.getAssignments().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.inlineReferences((Expression)entry.getValue(), assignments)));
        Set inputs = child.getAssignments().entrySet().stream().filter(entry -> targets.contains(entry.getKey())).map(Map.Entry::getValue).flatMap(entry -> SymbolsExtractor.extractAll(entry).stream()).collect(Collectors.toSet());
        Assignments.Builder childAssignments = Assignments.builder();
        for (Map.Entry<Symbol, Expression> assignment : child.getAssignments().entrySet()) {
            if (targets.contains((Object)assignment.getKey())) continue;
            childAssignments.put(assignment);
        }
        for (Symbol input : inputs) {
            childAssignments.putIdentity(input);
        }
        return Rule.Result.ofPlanNode(new ProjectNode(parent.getId(), new ProjectNode(child.getId(), child.getSource(), childAssignments.build()), Assignments.copyOf(parentAssignments)));
    }

    private Expression inlineReferences(Expression expression, Assignments assignments) {
        Function<Symbol, Expression> mapping = symbol -> {
            Expression result = assignments.get((Symbol)symbol);
            if (result != null) {
                return result;
            }
            return symbol.toSymbolReference();
        };
        return new ExpressionSymbolInliner(mapping).rewrite(expression);
    }

    private Sets.SetView<Symbol> extractInliningTargets(ProjectNode parent, ProjectNode child) {
        ImmutableSet childOutputSet = ImmutableSet.copyOf(child.getOutputSymbols());
        Map dependencies = parent.getAssignments().getExpressions().stream().flatMap(expression -> SymbolsExtractor.extractAll(expression).stream()).filter(((Set)childOutputSet)::contains).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Set constants = dependencies.keySet().stream().filter(input -> child.getAssignments().get((Symbol)input) instanceof Literal).collect(Collectors.toSet());
        Set tryArguments = parent.getAssignments().getExpressions().stream().flatMap(expression -> this.extractTryArguments((Expression)expression).stream()).collect(Collectors.toSet());
        Set singletons = dependencies.entrySet().stream().filter(entry -> (Long)entry.getValue() == 1L).filter(entry -> !tryArguments.contains(entry.getKey())).filter(entry -> !child.getAssignments().isIdentity((Symbol)entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toSet());
        return Sets.union(singletons, constants);
    }

    private Set<Symbol> extractTryArguments(Expression expression) {
        return AstUtils.preOrder((Node)expression).filter(TryExpression.class::isInstance).map(TryExpression.class::cast).flatMap(tryExpression -> SymbolsExtractor.extractAll((Expression)tryExpression).stream()).collect(Collectors.toSet());
    }
}

