/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.optimizations.joins.JoinGraph;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;

public class EliminateCrossJoins
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join();

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isJoinReorderingEnabled(session);
    }

    @Override
    public Rule.Result apply(JoinNode node, Captures captures, Rule.Context context) {
        JoinGraph joinGraph = JoinGraph.buildShallowFrom(node, context.getLookup());
        if (joinGraph.size() < 3) {
            return Rule.Result.empty();
        }
        List<Integer> joinOrder = EliminateCrossJoins.getJoinOrder(joinGraph);
        if (EliminateCrossJoins.isOriginalOrder(joinOrder)) {
            return Rule.Result.empty();
        }
        PlanNode replacement = EliminateCrossJoins.buildJoinTree(node.getOutputSymbols(), joinGraph, joinOrder, context.getIdAllocator());
        return Rule.Result.ofPlanNode(replacement);
    }

    public static boolean isOriginalOrder(List<Integer> joinOrder) {
        for (int i = 0; i < joinOrder.size(); ++i) {
            if (joinOrder.get(i) == i) continue;
            return false;
        }
        return true;
    }

    public static List<Integer> getJoinOrder(JoinGraph graph) {
        ImmutableList.Builder joinOrder = ImmutableList.builder();
        HashMap<PlanNodeId, Integer> priorities = new HashMap<PlanNodeId, Integer>();
        for (int i = 0; i < graph.size(); ++i) {
            priorities.put(graph.getNode(i).getId(), i);
        }
        PriorityQueue<PlanNode> nodesToVisit = new PriorityQueue<PlanNode>(graph.size(), Comparator.comparing(node -> (Integer)priorities.get(node.getId())));
        HashSet<PlanNode> visited = new HashSet<PlanNode>();
        nodesToVisit.add(graph.getNode(0));
        while (!nodesToVisit.isEmpty()) {
            Optional<PlanNode> firstNotVisitedNode;
            PlanNode node2 = nodesToVisit.poll();
            if (!visited.contains(node2)) {
                visited.add(node2);
                joinOrder.add((Object)node2);
                for (JoinGraph.Edge edge : graph.getEdges(node2)) {
                    nodesToVisit.add(edge.getTargetNode());
                }
            }
            if (!nodesToVisit.isEmpty() || visited.size() >= graph.size() || !(firstNotVisitedNode = graph.getNodes().stream().filter(graphNode -> !visited.contains(graphNode)).findFirst()).isPresent()) continue;
            nodesToVisit.add(firstNotVisitedNode.get());
        }
        Preconditions.checkState((visited.size() == graph.size() ? 1 : 0) != 0);
        return (List)joinOrder.build().stream().map(node -> (Integer)priorities.get(node.getId())).collect(ImmutableList.toImmutableList());
    }

    public static PlanNode buildJoinTree(List<Symbol> expectedOutputSymbols, JoinGraph graph, List<Integer> joinOrder, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(expectedOutputSymbols, "expectedOutputSymbols is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(graph, "graph is null");
        joinOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(joinOrder, "joinOrder is null"));
        Preconditions.checkArgument((joinOrder.size() >= 2 ? 1 : 0) != 0);
        PlanNode result = graph.getNode((Integer)joinOrder.get(0));
        HashSet<PlanNodeId> alreadyJoinedNodes = new HashSet<PlanNodeId>();
        alreadyJoinedNodes.add(result.getId());
        for (int i = 1; i < joinOrder.size(); ++i) {
            PlanNode rightNode = graph.getNode((Integer)joinOrder.get(i));
            alreadyJoinedNodes.add(rightNode.getId());
            ImmutableList.Builder criteria = ImmutableList.builder();
            for (JoinGraph.Edge edge : graph.getEdges(rightNode)) {
                PlanNode targetNode = edge.getTargetNode();
                if (!alreadyJoinedNodes.contains(targetNode.getId())) continue;
                criteria.add((Object)new JoinNode.EquiJoinClause(edge.getTargetSymbol(), edge.getSourceSymbol()));
            }
            result = new JoinNode(idAllocator.getNextId(), JoinNode.Type.INNER, result, rightNode, (List<JoinNode.EquiJoinClause>)criteria.build(), (List<Symbol>)ImmutableList.builder().addAll(result.getOutputSymbols()).addAll(rightNode.getOutputSymbols()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        }
        List<Expression> filters = graph.getFilters();
        for (Expression filter : filters) {
            result = new FilterNode(idAllocator.getNextId(), result, filter);
        }
        if (graph.getAssignments().isPresent()) {
            result = new ProjectNode(idAllocator.getNextId(), result, Assignments.copyOf(graph.getAssignments().get()));
        }
        return Util.restrictOutputs(idAllocator, result, (Set<Symbol>)ImmutableSet.copyOf(expectedOutputSymbols)).orElse(result);
    }
}

