/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.matching.Match;
import com.facebook.presto.matching.Matcher;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.StatsRecorder;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Memo;
import com.facebook.presto.sql.planner.iterative.PlanNodeMatcher;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.RuleIndex;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class IterativeOptimizer
implements PlanOptimizer {
    private final List<PlanOptimizer> legacyRules;
    private final RuleIndex ruleIndex;
    private final StatsRecorder stats;

    public IterativeOptimizer(StatsRecorder stats, Set<Rule<?>> rules) {
        this(stats, (List<PlanOptimizer>)ImmutableList.of(), rules);
    }

    public IterativeOptimizer(StatsRecorder stats, List<PlanOptimizer> legacyRules, Set<Rule<?>> newRules) {
        this.legacyRules = ImmutableList.copyOf(legacyRules);
        this.ruleIndex = RuleIndex.builder().register(newRules).build();
        this.stats = stats;
        stats.registerAll(newRules);
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        if (!SystemSessionProperties.isNewOptimizerEnabled(session) && !this.legacyRules.isEmpty()) {
            for (PlanOptimizer optimizer : this.legacyRules) {
                plan = optimizer.optimize(plan, session, symbolAllocator.getTypes(), symbolAllocator, idAllocator);
            }
            return plan;
        }
        Memo memo = new Memo(idAllocator, plan);
        Lookup lookup = Lookup.from(planNode -> Stream.of(memo.resolve((GroupReference)planNode)));
        PlanNodeMatcher matcher = new PlanNodeMatcher(lookup);
        Duration timeout = SystemSessionProperties.getOptimizerTimeout(session);
        Context context = new Context(memo, lookup, idAllocator, symbolAllocator, System.nanoTime(), timeout.toMillis(), session);
        this.exploreGroup(memo.getRootGroup(), context, (Matcher)matcher);
        return memo.extract();
    }

    private boolean exploreGroup(int group, Context context, Matcher matcher) {
        boolean progress = this.exploreNode(group, context, matcher);
        while (this.exploreChildren(group, context, matcher)) {
            progress = true;
            if (this.exploreNode(group, context, matcher)) continue;
            break;
        }
        return progress;
    }

    private boolean exploreNode(int group, Context context, Matcher matcher) {
        PlanNode node = context.getMemo().getNode(group);
        boolean done = false;
        boolean progress = false;
        while (!done) {
            if (this.isTimeLimitExhausted(context)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.OPTIMIZER_TIMEOUT, String.format("The optimizer exhausted the time limit of %d ms", context.getTimeoutInMilliseconds()));
            }
            done = true;
            Iterator possiblyMatchingRules = this.ruleIndex.getCandidates(node).iterator();
            while (possiblyMatchingRules.hasNext()) {
                Rule.Result result;
                Rule rule = (Rule)possiblyMatchingRules.next();
                if (!rule.isEnabled(context.session) || !(result = this.transform(node, rule, matcher, context)).getTransformedPlan().isPresent()) continue;
                node = context.getMemo().replace(group, result.getTransformedPlan().get(), rule.getClass().getName());
                done = false;
                progress = true;
            }
        }
        return progress;
    }

    private <T> Rule.Result transform(PlanNode node, Rule<T> rule, Matcher matcher, Context context) {
        long duration;
        Rule.Result result;
        Match match = matcher.match(rule.getPattern(), (Object)node);
        if (match.isEmpty()) {
            return Rule.Result.empty();
        }
        try {
            long start = System.nanoTime();
            result = rule.apply(match.value(), match.captures(), context);
            duration = System.nanoTime() - start;
        }
        catch (RuntimeException e) {
            this.stats.recordFailure(rule);
            throw e;
        }
        this.stats.record(rule, duration, !result.isEmpty());
        return result;
    }

    private boolean isTimeLimitExhausted(Context context) {
        return (System.nanoTime() - context.getStartTimeInNanos()) / 1000000L >= context.getTimeoutInMilliseconds();
    }

    private boolean exploreChildren(int group, Context context, Matcher matcher) {
        boolean progress = false;
        PlanNode expression = context.getMemo().getNode(group);
        for (PlanNode child : expression.getSources()) {
            Preconditions.checkState((boolean)(child instanceof GroupReference), (Object)("Expected child to be a group reference. Found: " + child.getClass().getName()));
            if (!this.exploreGroup(((GroupReference)child).getGroupId(), context, matcher)) continue;
            progress = true;
        }
        return progress;
    }

    private static class Context
    implements Rule.Context {
        private final Memo memo;
        private final Lookup lookup;
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;
        private final long startTimeInNanos;
        private final long timeoutInMilliseconds;
        private final Session session;

        public Context(Memo memo, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, long startTimeInNanos, long timeoutInMilliseconds, Session session) {
            Preconditions.checkArgument((timeoutInMilliseconds >= 0L ? 1 : 0) != 0, (Object)"Timeout has to be a non-negative number [milliseconds]");
            this.memo = memo;
            this.lookup = lookup;
            this.idAllocator = idAllocator;
            this.symbolAllocator = symbolAllocator;
            this.startTimeInNanos = startTimeInNanos;
            this.timeoutInMilliseconds = timeoutInMilliseconds;
            this.session = session;
        }

        public Memo getMemo() {
            return this.memo;
        }

        @Override
        public Lookup getLookup() {
            return this.lookup;
        }

        @Override
        public PlanNodeIdAllocator getIdAllocator() {
            return this.idAllocator;
        }

        @Override
        public SymbolAllocator getSymbolAllocator() {
            return this.symbolAllocator;
        }

        public long getStartTimeInNanos() {
            return this.startTimeInNanos;
        }

        public long getTimeoutInMilliseconds() {
            return this.timeoutInMilliseconds;
        }

        @Override
        public Session getSession() {
            return this.session;
        }
    }
}

