/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.RuleStats;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.ObjectNames;

public class StatsRecorder {
    private final Map<Class<?>, RuleStats> stats = new HashMap();

    public void registerAll(Collection<Rule<?>> rules) {
        for (Rule<?> rule : rules) {
            this.stats.put(rule.getClass(), new RuleStats());
        }
    }

    public void record(Rule<?> rule, long nanos, boolean match) {
        this.stats.get(rule.getClass()).record(nanos, match);
    }

    public void recordFailure(Rule<?> rule) {
        this.stats.get(rule.getClass()).recordFailure();
    }

    void export(MBeanExporter exporter) {
        for (Map.Entry<Class<?>, RuleStats> entry : this.stats.entrySet()) {
            String name = ObjectNames.builder(IterativeOptimizer.class).withProperty("rule", entry.getKey().getSimpleName()).build();
            exporter.export(name, (Object)entry.getValue());
        }
    }

    void unexport(MBeanExporter exporter) {
        for (Class<?> rule : this.stats.keySet()) {
            String name = ObjectNames.builder(IterativeOptimizer.class).withProperty("rule", rule.getSimpleName()).build();
            exporter.unexport(name);
        }
    }
}

