/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.execution.QueryPerformanceFetcher;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.AggregationOperator;
import com.facebook.presto.operator.AssignUniqueIdOperator;
import com.facebook.presto.operator.DeleteOperator;
import com.facebook.presto.operator.DistinctLimitOperator;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.EnforceSingleRowOperator;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.operator.ExchangeOperator;
import com.facebook.presto.operator.ExplainAnalyzeOperator;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.GroupIdOperator;
import com.facebook.presto.operator.HashAggregationOperator;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.HashSemiJoinOperator;
import com.facebook.presto.operator.JoinOperatorFactory;
import com.facebook.presto.operator.LimitOperator;
import com.facebook.presto.operator.LocalPlannerAware;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.MarkDistinctOperator;
import com.facebook.presto.operator.MetadataDeleteOperator;
import com.facebook.presto.operator.NestedLoopBuildOperator;
import com.facebook.presto.operator.NestedLoopJoinOperator;
import com.facebook.presto.operator.NestedLoopJoinPagesSupplier;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OrderByOperator;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.operator.PartitionedOutputOperator;
import com.facebook.presto.operator.RowNumberOperator;
import com.facebook.presto.operator.ScanFilterAndProjectOperator;
import com.facebook.presto.operator.SetBuilderOperator;
import com.facebook.presto.operator.TableFinishOperator;
import com.facebook.presto.operator.TableScanOperator;
import com.facebook.presto.operator.TableWriterOperator;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskOutputOperator;
import com.facebook.presto.operator.TopNOperator;
import com.facebook.presto.operator.TopNRowNumberOperator;
import com.facebook.presto.operator.UnnestOperator;
import com.facebook.presto.operator.ValuesOperator;
import com.facebook.presto.operator.WindowFunctionDefinition;
import com.facebook.presto.operator.WindowOperator;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.exchange.LocalExchange;
import com.facebook.presto.operator.exchange.LocalExchangeSinkOperator;
import com.facebook.presto.operator.exchange.LocalExchangeSourceOperator;
import com.facebook.presto.operator.exchange.PageChannelSelector;
import com.facebook.presto.operator.index.DynamicTupleFilterFactory;
import com.facebook.presto.operator.index.FieldSetFilteringRecordSet;
import com.facebook.presto.operator.index.IndexBuildDriverFactoryProvider;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.operator.index.IndexLookupSourceFactory;
import com.facebook.presto.operator.index.IndexSourceOperator;
import com.facebook.presto.operator.project.CursorProcessor;
import com.facebook.presto.operator.project.InterpretedCursorProcessor;
import com.facebook.presto.operator.project.InterpretedPageFilter;
import com.facebook.presto.operator.project.InterpretedPageProjection;
import com.facebook.presto.operator.project.PageFilter;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.window.FrameInfo;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorIndex;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.spiller.PartitioningSpillerFactory;
import com.facebook.presto.spiller.SingleStreamSpillerFactory;
import com.facebook.presto.spiller.SpillerFactory;
import com.facebook.presto.split.MappedRecordSet;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.CompilerConfig;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.SortExpressionContext;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolToInputRewriter;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.optimizations.IndexJoinOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.NodeRef;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.primitives.Ints;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;

public class LocalExecutionPlanner {
    private static final Logger log = Logger.get(LocalExecutionPlanner.class);
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final CostCalculator costCalculator;
    private final Optional<QueryPerformanceFetcher> queryPerformanceFetcher;
    private final PageSourceProvider pageSourceProvider;
    private final IndexManager indexManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final PageSinkManager pageSinkManager;
    private final ExchangeClientSupplier exchangeClientSupplier;
    private final ExpressionCompiler expressionCompiler;
    private final PageFunctionCompiler pageFunctionCompiler;
    private final JoinFilterFunctionCompiler joinFilterFunctionCompiler;
    private final boolean interpreterEnabled;
    private final DataSize maxIndexMemorySize;
    private final IndexJoinLookupStats indexJoinLookupStats;
    private final DataSize maxPartialAggregationMemorySize;
    private final DataSize maxPagePartitioningBufferSize;
    private final SpillerFactory spillerFactory;
    private final SingleStreamSpillerFactory singleStreamSpillerFactory;
    private final PartitioningSpillerFactory partitioningSpillerFactory;
    private final BlockEncodingSerde blockEncodingSerde;
    private final PagesIndex.Factory pagesIndexFactory;
    private final JoinCompiler joinCompiler;
    private final LookupJoinOperators lookupJoinOperators;

    @Inject
    public LocalExecutionPlanner(Metadata metadata, SqlParser sqlParser, CostCalculator costCalculator, Optional<QueryPerformanceFetcher> queryPerformanceFetcher, PageSourceProvider pageSourceProvider, IndexManager indexManager, NodePartitioningManager nodePartitioningManager, PageSinkManager pageSinkManager, ExchangeClientSupplier exchangeClientSupplier, ExpressionCompiler expressionCompiler, PageFunctionCompiler pageFunctionCompiler, JoinFilterFunctionCompiler joinFilterFunctionCompiler, IndexJoinLookupStats indexJoinLookupStats, CompilerConfig compilerConfig, TaskManagerConfig taskManagerConfig, SpillerFactory spillerFactory, SingleStreamSpillerFactory singleStreamSpillerFactory, PartitioningSpillerFactory partitioningSpillerFactory, BlockEncodingSerde blockEncodingSerde, PagesIndex.Factory pagesIndexFactory, JoinCompiler joinCompiler, LookupJoinOperators lookupJoinOperators) {
        Objects.requireNonNull(compilerConfig, "compilerConfig is null");
        this.queryPerformanceFetcher = Objects.requireNonNull(queryPerformanceFetcher, "queryPerformanceFetcher is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.indexManager = Objects.requireNonNull(indexManager, "indexManager is null");
        this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
        this.exchangeClientSupplier = exchangeClientSupplier;
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.pageSinkManager = Objects.requireNonNull(pageSinkManager, "pageSinkManager is null");
        this.expressionCompiler = Objects.requireNonNull(expressionCompiler, "compiler is null");
        this.pageFunctionCompiler = Objects.requireNonNull(pageFunctionCompiler, "pageFunctionCompiler is null");
        this.joinFilterFunctionCompiler = Objects.requireNonNull(joinFilterFunctionCompiler, "compiler is null");
        this.indexJoinLookupStats = Objects.requireNonNull(indexJoinLookupStats, "indexJoinLookupStats is null");
        this.maxIndexMemorySize = Objects.requireNonNull(taskManagerConfig, "taskManagerConfig is null").getMaxIndexMemoryUsage();
        this.spillerFactory = Objects.requireNonNull(spillerFactory, "spillerFactory is null");
        this.singleStreamSpillerFactory = Objects.requireNonNull(singleStreamSpillerFactory, "singleStreamSpillerFactory is null");
        this.partitioningSpillerFactory = Objects.requireNonNull(partitioningSpillerFactory, "partitioningSpillerFactory is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.maxPartialAggregationMemorySize = taskManagerConfig.getMaxPartialAggregationMemoryUsage();
        this.maxPagePartitioningBufferSize = taskManagerConfig.getMaxPagePartitioningBufferSize();
        this.pagesIndexFactory = Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
        this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        this.lookupJoinOperators = Objects.requireNonNull(lookupJoinOperators, "lookupJoinOperators is null");
        this.interpreterEnabled = compilerConfig.isInterpreterEnabled();
    }

    public LocalExecutionPlan plan(TaskContext taskContext, PlanNode plan, Map<Symbol, Type> types, PartitioningScheme partitioningScheme, OutputBuffer outputBuffer) {
        Object partitionChannelTypes;
        Object partitionConstants;
        Object partitionChannels;
        List<Symbol> outputLayout = partitioningScheme.getOutputLayout();
        if (partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION)) {
            return this.plan(taskContext, plan, outputLayout, types, new TaskOutputOperator.TaskOutputFactory(outputBuffer));
        }
        if (partitioningScheme.getHashColumn().isPresent()) {
            partitionChannels = ImmutableList.of((Object)outputLayout.indexOf(partitioningScheme.getHashColumn().get()));
            partitionConstants = ImmutableList.of(Optional.empty());
            partitionChannelTypes = ImmutableList.of((Object)BigintType.BIGINT);
        } else {
            partitionChannels = (List)partitioningScheme.getPartitioning().getArguments().stream().map(Partitioning.ArgumentBinding::getColumn).map(outputLayout::indexOf).collect(ImmutableList.toImmutableList());
            partitionConstants = (List)partitioningScheme.getPartitioning().getArguments().stream().map(argument -> {
                if (argument.isConstant()) {
                    return Optional.of(argument.getConstant());
                }
                return Optional.empty();
            }).collect(ImmutableList.toImmutableList());
            partitionChannelTypes = (List)partitioningScheme.getPartitioning().getArguments().stream().map(argument -> {
                if (argument.isConstant()) {
                    return argument.getConstant().getType();
                }
                return (Type)types.get(argument.getColumn());
            }).collect(ImmutableList.toImmutableList());
        }
        PartitionFunction partitionFunction = this.nodePartitioningManager.getPartitionFunction(taskContext.getSession(), partitioningScheme, (List<Type>)partitionChannelTypes);
        OptionalInt nullChannel = OptionalInt.empty();
        Set<Symbol> partitioningColumns = partitioningScheme.getPartitioning().getColumns();
        Preconditions.checkArgument((!partitioningScheme.isReplicateNullsAndAny() || partitioningColumns.size() <= 1 ? 1 : 0) != 0);
        if (partitioningScheme.isReplicateNullsAndAny() && partitioningColumns.size() == 1) {
            nullChannel = OptionalInt.of(outputLayout.indexOf(Iterables.getOnlyElement(partitioningColumns)));
        }
        return this.plan(taskContext, plan, outputLayout, types, new PartitionedOutputOperator.PartitionedOutputFactory(partitionFunction, (List<Integer>)partitionChannels, (List<Optional<NullableValue>>)partitionConstants, partitioningScheme.isReplicateNullsAndAny(), nullChannel, outputBuffer, this.maxPagePartitioningBufferSize));
    }

    public LocalExecutionPlan plan(TaskContext taskContext, PlanNode plan, List<Symbol> outputLayout, Map<Symbol, Type> types, OutputFactory outputOperatorFactory) {
        Session session = taskContext.getSession();
        LocalExecutionPlanContext context = new LocalExecutionPlanContext(taskContext, types);
        PhysicalOperation physicalOperation = plan.accept(new Visitor(session), context);
        Function<Page, Page> pagePreprocessor = LocalExecutionPlanner.enforceLayoutProcessor(outputLayout, physicalOperation.getLayout());
        List outputTypes = (List)outputLayout.stream().map(types::get).collect(ImmutableList.toImmutableList());
        context.addDriverFactory(context.isInputDriver(), true, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)physicalOperation.getOperatorFactories()).add((Object)outputOperatorFactory.createOutputOperator(context.getNextOperatorId(), plan.getId(), outputTypes, pagePreprocessor, new PagesSerdeFactory(this.blockEncodingSerde, SystemSessionProperties.isExchangeCompressionEnabled(session)))).build(), context.getDriverInstanceCount());
        LocalExecutionPlanner.addLookupOuterDrivers(context);
        context.getDriverFactories().stream().map(DriverFactory::getOperatorFactories).flatMap(Collection::stream).filter(LocalPlannerAware.class::isInstance).map(LocalPlannerAware.class::cast).forEach(LocalPlannerAware::localPlannerComplete);
        return new LocalExecutionPlan(context.getDriverFactories());
    }

    private static void addLookupOuterDrivers(LocalExecutionPlanContext context) {
        for (DriverFactory factory : context.getDriverFactories()) {
            List<OperatorFactory> operatorFactories = factory.getOperatorFactories();
            for (int i = 0; i < operatorFactories.size(); ++i) {
                JoinOperatorFactory lookupJoin;
                Optional<OperatorFactory> outerOperatorFactory;
                OperatorFactory operatorFactory = operatorFactories.get(i);
                if (!(operatorFactory instanceof JoinOperatorFactory) || !(outerOperatorFactory = (lookupJoin = (JoinOperatorFactory)operatorFactory).createOuterOperatorFactory()).isPresent()) continue;
                ImmutableList.Builder newOperators = ImmutableList.builder();
                newOperators.add((Object)outerOperatorFactory.get());
                operatorFactories.subList(i + 1, operatorFactories.size()).stream().map(OperatorFactory::duplicate).forEach(arg_0 -> ((ImmutableList.Builder)newOperators).add(arg_0));
                context.addDriverFactory(false, factory.isOutputDriver(), (List<OperatorFactory>)newOperators.build(), OptionalInt.of(1));
            }
        }
    }

    private static List<Type> getTypes(List<Expression> expressions, Map<NodeRef<Expression>, Type> expressionTypes) {
        return (List)expressions.stream().map(NodeRef::of).map(expressionTypes::get).collect(ImmutableList.toImmutableList());
    }

    private static TableFinishOperator.TableFinisher createTableFinisher(Session session, TableFinishNode node, Metadata metadata) {
        TableWriterNode.WriterTarget target = node.getTarget();
        return fragments -> {
            if (target instanceof TableWriterNode.CreateHandle) {
                return metadata.finishCreateTable(session, ((TableWriterNode.CreateHandle)target).getHandle(), fragments);
            }
            if (target instanceof TableWriterNode.InsertHandle) {
                return metadata.finishInsert(session, ((TableWriterNode.InsertHandle)target).getHandle(), fragments);
            }
            if (target instanceof TableWriterNode.DeleteHandle) {
                metadata.finishDelete(session, ((TableWriterNode.DeleteHandle)target).getHandle(), fragments);
                return Optional.empty();
            }
            throw new AssertionError((Object)("Unhandled target type: " + target.getClass().getName()));
        };
    }

    private static Function<Page, Page> enforceLayoutProcessor(List<Symbol> expectedLayout, Map<Symbol, Integer> inputLayout) {
        int[] channels = expectedLayout.stream().mapToInt(inputLayout::get).toArray();
        if (Arrays.equals(channels, IntStream.range(0, inputLayout.size()).toArray())) {
            return Function.identity();
        }
        return new PageChannelSelector(channels);
    }

    private static List<Integer> getChannelsForSymbols(List<Symbol> symbols, Map<Symbol, Integer> layout) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Symbol symbol : symbols) {
            builder.add((Object)layout.get(symbol));
        }
        return builder.build();
    }

    private static Function<Symbol, Integer> channelGetter(PhysicalOperation source) {
        return input -> {
            Preconditions.checkArgument((boolean)source.getLayout().containsKey(input));
            return source.getLayout().get(input);
        };
    }

    private static class PhysicalOperation {
        private final List<OperatorFactory> operatorFactories;
        private final Map<Symbol, Integer> layout;
        private final List<Type> types;

        public PhysicalOperation(OperatorFactory operatorFactory, Map<Symbol, Integer> layout) {
            Objects.requireNonNull(operatorFactory, "operatorFactory is null");
            Objects.requireNonNull(layout, "layout is null");
            this.operatorFactories = ImmutableList.of((Object)operatorFactory);
            this.layout = ImmutableMap.copyOf(layout);
            this.types = operatorFactory.getTypes();
        }

        public PhysicalOperation(OperatorFactory operatorFactory, Map<Symbol, Integer> layout, PhysicalOperation source) {
            Objects.requireNonNull(operatorFactory, "operatorFactory is null");
            Objects.requireNonNull(layout, "layout is null");
            Objects.requireNonNull(source, "source is null");
            this.operatorFactories = ImmutableList.builder().addAll(source.getOperatorFactories()).add((Object)operatorFactory).build();
            this.layout = ImmutableMap.copyOf(layout);
            this.types = operatorFactory.getTypes();
        }

        public int symbolToChannel(Symbol input) {
            Preconditions.checkArgument((boolean)this.layout.containsKey(input));
            return this.layout.get(input);
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public Map<Symbol, Integer> getLayout() {
            return this.layout;
        }

        private List<OperatorFactory> getOperatorFactories() {
            return this.operatorFactories;
        }
    }

    private class Visitor
    extends PlanVisitor<PhysicalOperation, LocalExecutionPlanContext> {
        private final Session session;

        private Visitor(Session session) {
            this.session = session;
        }

        @Override
        public PhysicalOperation visitRemoteSource(RemoteSourceNode node, LocalExecutionPlanContext context) {
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            if (!context.getDriverInstanceCount().isPresent()) {
                context.setDriverInstanceCount(SystemSessionProperties.getTaskConcurrency(this.session));
            }
            ExchangeOperator.ExchangeOperatorFactory operatorFactory = new ExchangeOperator.ExchangeOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.exchangeClientSupplier, new PagesSerdeFactory(LocalExecutionPlanner.this.blockEncodingSerde, SystemSessionProperties.isExchangeCompressionEnabled(this.session)), types);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitExplainAnalyze(ExplainAnalyzeNode node, LocalExecutionPlanContext context) {
            Preconditions.checkState((boolean)LocalExecutionPlanner.this.queryPerformanceFetcher.isPresent(), (Object)"ExplainAnalyze can only run on coordinator");
            PhysicalOperation source = node.getSource().accept(this, context);
            ExplainAnalyzeOperator.ExplainAnalyzeOperatorFactory operatorFactory = new ExplainAnalyzeOperator.ExplainAnalyzeOperatorFactory(context.getNextOperatorId(), node.getId(), (QueryPerformanceFetcher)LocalExecutionPlanner.this.queryPerformanceFetcher.get(), LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.costCalculator, node.isVerbose());
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), source);
        }

        @Override
        public PhysicalOperation visitOutput(OutputNode node, LocalExecutionPlanContext context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public PhysicalOperation visitRowNumber(RowNumberNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            List partitionChannels = LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout());
            List partitionTypes = (List)partitionChannels.stream().map(channel -> source.getTypes().get((int)channel)).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(source.getLayout());
            int channel2 = source.getTypes().size();
            outputMappings.put((Object)node.getRowNumberSymbol(), (Object)channel2);
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), partitionChannels, partitionTypes, node.getMaxRowCountPerPartition(), hashChannel, 10000, LocalExecutionPlanner.this.joinCompiler);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), source);
        }

        @Override
        public PhysicalOperation visitTopNRowNumber(TopNRowNumberNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            List partitionChannels = LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout());
            List partitionTypes = (List)partitionChannels.stream().map(channel -> source.getTypes().get((int)channel)).collect(ImmutableList.toImmutableList());
            List<Symbol> orderBySymbols = node.getOrderBy();
            List sortChannels = LocalExecutionPlanner.getChannelsForSymbols(orderBySymbols, source.getLayout());
            List sortOrder = (List)orderBySymbols.stream().map(symbol -> node.getOrderings().get(symbol)).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(source.getLayout());
            if (!node.isPartial() || !partitionChannels.isEmpty()) {
                int channel2 = source.getTypes().size();
                outputMappings.put((Object)node.getRowNumberSymbol(), (Object)channel2);
            }
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            TopNRowNumberOperator.TopNRowNumberOperatorFactory operatorFactory = new TopNRowNumberOperator.TopNRowNumberOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), partitionChannels, partitionTypes, sortChannels, sortOrder, node.getMaxRowCountPerPartition(), node.isPartial(), hashChannel, 1000, LocalExecutionPlanner.this.joinCompiler);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), source);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PhysicalOperation visitWindow(WindowNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            List<Symbol> orderBySymbols = node.getOrderBy();
            ImmutableList partitionChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout()));
            ImmutableList preGroupedChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols((List)ImmutableList.copyOf(node.getPrePartitionedInputs()), source.getLayout()));
            List sortChannels = LocalExecutionPlanner.getChannelsForSymbols(orderBySymbols, source.getLayout());
            List sortOrder = (List)orderBySymbols.stream().map(symbol -> node.getOrderings().get(symbol)).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableList.Builder windowFunctionsBuilder = ImmutableList.builder();
            ImmutableList.Builder windowFunctionOutputSymbolsBuilder = ImmutableList.builder();
            for (Map.Entry<Symbol, WindowNode.Function> entry : node.getWindowFunctions().entrySet()) {
                void var16_18;
                Optional<Integer> frameStartChannel = Optional.empty();
                Optional optional = Optional.empty();
                WindowNode.Frame frame = entry.getValue().getFrame();
                if (frame.getStartValue().isPresent()) {
                    frameStartChannel = Optional.of(source.getLayout().get(frame.getStartValue().get()));
                }
                if (frame.getEndValue().isPresent()) {
                    Optional<Integer> optional2 = Optional.of(source.getLayout().get(frame.getEndValue().get()));
                }
                FrameInfo frameInfo = new FrameInfo(frame.getType(), frame.getStartType(), frameStartChannel, frame.getEndType(), (Optional<Integer>)var16_18);
                FunctionCall functionCall = entry.getValue().getFunctionCall();
                Signature signature = entry.getValue().getSignature();
                ImmutableList.Builder arguments = ImmutableList.builder();
                for (Expression argument : functionCall.getArguments()) {
                    Symbol argumentSymbol = Symbol.from(argument);
                    arguments.add((Object)source.getLayout().get(argumentSymbol));
                }
                Symbol symbol2 = entry.getKey();
                WindowFunctionSupplier windowFunctionSupplier = LocalExecutionPlanner.this.metadata.getFunctionRegistry().getWindowFunctionImplementation(signature);
                Type type = LocalExecutionPlanner.this.metadata.getType(signature.getReturnType());
                windowFunctionsBuilder.add((Object)WindowFunctionDefinition.window(windowFunctionSupplier, type, frameInfo, (List<Integer>)arguments.build()));
                windowFunctionOutputSymbolsBuilder.add((Object)symbol2);
            }
            ImmutableList windowFunctionOutputSymbols = windowFunctionOutputSymbolsBuilder.build();
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            for (Symbol symbol2 : node.getSource().getOutputSymbols()) {
                outputMappings.put((Object)symbol2, (Object)source.getLayout().get(symbol2));
            }
            int channel = source.getTypes().size();
            for (Symbol symbol4 : windowFunctionOutputSymbols) {
                outputMappings.put((Object)symbol4, (Object)channel);
                ++channel;
            }
            WindowOperator.WindowOperatorFactory windowOperatorFactory = new WindowOperator.WindowOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), (List<WindowFunctionDefinition>)windowFunctionsBuilder.build(), (List<Integer>)partitionChannels, (List<Integer>)preGroupedChannels, sortChannels, sortOrder, node.getPreSortedOrderPrefix(), 10000, LocalExecutionPlanner.this.pagesIndexFactory);
            return new PhysicalOperation(windowOperatorFactory, (Map<Symbol, Integer>)outputMappings.build(), source);
        }

        @Override
        public PhysicalOperation visitTopN(TopNNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> orderBySymbols = node.getOrderBy();
            ArrayList<Integer> sortChannels = new ArrayList<Integer>();
            ArrayList<SortOrder> sortOrders = new ArrayList<SortOrder>();
            for (Symbol symbol : orderBySymbols) {
                sortChannels.add(source.getLayout().get(symbol));
                sortOrders.add(node.getOrderings().get(symbol));
            }
            TopNOperator.TopNOperatorFactory operator = new TopNOperator.TopNOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (int)node.getCount(), sortChannels, sortOrders);
            return new PhysicalOperation(operator, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitSort(SortNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> orderBySymbols = node.getOrderBy();
            List orderByChannels = LocalExecutionPlanner.getChannelsForSymbols(orderBySymbols, source.getLayout());
            ImmutableList.Builder sortOrder = ImmutableList.builder();
            for (Symbol symbol : orderBySymbols) {
                sortOrder.add((Object)node.getOrderings().get(symbol));
            }
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            OrderByOperator.OrderByOperatorFactory operator = new OrderByOperator.OrderByOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), 10000, orderByChannels, (List<SortOrder>)sortOrder.build(), LocalExecutionPlanner.this.pagesIndexFactory);
            return new PhysicalOperation(operator, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitLimit(LimitNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            LimitOperator.LimitOperatorFactory operatorFactory = new LimitOperator.LimitOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), node.getCount());
            return new PhysicalOperation(operatorFactory, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitDistinctLimit(DistinctLimitNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            List distinctChannels = LocalExecutionPlanner.getChannelsForSymbols(node.getDistinctSymbols(), source.getLayout());
            DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), distinctChannels, node.getLimit(), hashChannel, LocalExecutionPlanner.this.joinCompiler);
            return new PhysicalOperation(operatorFactory, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitGroupId(GroupIdNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            HashMap<Symbol, Integer> newLayout = new HashMap<Symbol, Integer>();
            ImmutableList.Builder outputTypes = ImmutableList.builder();
            int outputChannel = 0;
            for (Object output : node.getGroupingSets().stream().flatMap(Collection::stream).collect(Collectors.toSet())) {
                newLayout.put((Symbol)output, outputChannel++);
                outputTypes.add((Object)source.getTypes().get(source.getLayout().get(node.getGroupingSetMappings().get(output))));
            }
            HashMap<Symbol, Integer> argumentMappings = new HashMap<Symbol, Integer>();
            for (Symbol symbol : node.getArgumentMappings().keySet()) {
                int n = source.getLayout().get(node.getArgumentMappings().get(symbol));
                newLayout.put(symbol, outputChannel++);
                outputTypes.add((Object)source.getTypes().get(n));
                argumentMappings.put(symbol, n);
            }
            ImmutableList.Builder mappings = ImmutableList.builder();
            for (List<Symbol> list : node.getGroupingSets()) {
                ImmutableMap.Builder setMapping = ImmutableMap.builder();
                for (Symbol output : list) {
                    setMapping.put(newLayout.get(output), (Object)source.getLayout().get(node.getGroupingSetMappings().get(output)));
                }
                for (Symbol output : argumentMappings.keySet()) {
                    setMapping.put(newLayout.get(output), argumentMappings.get(output));
                }
                mappings.add((Object)setMapping.build());
            }
            newLayout.put(node.getGroupIdSymbol(), outputChannel);
            outputTypes.add((Object)BigintType.BIGINT);
            GroupIdOperator.GroupIdOperatorFactory groupIdOperatorFactory = new GroupIdOperator.GroupIdOperatorFactory(context.getNextOperatorId(), node.getId(), (List<? extends Type>)outputTypes.build(), (List<Map<Integer, Integer>>)mappings.build());
            return new PhysicalOperation(groupIdOperatorFactory, newLayout, source);
        }

        @Override
        public PhysicalOperation visitAggregation(AggregationNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            if (node.getGroupingKeys().isEmpty()) {
                return this.planGlobalAggregation(context.getNextOperatorId(), node, source);
            }
            boolean spillEnabled = SystemSessionProperties.isSpillEnabled(context.getSession());
            DataSize unspillMemoryLimit = SystemSessionProperties.getAggregationOperatorUnspillMemoryLimit(context.getSession());
            return this.planGroupByAggregation(node, source, context.getNextOperatorId(), spillEnabled, unspillMemoryLimit);
        }

        @Override
        public PhysicalOperation visitMarkDistinct(MarkDistinctNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List channels = LocalExecutionPlanner.getChannelsForSymbols(node.getDistinctSymbols(), source.getLayout());
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            MarkDistinctOperator.MarkDistinctOperatorFactory operator = new MarkDistinctOperator.MarkDistinctOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), channels, hashChannel, LocalExecutionPlanner.this.joinCompiler);
            return new PhysicalOperation(operator, (Map<Symbol, Integer>)this.makeLayout(node), source);
        }

        @Override
        public PhysicalOperation visitSample(SampleNode node, LocalExecutionPlanContext context) {
            if (node.getSampleType() == SampleNode.Type.SYSTEM) {
                return node.getSource().accept(this, context);
            }
            throw new UnsupportedOperationException("not yet implemented: " + node);
        }

        @Override
        public PhysicalOperation visitFilter(FilterNode node, LocalExecutionPlanContext context) {
            PlanNode sourceNode = node.getSource();
            Expression filterExpression = node.getPredicate();
            List<Symbol> outputSymbols = node.getOutputSymbols();
            return this.visitScanFilterAndProject(context, node.getId(), sourceNode, Optional.of(filterExpression), Assignments.identity(outputSymbols), outputSymbols);
        }

        @Override
        public PhysicalOperation visitProject(ProjectNode node, LocalExecutionPlanContext context) {
            PlanNode sourceNode;
            Optional<Expression> filterExpression = Optional.empty();
            if (node.getSource() instanceof FilterNode) {
                FilterNode filterNode = (FilterNode)node.getSource();
                sourceNode = filterNode.getSource();
                filterExpression = Optional.of(filterNode.getPredicate());
            } else {
                sourceNode = node.getSource();
            }
            List<Symbol> outputSymbols = node.getOutputSymbols();
            return this.visitScanFilterAndProject(context, node.getId(), sourceNode, filterExpression, node.getAssignments(), outputSymbols);
        }

        private PhysicalOperation visitScanFilterAndProject(LocalExecutionPlanContext context, PlanNodeId planNodeId, PlanNode sourceNode, Optional<Expression> filterExpression, Assignments assignments, List<Symbol> outputSymbols) {
            Map<Object, Object> sourceTypes;
            LinkedHashMap<Symbol, Integer> sourceLayout;
            ArrayList<ColumnHandle> columns = null;
            PhysicalOperation source = null;
            if (sourceNode instanceof TableScanNode) {
                TableScanNode tableScanNode = (TableScanNode)sourceNode;
                sourceLayout = new LinkedHashMap();
                sourceTypes = new LinkedHashMap();
                columns = new ArrayList<ColumnHandle>();
                int channel = 0;
                for (Symbol symbol : tableScanNode.getOutputSymbols()) {
                    columns.add(tableScanNode.getAssignments().get(symbol));
                    Integer input = channel;
                    sourceLayout.put(symbol, input);
                    Type type = Objects.requireNonNull(context.getTypes().get(symbol), String.format("No type for symbol %s", symbol));
                    sourceTypes.put(input, type);
                    ++channel;
                }
            } else {
                source = sourceNode.accept(this, context);
                sourceLayout = source.getLayout();
                sourceTypes = this.getInputTypes(source.getLayout(), source.getTypes());
            }
            ImmutableMap.Builder outputMappingsBuilder = ImmutableMap.builder();
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                outputMappingsBuilder.put((Object)symbol, (Object)i);
            }
            ImmutableMap outputMappings = outputMappingsBuilder.build();
            SymbolToInputRewriter symbolToInputRewriter = new SymbolToInputRewriter(sourceLayout);
            Optional<Expression> rewrittenFilter = filterExpression.map(symbolToInputRewriter::rewrite);
            ArrayList<Expression> rewrittenProjections = new ArrayList<Expression>();
            for (Symbol symbol : outputSymbols) {
                rewrittenProjections.add(symbolToInputRewriter.rewrite(assignments.get(symbol)));
            }
            Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput(context.getSession(), LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.sqlParser, sourceTypes, Iterables.concat((Iterable)((Iterable)rewrittenFilter.map(ImmutableList::of).orElse(ImmutableList.of())), rewrittenProjections), Collections.emptyList());
            Optional<RowExpression> translatedFilter = rewrittenFilter.map(filter -> this.toRowExpression((Expression)filter, expressionTypes));
            List translatedProjections = (List)rewrittenProjections.stream().map(expression -> this.toRowExpression((Expression)expression, expressionTypes)).collect(ImmutableList.toImmutableList());
            try {
                if (columns != null) {
                    Supplier<CursorProcessor> cursorProcessor = LocalExecutionPlanner.this.expressionCompiler.compileCursorProcessor(translatedFilter, translatedProjections, sourceNode.getId());
                    Supplier<PageProcessor> pageProcessor = LocalExecutionPlanner.this.expressionCompiler.compilePageProcessor(translatedFilter, translatedProjections, Optional.of(context.getStageId() + "_" + planNodeId));
                    ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory operatorFactory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(context.getNextOperatorId(), planNodeId, sourceNode.getId(), LocalExecutionPlanner.this.pageSourceProvider, cursorProcessor, pageProcessor, columns, LocalExecutionPlanner.getTypes(rewrittenProjections, expressionTypes));
                    return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings);
                }
                Supplier<PageProcessor> pageProcessor = LocalExecutionPlanner.this.expressionCompiler.compilePageProcessor(translatedFilter, translatedProjections, Optional.of(context.getStageId() + "_" + planNodeId));
                FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(context.getNextOperatorId(), planNodeId, pageProcessor, LocalExecutionPlanner.getTypes(rewrittenProjections, expressionTypes));
                return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings, source);
            }
            catch (RuntimeException e) {
                if (!LocalExecutionPlanner.this.interpreterEnabled) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, "Compiler failed and interpreter is disabled", (Throwable)e);
                }
                log.error((Throwable)e, "Compile failed for filter=%s projections=%s sourceTypes=%s error=%s", new Object[]{filterExpression, assignments, sourceTypes, e});
                PageProcessor pageProcessor = this.createInterpretedColumnarPageProcessor(filterExpression, (List)outputSymbols.stream().map(assignments::get).collect(ImmutableList.toImmutableList()), context.getTypes(), sourceLayout, context.getSession());
                if (columns != null) {
                    InterpretedCursorProcessor cursorProcessor = new InterpretedCursorProcessor(filterExpression, (List)outputSymbols.stream().map(assignments::get).collect(ImmutableList.toImmutableList()), context.getTypes(), sourceLayout, LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.sqlParser, context.getSession());
                    ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory operatorFactory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(context.getNextOperatorId(), planNodeId, sourceNode.getId(), LocalExecutionPlanner.this.pageSourceProvider, () -> cursorProcessor, () -> pageProcessor, columns, LocalExecutionPlanner.getTypes(rewrittenProjections, expressionTypes));
                    return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings);
                }
                FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(context.getNextOperatorId(), planNodeId, () -> pageProcessor, LocalExecutionPlanner.getTypes(rewrittenProjections, expressionTypes));
                return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings, source);
            }
        }

        private PageProcessor createInterpretedColumnarPageProcessor(Optional<Expression> filter, List<Expression> projections, Map<Symbol, Type> symbolTypes, Map<Symbol, Integer> symbolToInputMappings, Session session) {
            Optional<PageFilter> pageFilter = filter.map(expression -> new InterpretedPageFilter((Expression)expression, symbolTypes, symbolToInputMappings, LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.sqlParser, session));
            List pageProjections = (List)projections.stream().map(expression -> new InterpretedPageProjection((Expression)expression, symbolTypes, symbolToInputMappings, LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.sqlParser, session)).collect(ImmutableList.toImmutableList());
            return new PageProcessor(pageFilter, pageProjections);
        }

        private RowExpression toRowExpression(Expression expression, Map<NodeRef<Expression>, Type> types) {
            return SqlToRowExpressionTranslator.translate(expression, FunctionKind.SCALAR, types, LocalExecutionPlanner.this.metadata.getFunctionRegistry(), LocalExecutionPlanner.this.metadata.getTypeManager(), this.session, true);
        }

        private Map<Integer, Type> getInputTypes(Map<Symbol, Integer> layout, List<Type> types) {
            ImmutableMap.Builder inputTypes = ImmutableMap.builder();
            for (Integer input : ImmutableSet.copyOf(layout.values())) {
                Type type = types.get(input);
                inputTypes.put((Object)input, (Object)type);
            }
            return inputTypes.build();
        }

        @Override
        public PhysicalOperation visitTableScan(TableScanNode node, LocalExecutionPlanContext context) {
            ArrayList<ColumnHandle> columns = new ArrayList<ColumnHandle>();
            for (Symbol symbol : node.getOutputSymbols()) {
                columns.add(node.getAssignments().get(symbol));
            }
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            TableScanOperator.TableScanOperatorFactory operatorFactory = new TableScanOperator.TableScanOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.pageSourceProvider, types, columns);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitValues(ValuesNode node, LocalExecutionPlanContext context) {
            context.setDriverInstanceCount(1);
            ArrayList<Type> outputTypes = new ArrayList<Type>();
            for (Symbol symbol : node.getOutputSymbols()) {
                Type type = Objects.requireNonNull(context.getTypes().get(symbol), String.format("No type for symbol %s", symbol));
                outputTypes.add(type);
            }
            if (node.getRows().isEmpty()) {
                ValuesOperator.ValuesOperatorFactory operatorFactory = new ValuesOperator.ValuesOperatorFactory(context.getNextOperatorId(), node.getId(), outputTypes, (List<Page>)ImmutableList.of());
                return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
            }
            PageBuilder pageBuilder = new PageBuilder(outputTypes);
            for (List<Expression> list : node.getRows()) {
                pageBuilder.declarePosition();
                Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(context.getSession(), LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.sqlParser, (Map<Symbol, Type>)ImmutableMap.of(), (Iterable<Expression>)ImmutableList.copyOf(list), Collections.emptyList(), false);
                for (int i = 0; i < list.size(); ++i) {
                    Object result = ExpressionInterpreter.expressionInterpreter(list.get(i), LocalExecutionPlanner.this.metadata, context.getSession(), expressionTypes).evaluate(0, new Block[0]);
                    TypeUtils.writeNativeValue((Type)((Type)outputTypes.get(i)), (BlockBuilder)pageBuilder.getBlockBuilder(i), (Object)result);
                }
            }
            ValuesOperator.ValuesOperatorFactory valuesOperatorFactory = new ValuesOperator.ValuesOperatorFactory(context.getNextOperatorId(), node.getId(), outputTypes, (List<Page>)ImmutableList.of((Object)pageBuilder.build()));
            return new PhysicalOperation(valuesOperatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitUnnest(UnnestNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            ImmutableList.Builder replicateTypes = ImmutableList.builder();
            for (Symbol symbol : node.getReplicateSymbols()) {
                replicateTypes.add((Object)context.getTypes().get(symbol));
            }
            ImmutableList unnestSymbols = ImmutableList.copyOf(node.getUnnestSymbols().keySet());
            ImmutableList.Builder unnestTypes = ImmutableList.builder();
            for (Symbol symbol : unnestSymbols) {
                unnestTypes.add((Object)context.getTypes().get(symbol));
            }
            Optional<Symbol> ordinalitySymbol = node.getOrdinalitySymbol();
            Optional<Type> ordinalityType = ordinalitySymbol.map(context.getTypes()::get);
            ordinalityType.ifPresent(type -> Preconditions.checkState((boolean)type.equals(BigintType.BIGINT), (Object)"Type of ordinalitySymbol must always be BIGINT."));
            List replicateChannels = LocalExecutionPlanner.getChannelsForSymbols(node.getReplicateSymbols(), source.getLayout());
            List unnestChannels = LocalExecutionPlanner.getChannelsForSymbols((List)unnestSymbols, source.getLayout());
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : node.getReplicateSymbols()) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            for (Symbol symbol : unnestSymbols) {
                for (Symbol unnestedSymbol : node.getUnnestSymbols().get(symbol)) {
                    outputMappings.put((Object)unnestedSymbol, (Object)channel);
                    ++channel;
                }
            }
            if (ordinalitySymbol.isPresent()) {
                outputMappings.put((Object)ordinalitySymbol.get(), (Object)channel);
                ++channel;
            }
            UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(context.getNextOperatorId(), node.getId(), replicateChannels, (List<Type>)replicateTypes.build(), unnestChannels, (List<Type>)unnestTypes.build(), ordinalityType.isPresent());
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), source);
        }

        private ImmutableMap<Symbol, Integer> makeLayout(PlanNode node) {
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : node.getOutputSymbols()) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            return outputMappings.build();
        }

        @Override
        public PhysicalOperation visitIndexSource(IndexSourceNode node, LocalExecutionPlanContext context) {
            Preconditions.checkState((boolean)context.getIndexSourceContext().isPresent(), (Object)"Must be in an index source context");
            IndexSourceContext indexSourceContext = context.getIndexSourceContext().get();
            SetMultimap indexLookupToProbeInput = indexSourceContext.getIndexLookupToProbeInput();
            Preconditions.checkState((boolean)indexLookupToProbeInput.keySet().equals(node.getLookupSymbols()));
            ImmutableList lookupSymbolSchema = ImmutableList.copyOf(node.getLookupSymbols());
            ImmutableList.Builder remappedProbeKeyChannelsBuilder = ImmutableList.builder();
            ImmutableList.Builder overlappingFieldSetsBuilder = ImmutableList.builder();
            for (Symbol lookupSymbol : lookupSymbolSchema) {
                Set potentialProbeInputs = indexLookupToProbeInput.get((Object)lookupSymbol);
                Preconditions.checkState((!potentialProbeInputs.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one source from the probe input");
                if (potentialProbeInputs.size() > 1) {
                    overlappingFieldSetsBuilder.add(potentialProbeInputs.stream().collect(ImmutableSet.toImmutableSet()));
                }
                remappedProbeKeyChannelsBuilder.add(Iterables.getFirst((Iterable)potentialProbeInputs, null));
            }
            ImmutableList overlappingFieldSets = overlappingFieldSetsBuilder.build();
            ImmutableList remappedProbeKeyChannels = remappedProbeKeyChannelsBuilder.build();
            Function<RecordSet, RecordSet> probeKeyNormalizer = arg_0 -> this.lambda$visitIndexSource$12((List)overlappingFieldSets, (List)remappedProbeKeyChannels, arg_0);
            List lookupSchema = Lists.transform((List)lookupSymbolSchema, (com.google.common.base.Function)Functions.forMap(node.getAssignments()));
            List outputSchema = Lists.transform(node.getOutputSymbols(), (com.google.common.base.Function)Functions.forMap(node.getAssignments()));
            ConnectorIndex index = LocalExecutionPlanner.this.indexManager.getIndex(this.session, node.getIndexHandle(), lookupSchema, outputSchema);
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            IndexSourceOperator.IndexSourceOperatorFactory operatorFactory = new IndexSourceOperator.IndexSourceOperatorFactory(context.getNextOperatorId(), node.getId(), index, types, probeKeyNormalizer);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        private SetMultimap<Symbol, Integer> mapIndexSourceLookupSymbolToProbeKeyInput(IndexJoinNode node, Map<Symbol, Integer> probeKeyLayout) {
            Set indexJoinSymbols = (Set)node.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getIndex).collect(ImmutableSet.toImmutableSet());
            Map<Symbol, Symbol> indexKeyTrace = IndexJoinOptimizer.IndexKeyTracer.trace(node.getIndexSource(), indexJoinSymbols);
            HashMultimap indexToProbeKeyInput = HashMultimap.create();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                indexToProbeKeyInput.put((Object)clause.getIndex(), (Object)probeKeyLayout.get(clause.getProbe()));
            }
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (Map.Entry<Symbol, Symbol> entry : indexKeyTrace.entrySet()) {
                Symbol indexJoinSymbol = entry.getKey();
                Symbol indexLookupSymbol = entry.getValue();
                builder.putAll((Object)indexLookupSymbol, (Iterable)indexToProbeKeyInput.get((Object)indexJoinSymbol));
            }
            return builder.build();
        }

        @Override
        public PhysicalOperation visitIndexJoin(IndexJoinNode node, LocalExecutionPlanContext context) {
            OperatorFactory lookupJoinOperatorFactory;
            List<IndexJoinNode.EquiJoinClause> clauses = node.getCriteria();
            List probeSymbols = Lists.transform(clauses, IndexJoinNode.EquiJoinClause::getProbe);
            List indexSymbols = Lists.transform(clauses, IndexJoinNode.EquiJoinClause::getIndex);
            PhysicalOperation probeSource = node.getProbeSource().accept(this, context);
            List probeChannels = LocalExecutionPlanner.getChannelsForSymbols(probeSymbols, probeSource.getLayout());
            OptionalInt probeHashChannel = node.getProbeHashSymbol().map(LocalExecutionPlanner.channelGetter(probeSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            HashMap<Symbol, Integer> probeKeyLayout = new HashMap<Symbol, Integer>();
            for (int i = 0; i < probeSymbols.size(); ++i) {
                probeKeyLayout.put((Symbol)probeSymbols.get(i), i);
            }
            SetMultimap<Symbol, Integer> indexLookupToProbeInput = this.mapIndexSourceLookupSymbolToProbeKeyInput(node, probeKeyLayout);
            LocalExecutionPlanContext indexContext = context.createIndexSourceSubContext(new IndexSourceContext(indexLookupToProbeInput));
            PhysicalOperation indexSource = node.getIndexSource().accept(this, indexContext);
            List indexOutputChannels = LocalExecutionPlanner.getChannelsForSymbols(indexSymbols, indexSource.getLayout());
            OptionalInt indexHashChannel = node.getIndexHashSymbol().map(LocalExecutionPlanner.channelGetter(indexSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            Set<Symbol> indexSymbolsNeededBySource = IndexJoinOptimizer.IndexKeyTracer.trace(node.getIndexSource(), (Set<Symbol>)ImmutableSet.copyOf((Collection)indexSymbols)).keySet();
            Set lookupSourceInputChannels = (Set)node.getCriteria().stream().filter(equiJoinClause -> indexSymbolsNeededBySource.contains(equiJoinClause.getIndex())).map(IndexJoinNode.EquiJoinClause::getProbe).map(probeKeyLayout::get).collect(ImmutableSet.toImmutableSet());
            Optional<DynamicTupleFilterFactory> dynamicTupleFilterFactory = Optional.empty();
            if (lookupSourceInputChannels.size() < probeKeyLayout.values().size()) {
                int[] nonLookupInputChannels = Ints.toArray((Collection)((Collection)node.getCriteria().stream().filter(equiJoinClause -> !indexSymbolsNeededBySource.contains(equiJoinClause.getIndex())).map(IndexJoinNode.EquiJoinClause::getProbe).map(probeKeyLayout::get).collect(ImmutableList.toImmutableList())));
                int[] nonLookupOutputChannels = Ints.toArray((Collection)((Collection)node.getCriteria().stream().filter(equiJoinClause -> !indexSymbolsNeededBySource.contains(equiJoinClause.getIndex())).map(IndexJoinNode.EquiJoinClause::getIndex).map(indexSource.getLayout()::get).collect(ImmutableList.toImmutableList())));
                int filterOperatorId = indexContext.getNextOperatorId();
                dynamicTupleFilterFactory = Optional.of(new DynamicTupleFilterFactory(filterOperatorId, node.getId(), nonLookupInputChannels, nonLookupOutputChannels, indexSource.getTypes(), LocalExecutionPlanner.this.pageFunctionCompiler));
            }
            IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider = new IndexBuildDriverFactoryProvider(indexContext.getNextPipelineId(), indexContext.getNextOperatorId(), node.getId(), indexContext.isInputDriver(), indexSource.getOperatorFactories(), dynamicTupleFilterFactory);
            IndexLookupSourceFactory indexLookupSourceFactory = new IndexLookupSourceFactory(lookupSourceInputChannels, indexOutputChannels, indexHashChannel, indexSource.getTypes(), indexSource.getLayout(), indexBuildDriverFactoryProvider, LocalExecutionPlanner.this.maxIndexMemorySize, LocalExecutionPlanner.this.indexJoinLookupStats, SystemSessionProperties.isShareIndexLoading(this.session), LocalExecutionPlanner.this.pagesIndexFactory, LocalExecutionPlanner.this.joinCompiler);
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(probeSource.getLayout());
            int offset = probeSource.getTypes().size();
            for (Map.Entry<Symbol, Integer> entry : indexSource.getLayout().entrySet()) {
                Integer input = entry.getValue();
                outputMappings.put((Object)entry.getKey(), (Object)(offset + input));
            }
            OptionalInt totalOperatorsCount = this.getJoinOperatorsCountForSpill(context, this.session);
            switch (node.getType()) {
                case INNER: {
                    lookupJoinOperatorFactory = LocalExecutionPlanner.this.lookupJoinOperators.innerJoin(context.getNextOperatorId(), node.getId(), indexLookupSourceFactory, probeSource.getTypes(), probeChannels, probeHashChannel, Optional.empty(), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                    break;
                }
                case SOURCE_OUTER: {
                    lookupJoinOperatorFactory = LocalExecutionPlanner.this.lookupJoinOperators.probeOuterJoin(context.getNextOperatorId(), node.getId(), indexLookupSourceFactory, probeSource.getTypes(), probeChannels, probeHashChannel, Optional.empty(), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown type: " + (Object)((Object)node.getType())));
                }
            }
            return new PhysicalOperation(lookupJoinOperatorFactory, (Map<Symbol, Integer>)outputMappings.build(), probeSource);
        }

        @Override
        public PhysicalOperation visitJoin(JoinNode node, LocalExecutionPlanContext context) {
            List<JoinNode.EquiJoinClause> clauses = node.getCriteria();
            if (node.isCrossJoin()) {
                return this.createNestedLoopJoin(node, context);
            }
            List leftSymbols = Lists.transform(clauses, JoinNode.EquiJoinClause::getLeft);
            List rightSymbols = Lists.transform(clauses, JoinNode.EquiJoinClause::getRight);
            switch (node.getType()) {
                case INNER: 
                case LEFT: 
                case RIGHT: 
                case FULL: {
                    return this.createLookupJoin(node, node.getLeft(), leftSymbols, node.getLeftHashSymbol(), node.getRight(), rightSymbols, node.getRightHashSymbol(), context);
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
        }

        private PhysicalOperation createNestedLoopJoin(JoinNode node, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = node.getLeft().accept(this, context);
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = node.getRight().accept(this, buildContext);
            NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(buildContext.getNextOperatorId(), node.getId(), buildSource.getTypes());
            Preconditions.checkArgument((buildContext.getDriverInstanceCount().orElse(1) == 1 ? 1 : 0) != 0, (Object)"Expected local execution to not be parallel");
            context.addDriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)nestedLoopBuildOperatorFactory).build(), buildContext.getDriverInstanceCount());
            NestedLoopJoinPagesSupplier nestedLoopJoinPagesSupplier = nestedLoopBuildOperatorFactory.getNestedLoopJoinPagesSupplier();
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(probeSource.getLayout());
            int offset = probeSource.getTypes().size();
            for (Map.Entry<Symbol, Integer> entry : buildSource.getLayout().entrySet()) {
                outputMappings.put((Object)entry.getKey(), (Object)(offset + entry.getValue()));
            }
            NestedLoopJoinOperator.NestedLoopJoinOperatorFactory operatorFactory = new NestedLoopJoinOperator.NestedLoopJoinOperatorFactory(context.getNextOperatorId(), node.getId(), nestedLoopJoinPagesSupplier, probeSource.getTypes());
            PhysicalOperation operation = new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), probeSource);
            return operation;
        }

        private PhysicalOperation createLookupJoin(JoinNode node, PlanNode probeNode, List<Symbol> probeSymbols, Optional<Symbol> probeHashSymbol, PlanNode buildNode, List<Symbol> buildSymbols, Optional<Symbol> buildHashSymbol, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = probeNode.accept(this, context);
            LookupSourceFactory lookupSourceFactory = this.createLookupSourceFactory(node, buildNode, buildSymbols, buildHashSymbol, probeSource.getLayout(), context);
            OperatorFactory operator = this.createLookupJoin(node, probeSource, probeSymbols, probeHashSymbol, lookupSourceFactory, context);
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            List<Symbol> outputSymbols = node.getOutputSymbols();
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                outputMappings.put((Object)symbol, (Object)i);
            }
            return new PhysicalOperation(operator, (Map<Symbol, Integer>)outputMappings.build(), probeSource);
        }

        private LookupSourceFactory createLookupSourceFactory(JoinNode node, PlanNode buildNode, List<Symbol> buildSymbols, Optional<Symbol> buildHashSymbol, Map<Symbol, Integer> probeLayout, LocalExecutionPlanContext context) {
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = buildNode.accept(this, buildContext);
            List buildOutputSymbols = (List)node.getOutputSymbols().stream().filter(symbol -> node.getRight().getOutputSymbols().contains(symbol)).collect(ImmutableList.toImmutableList());
            ImmutableList buildOutputChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(buildOutputSymbols, buildSource.getLayout()));
            ImmutableList buildChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(buildSymbols, buildSource.getLayout()));
            OptionalInt buildHashChannel = buildHashSymbol.map(LocalExecutionPlanner.channelGetter(buildSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            boolean spillEnabled = SystemSessionProperties.isSpillEnabled(context.getSession());
            boolean buildOuter = node.getType() == JoinNode.Type.RIGHT || node.getType() == JoinNode.Type.FULL;
            int partitionCount = buildContext.getDriverInstanceCount().orElse(1);
            Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory = node.getFilter().map(filterExpression -> this.compileJoinFilterFunction((Expression)filterExpression, probeLayout, buildSource.getLayout(), context.getTypes(), context.getSession()));
            Optional<SortExpressionContext> sortExpressionContext = node.getSortExpressionContext();
            Optional<Integer> sortChannel = sortExpressionContext.map(SortExpressionContext::getSortExpression).map(sortExpression -> this.sortExpressionAsSortChannel((Expression)sortExpression, probeLayout, buildSource.getLayout()));
            List searchFunctionFactories = (List)sortExpressionContext.map(SortExpressionContext::getSearchExpressions).map(searchExpressions -> (ImmutableList)searchExpressions.stream().map(searchExpression -> this.compileJoinFilterFunction((Expression)searchExpression, probeLayout, buildSource.getLayout(), context.getTypes(), context.getSession())).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
            HashBuilderOperator.HashBuilderOperatorFactory hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(buildContext.getNextOperatorId(), node.getId(), buildSource.getTypes(), (List<Integer>)buildOutputChannels, buildSource.getLayout(), (List<Integer>)buildChannels, buildHashChannel, buildOuter, filterFunctionFactory, sortChannel, searchFunctionFactories, 10000, partitionCount, LocalExecutionPlanner.this.pagesIndexFactory, spillEnabled && !buildOuter && partitionCount > 1, LocalExecutionPlanner.this.singleStreamSpillerFactory);
            context.addDriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)hashBuilderOperatorFactory).build(), buildContext.getDriverInstanceCount());
            return hashBuilderOperatorFactory.getLookupSourceFactory();
        }

        private JoinFilterFunctionCompiler.JoinFilterFunctionFactory compileJoinFilterFunction(Expression filterExpression, Map<Symbol, Integer> probeLayout, Map<Symbol, Integer> buildLayout, Map<Symbol, Type> types, Session session) {
            Map<Symbol, Integer> joinSourcesLayout = this.createJoinSourcesLayout(buildLayout, probeLayout);
            Map sourceTypes = (Map)joinSourcesLayout.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getValue, entry -> (Type)types.get(entry.getKey())));
            Expression rewrittenFilter = new SymbolToInputRewriter(joinSourcesLayout).rewrite(filterExpression);
            Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput(session, LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.sqlParser, (Map<Integer, Type>)sourceTypes, rewrittenFilter, Collections.emptyList());
            RowExpression translatedFilter = this.toRowExpression(rewrittenFilter, expressionTypes);
            return LocalExecutionPlanner.this.joinFilterFunctionCompiler.compileJoinFilterFunction(translatedFilter, buildLayout.size());
        }

        private int sortExpressionAsSortChannel(Expression sortExpression, Map<Symbol, Integer> probeLayout, Map<Symbol, Integer> buildLayout) {
            Map<Symbol, Integer> joinSourcesLayout = this.createJoinSourcesLayout(buildLayout, probeLayout);
            Expression rewrittenSortExpression = new SymbolToInputRewriter(joinSourcesLayout).rewrite(sortExpression);
            Preconditions.checkArgument((boolean)(rewrittenSortExpression instanceof FieldReference), (String)"Unsupported expression type [%s]", (Object)rewrittenSortExpression);
            return ((FieldReference)rewrittenSortExpression).getFieldIndex();
        }

        private OperatorFactory createLookupJoin(JoinNode node, PhysicalOperation probeSource, List<Symbol> probeSymbols, Optional<Symbol> probeHashSymbol, LookupSourceFactory lookupSourceFactory, LocalExecutionPlanContext context) {
            List<Type> probeTypes = probeSource.getTypes();
            List probeOutputSymbols = (List)node.getOutputSymbols().stream().filter(symbol -> node.getLeft().getOutputSymbols().contains(symbol)).collect(ImmutableList.toImmutableList());
            ImmutableList probeOutputChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(probeOutputSymbols, probeSource.getLayout()));
            ImmutableList probeJoinChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(probeSymbols, probeSource.getLayout()));
            OptionalInt probeHashChannel = probeHashSymbol.map(LocalExecutionPlanner.channelGetter(probeSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            OptionalInt totalOperatorsCount = this.getJoinOperatorsCountForSpill(context, this.session);
            switch (node.getType()) {
                case INNER: {
                    return LocalExecutionPlanner.this.lookupJoinOperators.innerJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactory, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel, Optional.of(probeOutputChannels), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                }
                case LEFT: {
                    return LocalExecutionPlanner.this.lookupJoinOperators.probeOuterJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactory, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel, Optional.of(probeOutputChannels), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                }
                case RIGHT: {
                    return LocalExecutionPlanner.this.lookupJoinOperators.lookupOuterJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactory, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel, Optional.of(probeOutputChannels), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                }
                case FULL: {
                    return LocalExecutionPlanner.this.lookupJoinOperators.fullOuterJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactory, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel, Optional.of(probeOutputChannels), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
        }

        private OptionalInt getJoinOperatorsCountForSpill(LocalExecutionPlanContext context, Session session) {
            OptionalInt driverInstanceCount = context.getDriverInstanceCount();
            if (SystemSessionProperties.isSpillEnabled(session)) {
                Preconditions.checkState((boolean)driverInstanceCount.isPresent(), (Object)"A fixed distribution is required for JOIN when spilling is enabled");
            }
            return driverInstanceCount;
        }

        private Map<Symbol, Integer> createJoinSourcesLayout(Map<Symbol, Integer> lookupSourceLayout, Map<Symbol, Integer> probeSourceLayout) {
            ImmutableMap.Builder joinSourcesLayout = ImmutableMap.builder();
            joinSourcesLayout.putAll(lookupSourceLayout);
            for (Map.Entry<Symbol, Integer> probeLayoutEntry : probeSourceLayout.entrySet()) {
                joinSourcesLayout.put((Object)probeLayoutEntry.getKey(), (Object)(probeLayoutEntry.getValue() + lookupSourceLayout.size()));
            }
            return joinSourcesLayout.build();
        }

        @Override
        public PhysicalOperation visitSemiJoin(SemiJoinNode node, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = node.getSource().accept(this, context);
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = node.getFilteringSource().accept(this, buildContext);
            Preconditions.checkArgument((buildContext.getDriverInstanceCount().orElse(1) == 1 ? 1 : 0) != 0, (Object)"Expected local execution to not be parallel");
            int probeChannel = probeSource.getLayout().get(node.getSourceJoinSymbol());
            int buildChannel = buildSource.getLayout().get(node.getFilteringSourceJoinSymbol());
            Optional<Integer> buildHashChannel = node.getFilteringSourceHashSymbol().map(LocalExecutionPlanner.channelGetter(buildSource));
            SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(buildContext.getNextOperatorId(), node.getId(), buildSource.getTypes().get(buildChannel), buildChannel, buildHashChannel, 10000, LocalExecutionPlanner.this.joinCompiler);
            SetBuilderOperator.SetSupplier setProvider = setBuilderOperatorFactory.getSetProvider();
            context.addDriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)setBuilderOperatorFactory).build(), buildContext.getDriverInstanceCount());
            ImmutableMap outputMappings = ImmutableMap.builder().putAll(probeSource.getLayout()).put((Object)node.getSemiJoinOutput(), (Object)probeSource.getLayout().size()).build();
            HashSemiJoinOperator.HashSemiJoinOperatorFactory operator = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(context.getNextOperatorId(), node.getId(), setProvider, probeSource.getTypes(), probeChannel);
            return new PhysicalOperation(operator, (Map<Symbol, Integer>)outputMappings, probeSource);
        }

        @Override
        public PhysicalOperation visitTableWriter(TableWriterNode node, LocalExecutionPlanContext context) {
            if (node.getPartitioningScheme().isPresent()) {
                context.setDriverInstanceCount(1);
            } else {
                context.setDriverInstanceCount(SystemSessionProperties.getTaskWriterCount(this.session));
            }
            PhysicalOperation source = node.getSource().accept(this, context);
            List inputChannels = (List)node.getColumns().stream().map(source::symbolToChannel).collect(ImmutableList.toImmutableList());
            TableWriterOperator.TableWriterOperatorFactory operatorFactory = new TableWriterOperator.TableWriterOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.pageSinkManager, node.getTarget(), inputChannels, this.session);
            ImmutableMap layout = ImmutableMap.builder().put((Object)node.getOutputSymbols().get(0), (Object)0).put((Object)node.getOutputSymbols().get(1), (Object)1).build();
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)layout, source);
        }

        @Override
        public PhysicalOperation visitTableFinish(TableFinishNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            TableFinishOperator.TableFinishOperatorFactory operatorFactory = new TableFinishOperator.TableFinishOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.createTableFinisher(this.session, node, LocalExecutionPlanner.this.metadata));
            ImmutableMap layout = ImmutableMap.of((Object)node.getOutputSymbols().get(0), (Object)0);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)layout, source);
        }

        @Override
        public PhysicalOperation visitDelete(DeleteNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            DeleteOperator.DeleteOperatorFactory operatorFactory = new DeleteOperator.DeleteOperatorFactory(context.getNextOperatorId(), node.getId(), source.getLayout().get(node.getRowId()));
            ImmutableMap layout = ImmutableMap.builder().put((Object)node.getOutputSymbols().get(0), (Object)0).put((Object)node.getOutputSymbols().get(1), (Object)1).build();
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)layout, source);
        }

        @Override
        public PhysicalOperation visitMetadataDelete(MetadataDeleteNode node, LocalExecutionPlanContext context) {
            MetadataDeleteOperator.MetadataDeleteOperatorFactory operatorFactory = new MetadataDeleteOperator.MetadataDeleteOperatorFactory(context.getNextOperatorId(), node.getId(), node.getTableLayout(), LocalExecutionPlanner.this.metadata, this.session, node.getTarget().getHandle());
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitUnion(UnionNode node, LocalExecutionPlanContext context) {
            throw new UnsupportedOperationException("Union node should not be present in a local execution plan");
        }

        @Override
        public PhysicalOperation visitEnforceSingleRow(EnforceSingleRowNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            EnforceSingleRowOperator.EnforceSingleRowOperatorFactory operatorFactory = new EnforceSingleRowOperator.EnforceSingleRowOperatorFactory(context.getNextOperatorId(), node.getId(), types);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), source);
        }

        @Override
        public PhysicalOperation visitAssignUniqueId(AssignUniqueId node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            AssignUniqueIdOperator.AssignUniqueIdOperatorFactory operatorFactory = new AssignUniqueIdOperator.AssignUniqueIdOperatorFactory(context.getNextOperatorId(), node.getId(), types);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), source);
        }

        @Override
        public PhysicalOperation visitExchange(ExchangeNode node, LocalExecutionPlanContext context) {
            int driverInstanceCount;
            Preconditions.checkArgument((node.getScope() == ExchangeNode.Scope.LOCAL ? 1 : 0) != 0, (Object)"Only local exchanges are supported in the local planner");
            if (node.getType() == ExchangeNode.Type.GATHER) {
                driverInstanceCount = 1;
                context.setDriverInstanceCount(1);
            } else if (context.getDriverInstanceCount().isPresent()) {
                driverInstanceCount = context.getDriverInstanceCount().getAsInt();
            } else {
                driverInstanceCount = SystemSessionProperties.getTaskConcurrency(this.session);
                context.setDriverInstanceCount(driverInstanceCount);
            }
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            List channels = (List)node.getPartitioningScheme().getPartitioning().getArguments().stream().map(argument -> node.getOutputSymbols().indexOf(argument.getColumn())).collect(ImmutableList.toImmutableList());
            Optional<Integer> hashChannel = node.getPartitioningScheme().getHashColumn().map(symbol -> node.getOutputSymbols().indexOf(symbol));
            LocalExchange localExchange = new LocalExchange(node.getPartitioningScheme().getPartitioning().getHandle(), driverInstanceCount, types, channels, hashChannel);
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode sourceNode = node.getSources().get(i);
                List<Symbol> expectedLayout = node.getInputs().get(i);
                LocalExecutionPlanContext subContext = context.createSubContext();
                PhysicalOperation source = sourceNode.accept(this, subContext);
                ArrayList<OperatorFactory> operatorFactories = new ArrayList<OperatorFactory>(source.getOperatorFactories());
                Function pagePreprocessor = LocalExecutionPlanner.enforceLayoutProcessor(expectedLayout, source.getLayout());
                operatorFactories.add(new LocalExchangeSinkOperator.LocalExchangeSinkOperatorFactory(subContext.getNextOperatorId(), node.getId(), localExchange.createSinkFactory(), pagePreprocessor));
                context.addDriverFactory(subContext.isInputDriver(), false, operatorFactories, subContext.getDriverInstanceCount());
            }
            context.setInputDriver(false);
            Verify.verify((context.getDriverInstanceCount().getAsInt() == localExchange.getBufferCount() ? 1 : 0) != 0, (String)"driver instance count must match the number of exchange partitions", (Object[])new Object[0]);
            return new PhysicalOperation(new LocalExchangeSourceOperator.LocalExchangeSourceOperatorFactory(context.getNextOperatorId(), node.getId(), localExchange), (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        protected PhysicalOperation visitPlan(PlanNode node, LocalExecutionPlanContext context) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        private List<Type> getSourceOperatorTypes(PlanNode node, Map<Symbol, Type> types) {
            return this.getSymbolTypes(node.getOutputSymbols(), types);
        }

        private List<Type> getSymbolTypes(List<Symbol> symbols, Map<Symbol, Type> types) {
            return (List)symbols.stream().map(types::get).collect(ImmutableList.toImmutableList());
        }

        private AccumulatorFactory buildAccumulatorFactory(PhysicalOperation source, Signature function, FunctionCall call, Optional<Symbol> mask) {
            ArrayList<Integer> arguments = new ArrayList<Integer>();
            for (Expression argument : call.getArguments()) {
                Symbol argumentSymbol = Symbol.from(argument);
                arguments.add(source.getLayout().get(argumentSymbol));
            }
            Optional<Integer> maskChannel = Optional.empty();
            if (mask != null) {
                maskChannel = mask.map(value -> source.getLayout().get(value));
            }
            return LocalExecutionPlanner.this.metadata.getFunctionRegistry().getAggregateFunctionImplementation(function).bind(arguments, maskChannel);
        }

        private PhysicalOperation planGlobalAggregation(int operatorId, AggregationNode node, PhysicalOperation source) {
            int outputChannel = 0;
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            ArrayList<AccumulatorFactory> accumulatorFactories = new ArrayList<AccumulatorFactory>();
            for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
                Symbol symbol = entry.getKey();
                AggregationNode.Aggregation aggregation = entry.getValue();
                accumulatorFactories.add(this.buildAccumulatorFactory(source, aggregation.getSignature(), aggregation.getCall(), aggregation.getMask()));
                outputMappings.put((Object)symbol, (Object)outputChannel);
                ++outputChannel;
            }
            AggregationOperator.AggregationOperatorFactory operatorFactory = new AggregationOperator.AggregationOperatorFactory(operatorId, node.getId(), node.getStep(), accumulatorFactories);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), source);
        }

        private PhysicalOperation planGroupByAggregation(AggregationNode node, PhysicalOperation source, int operatorId, boolean spillEnabled, DataSize unspillMemoryLimit) {
            List<Symbol> groupBySymbols = node.getGroupingKeys();
            ArrayList<Symbol> aggregationOutputSymbols = new ArrayList<Symbol>();
            ArrayList<AccumulatorFactory> accumulatorFactories = new ArrayList<AccumulatorFactory>();
            for (Map.Entry<Symbol, AggregationNode.Aggregation> entry2 : node.getAggregations().entrySet()) {
                Symbol symbol = entry2.getKey();
                Iterator aggregation = entry2.getValue();
                accumulatorFactories.add(this.buildAccumulatorFactory(source, ((AggregationNode.Aggregation)((Object)aggregation)).getSignature(), ((AggregationNode.Aggregation)((Object)aggregation)).getCall(), ((AggregationNode.Aggregation)((Object)aggregation)).getMask()));
                aggregationOutputSymbols.add(symbol);
            }
            ImmutableList.Builder globalAggregationGroupIds = ImmutableList.builder();
            for (int i = 0; i < node.getGroupingSets().size(); ++i) {
                if (!node.getGroupingSets().get(i).isEmpty()) continue;
                globalAggregationGroupIds.add((Object)i);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : groupBySymbols) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            if (node.getHashSymbol().isPresent()) {
                outputMappings.put((Object)node.getHashSymbol().get(), (Object)channel++);
            }
            for (Symbol symbol : aggregationOutputSymbols) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            List groupByChannels = LocalExecutionPlanner.getChannelsForSymbols(groupBySymbols, source.getLayout());
            List groupByTypes = (List)groupByChannels.stream().map(entry -> source.getTypes().get((int)entry)).collect(ImmutableList.toImmutableList());
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            ImmutableMap mappings = outputMappings.build();
            HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(operatorId, node.getId(), groupByTypes, groupByChannels, (List<Integer>)globalAggregationGroupIds.build(), node.getStep(), node.hasDefaultOutput(), accumulatorFactories, hashChannel, node.getGroupIdSymbol().map(((Map)mappings)::get), 10000, LocalExecutionPlanner.this.maxPartialAggregationMemorySize, spillEnabled, unspillMemoryLimit, LocalExecutionPlanner.this.spillerFactory, LocalExecutionPlanner.this.joinCompiler);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)mappings, source);
        }

        private /* synthetic */ RecordSet lambda$visitIndexSource$12(List overlappingFieldSets, List remappedProbeKeyChannels, RecordSet recordSet) {
            if (!overlappingFieldSets.isEmpty()) {
                recordSet = new FieldSetFilteringRecordSet(LocalExecutionPlanner.this.metadata.getFunctionRegistry(), recordSet, overlappingFieldSets);
            }
            return new MappedRecordSet(recordSet, remappedProbeKeyChannels);
        }
    }

    public static class LocalExecutionPlan {
        private final List<DriverFactory> driverFactories;

        public LocalExecutionPlan(List<DriverFactory> driverFactories) {
            this.driverFactories = ImmutableList.copyOf((Collection)Objects.requireNonNull(driverFactories, "driverFactories is null"));
        }

        public List<DriverFactory> getDriverFactories() {
            return this.driverFactories;
        }
    }

    private static class IndexSourceContext {
        private final SetMultimap<Symbol, Integer> indexLookupToProbeInput;

        public IndexSourceContext(SetMultimap<Symbol, Integer> indexLookupToProbeInput) {
            this.indexLookupToProbeInput = ImmutableSetMultimap.copyOf((Multimap)((Multimap)Objects.requireNonNull(indexLookupToProbeInput, "indexLookupToProbeInput is null")));
        }

        private SetMultimap<Symbol, Integer> getIndexLookupToProbeInput() {
            return this.indexLookupToProbeInput;
        }
    }

    private static class LocalExecutionPlanContext {
        private final TaskContext taskContext;
        private final Map<Symbol, Type> types;
        private final List<DriverFactory> driverFactories;
        private final Optional<IndexSourceContext> indexSourceContext;
        private AtomicInteger nextPipelineId;
        private int nextOperatorId;
        private boolean inputDriver = true;
        private OptionalInt driverInstanceCount = OptionalInt.empty();

        public LocalExecutionPlanContext(TaskContext taskContext, Map<Symbol, Type> types) {
            this(taskContext, types, new ArrayList<DriverFactory>(), Optional.empty(), new AtomicInteger(0));
        }

        private LocalExecutionPlanContext(TaskContext taskContext, Map<Symbol, Type> types, List<DriverFactory> driverFactories, Optional<IndexSourceContext> indexSourceContext, AtomicInteger nextPipelineId) {
            this.taskContext = taskContext;
            this.types = types;
            this.driverFactories = driverFactories;
            this.indexSourceContext = indexSourceContext;
            this.nextPipelineId = nextPipelineId;
        }

        public void addDriverFactory(boolean inputDriver, boolean outputDriver, List<OperatorFactory> operatorFactories, OptionalInt driverInstances) {
            this.driverFactories.add(new DriverFactory(this.getNextPipelineId(), inputDriver, outputDriver, operatorFactories, driverInstances));
        }

        private List<DriverFactory> getDriverFactories() {
            return ImmutableList.copyOf(this.driverFactories);
        }

        public Session getSession() {
            return this.taskContext.getSession();
        }

        public StageId getStageId() {
            return this.taskContext.getTaskId().getStageId();
        }

        public Map<Symbol, Type> getTypes() {
            return this.types;
        }

        public Optional<IndexSourceContext> getIndexSourceContext() {
            return this.indexSourceContext;
        }

        private int getNextPipelineId() {
            return this.nextPipelineId.getAndIncrement();
        }

        private int getNextOperatorId() {
            return this.nextOperatorId++;
        }

        private boolean isInputDriver() {
            return this.inputDriver;
        }

        private void setInputDriver(boolean inputDriver) {
            this.inputDriver = inputDriver;
        }

        public LocalExecutionPlanContext createSubContext() {
            Preconditions.checkState((!this.indexSourceContext.isPresent() ? 1 : 0) != 0, (Object)"index build plan can not have sub-contexts");
            return new LocalExecutionPlanContext(this.taskContext, this.types, this.driverFactories, this.indexSourceContext, this.nextPipelineId);
        }

        public LocalExecutionPlanContext createIndexSourceSubContext(IndexSourceContext indexSourceContext) {
            return new LocalExecutionPlanContext(this.taskContext, this.types, this.driverFactories, Optional.of(indexSourceContext), this.nextPipelineId);
        }

        public OptionalInt getDriverInstanceCount() {
            return this.driverInstanceCount;
        }

        public void setDriverInstanceCount(int driverInstanceCount) {
            Preconditions.checkArgument((driverInstanceCount > 0 ? 1 : 0) != 0, (Object)"driverInstanceCount must be > 0");
            if (this.driverInstanceCount.isPresent()) {
                Preconditions.checkState((this.driverInstanceCount.getAsInt() == driverInstanceCount ? 1 : 0) != 0, (Object)("driverInstance count already set to " + this.driverInstanceCount.getAsInt()));
            }
            this.driverInstanceCount = OptionalInt.of(driverInstanceCount);
        }
    }
}

