/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.CompilerUtils;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Objects;

public class VarArgsToArrayAdapterGenerator {
    private VarArgsToArrayAdapterGenerator() {
    }

    public static MethodHandleAndConstructor generateVarArgsToArrayAdapter(Class<?> returnType, Class<?> javaType, int argsLength, MethodHandle function, MethodHandle userStateFactory) {
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(javaType, "javaType is null");
        Objects.requireNonNull(function, "function is null");
        Objects.requireNonNull(userStateFactory, "userStateFactory is null");
        Failures.checkCondition(argsLength <= 253, (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for vararg function", new Object[0]);
        MethodType methodType = function.type();
        Class<?> javaArrayType = VarArgsToArrayAdapterGenerator.toArrayClass(javaType);
        Preconditions.checkArgument((methodType.returnType() == returnType ? 1 : 0) != 0, (Object)"returnType does not match");
        Preconditions.checkArgument((boolean)methodType.parameterList().equals(ImmutableList.of(Object.class, javaArrayType)), (Object)"parameter types do not match");
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName((String)"VarArgsToListAdapter"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        classDefinition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        MethodDefinition stateFactoryDefinition = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "createState", ParameterizedType.type(VarArgsToArrayAdapterState.class), new Parameter[0]);
        stateFactoryDefinition.getBody().comment("create userState for current instance").append((BytecodeNode)BytecodeExpressions.newInstance(VarArgsToArrayAdapterState.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeUtils.loadConstant(callSiteBinder, userStateFactory, MethodHandle.class).invoke("invokeExact", Object.class, new BytecodeExpression[0]), BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(javaArrayType), (int)argsLength).cast(Object.class)}).ret());
        ImmutableList.Builder parameterListBuilder = ImmutableList.builder();
        parameterListBuilder.add((Object)Parameter.arg((String)"userState", VarArgsToArrayAdapterState.class));
        for (int i = 0; i < argsLength; ++i) {
            parameterListBuilder.add((Object)Parameter.arg((String)("input_" + i), javaType));
        }
        ImmutableList parameterList = parameterListBuilder.build();
        MethodDefinition methodDefinition = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "varArgsToArray", ParameterizedType.type(returnType), (Iterable)parameterList);
        BytecodeBlock body = methodDefinition.getBody();
        BytecodeExpression userState = ((Parameter)parameterList.get(0)).getField("userState", Object.class);
        BytecodeExpression args = ((Parameter)parameterList.get(0)).getField("args", Object.class).cast(javaArrayType);
        for (int i = 0; i < argsLength; ++i) {
            body.append((BytecodeNode)args.setElement(i, (BytecodeExpression)parameterList.get(i + 1)));
        }
        body.append((BytecodeNode)BytecodeUtils.loadConstant(callSiteBinder, function, MethodHandle.class).invoke("invokeExact", returnType, new BytecodeExpression[]{userState, args}).ret());
        Class generatedClass = CompilerUtils.defineClass((ClassDefinition)classDefinition, Object.class, callSiteBinder.getBindings(), (ClassLoader)VarArgsToArrayAdapterGenerator.class.getClassLoader());
        return new MethodHandleAndConstructor(Reflection.methodHandle(generatedClass, "varArgsToArray", (Class[])ImmutableList.builder().add(VarArgsToArrayAdapterState.class).addAll(Collections.nCopies(argsLength, javaType)).build().toArray((Object[])new Class[argsLength])), Reflection.methodHandle(generatedClass, "createState", new Class[0]));
    }

    private static Class<?> toArrayClass(Class<?> elementType) {
        return Array.newInstance(elementType, 0).getClass();
    }

    @UsedByGeneratedCode
    public static final class VarArgsToArrayAdapterState {
        public Object userState;
        public Object args;

        public VarArgsToArrayAdapterState(Object userState, Object args) {
            this.userState = userState;
            this.args = Objects.requireNonNull(args, "args is null");
        }
    }

    public static class MethodHandleAndConstructor {
        private final MethodHandle methodHandle;
        private final MethodHandle constructor;

        private MethodHandleAndConstructor(MethodHandle methodHandle, MethodHandle constructor) {
            this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
            this.constructor = Objects.requireNonNull(constructor, "constructor is null");
        }

        public MethodHandle getMethodHandle() {
            return this.methodHandle;
        }

        public MethodHandle getConstructor() {
            return this.constructor;
        }
    }
}

