/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.Constant;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.sql.gen.AndCodeGenerator;
import com.facebook.presto.sql.gen.BindCodeGenerator;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.BytecodeGenerator;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CastCodeGenerator;
import com.facebook.presto.sql.gen.CoalesceCodeGenerator;
import com.facebook.presto.sql.gen.DereferenceCodeGenerator;
import com.facebook.presto.sql.gen.FunctionCallCodeGenerator;
import com.facebook.presto.sql.gen.IfCodeGenerator;
import com.facebook.presto.sql.gen.InCodeGenerator;
import com.facebook.presto.sql.gen.IsNullCodeGenerator;
import com.facebook.presto.sql.gen.LambdaBytecodeGenerator;
import com.facebook.presto.sql.gen.NullIfCodeGenerator;
import com.facebook.presto.sql.gen.OrCodeGenerator;
import com.facebook.presto.sql.gen.PreGeneratedExpressions;
import com.facebook.presto.sql.gen.RowConstructorCodeGenerator;
import com.facebook.presto.sql.gen.SwitchCodeGenerator;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.LambdaDefinitionExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.facebook.presto.sql.relational.Signatures;
import com.facebook.presto.sql.relational.VariableReferenceExpression;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class RowExpressionCompiler {
    private final CallSiteBinder callSiteBinder;
    private final CachedInstanceBinder cachedInstanceBinder;
    private final RowExpressionVisitor<BytecodeNode, Scope> fieldReferenceCompiler;
    private final FunctionRegistry registry;
    private final PreGeneratedExpressions preGeneratedExpressions;

    RowExpressionCompiler(CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpressionVisitor<BytecodeNode, Scope> fieldReferenceCompiler, FunctionRegistry registry, PreGeneratedExpressions preGeneratedExpressions) {
        this.callSiteBinder = callSiteBinder;
        this.cachedInstanceBinder = cachedInstanceBinder;
        this.fieldReferenceCompiler = fieldReferenceCompiler;
        this.registry = registry;
        this.preGeneratedExpressions = preGeneratedExpressions;
    }

    public BytecodeNode compile(RowExpression rowExpression, Scope scope) {
        return this.compile(rowExpression, scope, Optional.empty());
    }

    public BytecodeNode compile(RowExpression rowExpression, Scope scope, Optional<Class> lambdaInterface) {
        return rowExpression.accept(new Visitor(), new Context(scope, lambdaInterface));
    }

    private static class Context {
        private final Scope scope;
        private final Optional<Class> lambdaInterface;

        public Context(Scope scope, Optional<Class> lambdaInterface) {
            this.scope = scope;
            this.lambdaInterface = lambdaInterface;
        }

        public Scope getScope() {
            return this.scope;
        }

        public Optional<Class> getLambdaInterface() {
            return this.lambdaInterface;
        }
    }

    private class Visitor
    implements RowExpressionVisitor<BytecodeNode, Context> {
        private Visitor() {
        }

        @Override
        public BytecodeNode visitCall(CallExpression call, Context context) {
            BytecodeGenerator generator;
            if (call.getSignature().getName().equals(Signatures.CAST)) {
                generator = new CastCodeGenerator();
            } else {
                switch (call.getSignature().getName()) {
                    case "IF": {
                        generator = new IfCodeGenerator();
                        break;
                    }
                    case "NULL_IF": {
                        generator = new NullIfCodeGenerator();
                        break;
                    }
                    case "SWITCH": {
                        generator = new SwitchCodeGenerator();
                        break;
                    }
                    case "IS_NULL": {
                        generator = new IsNullCodeGenerator();
                        break;
                    }
                    case "COALESCE": {
                        generator = new CoalesceCodeGenerator();
                        break;
                    }
                    case "IN": {
                        generator = new InCodeGenerator(RowExpressionCompiler.this.registry);
                        break;
                    }
                    case "AND": {
                        generator = new AndCodeGenerator();
                        break;
                    }
                    case "OR": {
                        generator = new OrCodeGenerator();
                        break;
                    }
                    case "DEREFERENCE": {
                        generator = new DereferenceCodeGenerator();
                        break;
                    }
                    case "ROW_CONSTRUCTOR": {
                        generator = new RowConstructorCodeGenerator();
                        break;
                    }
                    case "$INTERNAL$BIND": {
                        generator = new BindCodeGenerator(RowExpressionCompiler.this.preGeneratedExpressions.getCompiledLambdaMap(), context.getLambdaInterface().get());
                        break;
                    }
                    default: {
                        generator = new FunctionCallCodeGenerator();
                    }
                }
            }
            BytecodeGeneratorContext generatorContext = new BytecodeGeneratorContext(RowExpressionCompiler.this, context.getScope(), RowExpressionCompiler.this.callSiteBinder, RowExpressionCompiler.this.cachedInstanceBinder, RowExpressionCompiler.this.registry, RowExpressionCompiler.this.preGeneratedExpressions);
            return generator.generateExpression(call.getSignature(), generatorContext, call.getType(), call.getArguments());
        }

        @Override
        public BytecodeNode visitConstant(ConstantExpression constant, Context context) {
            Object value = constant.getValue();
            Class javaType = constant.getType().getJavaType();
            BytecodeBlock block = new BytecodeBlock();
            if (value == null) {
                return block.comment("constant null").append((BytecodeNode)context.getScope().getVariable("wasNull").set(BytecodeExpressions.constantTrue())).pushJavaDefault(javaType);
            }
            block.comment("constant " + constant.getType().getTypeSignature());
            if (javaType == Boolean.TYPE) {
                return block.append((BytecodeNode)Constant.loadBoolean((boolean)((Boolean)value)));
            }
            if (javaType == Byte.TYPE || javaType == Short.TYPE || javaType == Integer.TYPE) {
                return block.append((BytecodeNode)Constant.loadInt((int)((Number)value).intValue()));
            }
            if (javaType == Long.TYPE) {
                return block.append((BytecodeNode)Constant.loadLong((long)((Long)value)));
            }
            if (javaType == Float.TYPE) {
                return block.append((BytecodeNode)Constant.loadFloat((float)((Float)value).floatValue()));
            }
            if (javaType == Double.TYPE) {
                return block.append((BytecodeNode)Constant.loadDouble((double)((Double)value)));
            }
            if (javaType == String.class) {
                return block.append((BytecodeNode)Constant.loadString((String)((String)value)));
            }
            if (javaType == Void.TYPE) {
                return block;
            }
            Binding binding = RowExpressionCompiler.this.callSiteBinder.bind(value, constant.getType().getJavaType());
            return new BytecodeBlock().setDescription("constant " + constant.getType()).comment(constant.toString()).append((BytecodeNode)BytecodeUtils.loadConstant(binding));
        }

        @Override
        public BytecodeNode visitInputReference(InputReferenceExpression node, Context context) {
            return (BytecodeNode)RowExpressionCompiler.this.fieldReferenceCompiler.visitInputReference(node, context.getScope());
        }

        @Override
        public BytecodeNode visitLambda(LambdaDefinitionExpression lambda, Context context) {
            Preconditions.checkState((boolean)RowExpressionCompiler.this.preGeneratedExpressions.getCompiledLambdaMap().containsKey(lambda), (Object)"lambda expressions map does not contain this lambda definition");
            if (!((Class)context.lambdaInterface.get()).isAnnotationPresent(FunctionalInterface.class)) {
                throw new VerifyException("lambda should be generated as class annotated with FunctionalInterface");
            }
            BytecodeGeneratorContext generatorContext = new BytecodeGeneratorContext(RowExpressionCompiler.this, context.getScope(), RowExpressionCompiler.this.callSiteBinder, RowExpressionCompiler.this.cachedInstanceBinder, RowExpressionCompiler.this.registry, RowExpressionCompiler.this.preGeneratedExpressions);
            return LambdaBytecodeGenerator.generateLambda(generatorContext, (List<RowExpression>)ImmutableList.of(), RowExpressionCompiler.this.preGeneratedExpressions.getCompiledLambdaMap().get(lambda), context.getLambdaInterface().get());
        }

        @Override
        public BytecodeNode visitVariableReference(VariableReferenceExpression reference, Context context) {
            return (BytecodeNode)RowExpressionCompiler.this.fieldReferenceCompiler.visitVariableReference(reference, context.getScope());
        }
    }
}

