/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.split.SplitSource;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;

public class SampledSplitSource
implements SplitSource {
    private final SplitSource splitSource;
    private final double sampleRatio;

    public SampledSplitSource(SplitSource splitSource, double sampleRatio) {
        this.splitSource = Objects.requireNonNull(splitSource, "dataSource is null");
        this.sampleRatio = sampleRatio;
    }

    @Override
    @Nullable
    public ConnectorId getConnectorId() {
        return this.splitSource.getConnectorId();
    }

    @Override
    public ConnectorTransactionHandle getTransactionHandle() {
        return this.splitSource.getTransactionHandle();
    }

    @Override
    public ListenableFuture<List<Split>> getNextBatch(int maxSize) {
        ListenableFuture<List<Split>> batch = this.splitSource.getNextBatch(maxSize);
        return Futures.transform(batch, splits -> (ImmutableList)splits.stream().filter(input -> ThreadLocalRandom.current().nextDouble() < this.sampleRatio).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public void close() {
        this.splitSource.close();
    }

    @Override
    public boolean isFinished() {
        return this.splitSource.isFinished();
    }
}

