/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security;

import com.facebook.presto.server.security.KerberosConfig;
import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import com.sun.security.auth.module.Krb5LoginModule;
import io.airlift.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SpnegoFilter
implements Filter {
    private static final Logger LOG = Logger.get(SpnegoFilter.class);
    private static final String NEGOTIATE_SCHEME = "Negotiate";
    private static final String INCLUDE_REALM_HEADER = "X-Airlift-Realm-In-Challenge";
    private final GSSManager gssManager = GSSManager.getInstance();
    private final LoginContext loginContext;
    private final GSSCredential serverCredential;

    @Inject
    public SpnegoFilter(final KerberosConfig config) {
        System.setProperty("java.security.krb5.conf", config.getKerberosConfig().getAbsolutePath());
        try {
            String hostname = InetAddress.getLocalHost().getCanonicalHostName().toLowerCase(Locale.US);
            final String servicePrincipal = config.getServiceName() + "/" + hostname;
            this.loginContext = new LoginContext("", null, null, new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("refreshKrb5Config", "true");
                    options.put("doNotPrompt", "true");
                    if (LOG.isDebugEnabled()) {
                        options.put("debug", "true");
                    }
                    if (config.getKeytab() != null) {
                        options.put("keyTab", config.getKeytab().getAbsolutePath());
                    }
                    options.put("isInitiator", "false");
                    options.put("useKeyTab", "true");
                    options.put("principal", servicePrincipal);
                    options.put("storeKey", "true");
                    return new AppConfigurationEntry[]{new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
                }
            });
            this.loginContext.login();
            this.serverCredential = SpnegoFilter.doAs(this.loginContext.getSubject(), () -> this.gssManager.createCredential(this.gssManager.createName(config.getServiceName() + "@" + hostname, GSSName.NT_HOSTBASED_SERVICE), Integer.MAX_VALUE, new Oid[]{new Oid("1.2.840.113554.1.2.2"), new Oid("1.3.6.1.5.5.2")}, 2));
        }
        catch (UnknownHostException | LoginException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @PreDestroy
    public void shutdown() {
        try {
            this.loginContext.logout();
        }
        catch (LoginException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain nextFilter) throws IOException, ServletException {
        String[] parts;
        if (!servletRequest.isSecure()) {
            nextFilter.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String header = request.getHeader("Authorization");
        boolean includeRealm = "true".equalsIgnoreCase(request.getHeader(INCLUDE_REALM_HEADER));
        String requestSpnegoToken = null;
        if (header != null && (parts = header.split("\\s+")).length == 2 && parts[0].equals(NEGOTIATE_SCHEME)) {
            try {
                requestSpnegoToken = parts[1];
                final Optional<Result> authentication = this.authenticate(parts[1]);
                if (authentication.isPresent()) {
                    authentication.get().getToken().ifPresent(token -> response.setHeader("WWW-Authenticate", SpnegoFilter.formatAuthenticationHeader(includeRealm, Optional.of(token))));
                    nextFilter.doFilter((ServletRequest)new HttpServletRequestWrapper(request){

                        public Principal getUserPrincipal() {
                            return ((Result)authentication.get()).getPrincipal();
                        }
                    }, servletResponse);
                    return;
                }
            }
            catch (RuntimeException | GSSException e) {
                throw new RuntimeException("Authentication error for token: " + parts[1], e);
            }
        }
        SpnegoFilter.sendChallenge(request, response, includeRealm, requestSpnegoToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Result> authenticate(String token) throws GSSException {
        GSSContext context = SpnegoFilter.doAs(this.loginContext.getSubject(), () -> this.gssManager.createContext(this.serverCredential));
        try {
            byte[] inputToken = Base64.getDecoder().decode(token);
            byte[] outputToken = context.acceptSecContext(inputToken, 0, inputToken.length);
            if (context.isEstablished()) {
                Optional<Result> optional = Optional.of(new Result(Optional.ofNullable(outputToken), new KerberosPrincipal(context.getSrcName().toString())));
                return optional;
            }
            LOG.debug("Failed to establish GSS context for token %s", new Object[]{token});
        }
        catch (GSSException e) {
            LOG.debug((Throwable)e, "Authentication failed for token %s", new Object[]{token});
        }
        finally {
            try {
                context.dispose();
            }
            catch (GSSException gSSException) {}
        }
        return Optional.empty();
    }

    private static void sendChallenge(HttpServletRequest request, HttpServletResponse response, boolean includeRealm, String invalidSpnegoToken) throws IOException {
        SpnegoFilter.skipRequestBody(request);
        if (invalidSpnegoToken != null) {
            response.sendError(401, String.format("Authentication failed for token %s", invalidSpnegoToken));
        } else {
            response.setStatus(401);
        }
        response.setHeader("WWW-Authenticate", SpnegoFilter.formatAuthenticationHeader(includeRealm, Optional.empty()));
    }

    private static void skipRequestBody(HttpServletRequest request) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            ByteStreams.copy((InputStream)inputStream, (OutputStream)ByteStreams.nullOutputStream());
        }
    }

    private static String formatAuthenticationHeader(boolean includeRealm, Optional<byte[]> token) {
        StringBuilder header = new StringBuilder(NEGOTIATE_SCHEME);
        if (includeRealm) {
            header.append(" realm=\"presto\"");
        }
        token.ifPresent(bytes -> header.append(" ").append(Base64.getEncoder().encodeToString((byte[])bytes)));
        return header.toString();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private static <T> T doAs(Subject subject, GssSupplier<T> action) {
        return (T)Subject.doAs(subject, () -> {
            try {
                return action.get();
            }
            catch (GSSException e) {
                throw Throwables.propagate((Throwable)e);
            }
        });
    }

    private static class Result {
        private final Optional<byte[]> token;
        private final KerberosPrincipal principal;

        public Result(Optional<byte[]> token, KerberosPrincipal principal) {
            this.token = token;
            this.principal = principal;
        }

        public Optional<byte[]> getToken() {
            return this.token;
        }

        public KerberosPrincipal getPrincipal() {
            return this.principal;
        }
    }

    private static interface GssSupplier<T> {
        public T get() throws GSSException;
    }
}

