/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.client.ClientTypeSignature;
import com.facebook.presto.client.Column;
import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StageStats;
import com.facebook.presto.client.StatementStats;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.buffer.PagesSerde;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.execution.buffer.SerializedPage;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.server.ForStatementResource;
import com.facebook.presto.server.HttpRequestSessionContext;
import com.facebook.presto.server.SessionContext;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.http.server.AsyncResponseHandler;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/statement")
public class StatementResource {
    private static final Logger log = Logger.get(StatementResource.class);
    private static final Duration MAX_WAIT_TIME = new Duration(1.0, TimeUnit.SECONDS);
    private static final Ordering<Comparable<Duration>> WAIT_ORDERING = Ordering.natural().nullsLast();
    private static final long DESIRED_RESULT_BYTES = new DataSize(1.0, DataSize.Unit.MEGABYTE).toBytes();
    private final QueryManager queryManager;
    private final SessionPropertyManager sessionPropertyManager;
    private final ExchangeClientSupplier exchangeClientSupplier;
    private final BlockEncodingSerde blockEncodingSerde;
    private final BoundedExecutor responseExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    private final ConcurrentMap<QueryId, Query> queries = new ConcurrentHashMap<QueryId, Query>();
    private final ScheduledExecutorService queryPurger = Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"query-purger"));

    @Inject
    public StatementResource(QueryManager queryManager, SessionPropertyManager sessionPropertyManager, ExchangeClientSupplier exchangeClientSupplier, BlockEncodingSerde blockEncodingSerde, @ForStatementResource BoundedExecutor responseExecutor, @ForStatementResource ScheduledExecutorService timeoutExecutor) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.exchangeClientSupplier = Objects.requireNonNull(exchangeClientSupplier, "exchangeClientSupplier is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.responseExecutor = Objects.requireNonNull(responseExecutor, "responseExecutor is null");
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
        this.queryPurger.scheduleWithFixedDelay(new PurgeQueriesRunnable(this.queries, queryManager), 200L, 200L, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void stop() {
        this.queryPurger.shutdownNow();
    }

    @POST
    @Produces(value={"application/json"})
    public void createQuery(String statement, @Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @Suspended AsyncResponse asyncResponse) throws InterruptedException {
        if (Strings.isNullOrEmpty((String)statement)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"SQL statement is empty").build());
        }
        HttpRequestSessionContext sessionContext = new HttpRequestSessionContext(servletRequest);
        ExchangeClient exchangeClient = this.exchangeClientSupplier.get(deltaMemoryInBytes -> {});
        Query query = Query.create(sessionContext, statement, this.queryManager, this.sessionPropertyManager, exchangeClient, (Executor)this.responseExecutor, this.timeoutExecutor, this.blockEncodingSerde);
        this.queries.put(query.getQueryId(), query);
        this.asyncQueryResults(query, OptionalLong.empty(), new Duration(1.0, TimeUnit.MILLISECONDS), uriInfo, asyncResponse);
    }

    @GET
    @Path(value="{queryId}/{token}")
    @Produces(value={"application/json"})
    public void getQueryResults(@PathParam(value="queryId") QueryId queryId, @PathParam(value="token") long token, @QueryParam(value="maxWait") Duration maxWait, @Context UriInfo uriInfo, @Suspended AsyncResponse asyncResponse) throws InterruptedException {
        Query query = (Query)this.queries.get(queryId);
        if (query == null) {
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            return;
        }
        this.asyncQueryResults(query, OptionalLong.of(token), maxWait, uriInfo, asyncResponse);
    }

    private void asyncQueryResults(Query query, OptionalLong token, Duration maxWait, UriInfo uriInfo, AsyncResponse asyncResponse) {
        Duration wait = (Duration)WAIT_ORDERING.min((Object)MAX_WAIT_TIME, (Object)maxWait);
        ListenableFuture<QueryResults> queryResultsFuture = query.waitForResults(token, uriInfo, wait);
        ListenableFuture response = Futures.transform(queryResultsFuture, queryResults -> StatementResource.toResponse(query, queryResults));
        AsyncResponseHandler.bindAsyncResponse((AsyncResponse)asyncResponse, (ListenableFuture)response, (Executor)this.responseExecutor);
    }

    private static Response toResponse(Query query, QueryResults queryResults) {
        Response.ResponseBuilder response = Response.ok((Object)queryResults);
        query.getSetSessionProperties().entrySet().forEach(entry -> response.header("X-Presto-Set-Session", (Object)((String)entry.getKey() + '=' + (String)entry.getValue())));
        query.getResetSessionProperties().forEach(name -> response.header("X-Presto-Clear-Session", name));
        for (Map.Entry<String, String> entry2 : query.getAddedPreparedStatements().entrySet()) {
            String encodedKey = StatementResource.urlEncode(entry2.getKey());
            String encodedValue = StatementResource.urlEncode(entry2.getValue());
            response.header("X-Presto-Added-Prepare", (Object)(encodedKey + '=' + encodedValue));
        }
        for (String name2 : query.getDeallocatedPreparedStatements()) {
            response.header("X-Presto-Deallocated-Prepare", (Object)StatementResource.urlEncode(name2));
        }
        query.getStartedTransactionId().ifPresent(transactionId -> response.header("X-Presto-Started-Transaction-Id", transactionId));
        if (query.isClearTransactionId()) {
            response.header("X-Presto-Clear-Transaction-Id", (Object)true);
        }
        return response.build();
    }

    @DELETE
    @Path(value="{queryId}/{token}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="queryId") QueryId queryId, @PathParam(value="token") long token) {
        Query query = (Query)this.queries.get(queryId);
        if (query == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        query.cancel();
        return Response.noContent().build();
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class PurgeQueriesRunnable
    implements Runnable {
        private final ConcurrentMap<QueryId, Query> queries;
        private final QueryManager queryManager;

        public PurgeQueriesRunnable(ConcurrentMap<QueryId, Query> queries, QueryManager queryManager) {
            this.queries = queries;
            this.queryManager = queryManager;
        }

        @Override
        public void run() {
            try {
                for (QueryId queryId : ImmutableSet.copyOf(this.queries.keySet())) {
                    Query query = (Query)this.queries.get(queryId);
                    Optional<QueryState> state = this.queryManager.getQueryState(queryId);
                    if (!state.isPresent() || state.get() == QueryState.FAILED) {
                        query.dispose();
                    }
                    if (state.isPresent()) continue;
                    this.queries.remove(queryId);
                }
            }
            catch (Throwable e) {
                log.warn(e, "Error removing old queries");
            }
        }
    }

    @ThreadSafe
    public static class Query {
        private final QueryManager queryManager;
        private final QueryId queryId;
        @GuardedBy(value="this")
        private final ExchangeClient exchangeClient;
        private final Executor resultsProcessorExecutor;
        private final ScheduledExecutorService timeoutExecutor;
        @GuardedBy(value="this")
        private final PagesSerde serde;
        private final AtomicLong resultId = new AtomicLong();
        private final Session session;
        @GuardedBy(value="this")
        private QueryResults lastResult;
        @GuardedBy(value="this")
        private String lastResultPath;
        @GuardedBy(value="this")
        private List<Column> columns;
        @GuardedBy(value="this")
        private List<Type> types;
        @GuardedBy(value="this")
        private Map<String, String> setSessionProperties;
        @GuardedBy(value="this")
        private Set<String> resetSessionProperties;
        @GuardedBy(value="this")
        private Map<String, String> addedPreparedStatements;
        @GuardedBy(value="this")
        private Set<String> deallocatedPreparedStatements;
        @GuardedBy(value="this")
        private Optional<TransactionId> startedTransactionId;
        @GuardedBy(value="this")
        private boolean clearTransactionId;
        @GuardedBy(value="this")
        private Long updateCount;

        public static Query create(SessionContext sessionContext, String query, QueryManager queryManager, SessionPropertyManager sessionPropertyManager, ExchangeClient exchangeClient, Executor dataProcessorExecutor, ScheduledExecutorService timeoutExecutor, BlockEncodingSerde blockEncodingSerde) {
            Query result = new Query(sessionContext, query, queryManager, sessionPropertyManager, exchangeClient, dataProcessorExecutor, timeoutExecutor, blockEncodingSerde);
            result.updateOutputInfoWhenReady();
            return result;
        }

        private Query(SessionContext sessionContext, String query, QueryManager queryManager, SessionPropertyManager sessionPropertyManager, ExchangeClient exchangeClient, Executor resultsProcessorExecutor, ScheduledExecutorService timeoutExecutor, BlockEncodingSerde blockEncodingSerde) {
            Objects.requireNonNull(sessionContext, "sessionContext is null");
            Objects.requireNonNull(query, "query is null");
            Objects.requireNonNull(queryManager, "queryManager is null");
            Objects.requireNonNull(exchangeClient, "exchangeClient is null");
            Objects.requireNonNull(resultsProcessorExecutor, "resultsProcessorExecutor is null");
            Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
            this.queryManager = queryManager;
            QueryInfo queryInfo = queryManager.createQuery(sessionContext, query);
            this.queryId = queryInfo.getQueryId();
            this.session = queryInfo.getSession().toSession(sessionPropertyManager);
            this.exchangeClient = exchangeClient;
            this.resultsProcessorExecutor = resultsProcessorExecutor;
            this.timeoutExecutor = timeoutExecutor;
            Objects.requireNonNull(blockEncodingSerde, "serde is null");
            this.serde = new PagesSerdeFactory(blockEncodingSerde, SystemSessionProperties.isExchangeCompressionEnabled(this.session)).createPagesSerde();
        }

        private void updateOutputInfoWhenReady() {
            ListenableFuture<QueryExecution.QueryOutputInfo> outputLocationsFuture = this.queryManager.getOutputInfo(this.queryId);
            Futures.addCallback(outputLocationsFuture, (FutureCallback)new FutureCallback<QueryExecution.QueryOutputInfo>(){

                public void onSuccess(QueryExecution.QueryOutputInfo outputInfo) {
                    this.setQueryOutputInfo(outputInfo);
                }

                public void onFailure(Throwable t) {
                }
            });
        }

        public void cancel() {
            this.queryManager.cancelQuery(this.queryId);
            this.dispose();
        }

        public synchronized void dispose() {
            this.exchangeClient.close();
        }

        public QueryId getQueryId() {
            return this.queryId;
        }

        public synchronized Map<String, String> getSetSessionProperties() {
            return this.setSessionProperties;
        }

        public synchronized Set<String> getResetSessionProperties() {
            return this.resetSessionProperties;
        }

        public synchronized Map<String, String> getAddedPreparedStatements() {
            return this.addedPreparedStatements;
        }

        public synchronized Set<String> getDeallocatedPreparedStatements() {
            return this.deallocatedPreparedStatements;
        }

        public synchronized Optional<TransactionId> getStartedTransactionId() {
            return this.startedTransactionId;
        }

        public synchronized boolean isClearTransactionId() {
            return this.clearTransactionId;
        }

        public synchronized ListenableFuture<QueryResults> waitForResults(OptionalLong token, UriInfo uriInfo, Duration wait) {
            Optional<QueryResults> cachedResult;
            if (token.isPresent() && (cachedResult = this.getCachedResult(token.getAsLong(), uriInfo)).isPresent()) {
                return Futures.immediateFuture((Object)cachedResult.get());
            }
            ListenableFuture futureStateChange = MoreFutures.addTimeout(this.getFutureStateChange(), () -> null, (Duration)wait, (ScheduledExecutorService)this.timeoutExecutor);
            return Futures.transform((ListenableFuture)futureStateChange, ignored -> this.getNextResult(token, uriInfo), (Executor)this.resultsProcessorExecutor);
        }

        private synchronized ListenableFuture<?> getFutureStateChange() {
            if (!this.exchangeClient.isClosed()) {
                return this.exchangeClient.isBlocked();
            }
            this.queryManager.recordHeartbeat(this.queryId);
            return this.queryManager.getQueryState(this.queryId).map(this::queryDoneFuture).orElse(Futures.immediateFuture(null));
        }

        private synchronized Optional<QueryResults> getCachedResult(long token, UriInfo uriInfo) {
            String requestedPath = uriInfo.getAbsolutePath().getPath();
            if (this.lastResultPath != null && requestedPath.equals(this.lastResultPath)) {
                this.queryManager.getQueryInfo(this.queryId);
                this.queryManager.recordHeartbeat(this.queryId);
                return Optional.of(this.lastResult);
            }
            if (token < this.resultId.get()) {
                throw new WebApplicationException(Response.Status.GONE);
            }
            if (this.lastResult.getNextUri() == null || !requestedPath.equals(this.lastResult.getNextUri().getPath())) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            return Optional.empty();
        }

        private synchronized QueryResults getNextResult(OptionalLong token, UriInfo uriInfo) {
            Number number;
            Iterator iterator;
            SerializedPage serializedPage;
            Optional<QueryResults> cachedResult;
            if (token.isPresent() && (cachedResult = this.getCachedResult(token.getAsLong(), uriInfo)).isPresent()) {
                return cachedResult.get();
            }
            ImmutableList.Builder pages = ImmutableList.builder();
            long bytes = 0L;
            long rows = 0L;
            while (bytes < DESIRED_RESULT_BYTES && (serializedPage = this.exchangeClient.pollPage()) != null) {
                Page page = this.serde.deserialize(serializedPage);
                bytes += page.getSizeInBytes();
                rows += (long)page.getPositionCount();
                pages.add((Object)new RowIterable(this.session.toConnectorSession(), this.types, page));
            }
            Iterable data = rows == 0L ? null : Iterables.concat((Iterable)pages.build());
            QueryInfo queryInfo = this.queryManager.getQueryInfo(this.queryId);
            this.queryManager.recordHeartbeat(this.queryId);
            if (data != null && queryInfo.getUpdateType() != null && this.updateCount == null && this.columns.size() == 1 && this.columns.get(0).getType().equals("bigint") && (iterator = data.iterator()).hasNext() && (number = (Number)((List)iterator.next()).get(0)) != null) {
                this.updateCount = number.longValue();
            }
            if (queryInfo.getState().isDone()) {
                if (queryInfo.getState() == QueryState.FAILED) {
                    this.exchangeClient.close();
                } else if (!queryInfo.getOutputStage().isPresent()) {
                    this.exchangeClient.close();
                    this.columns = ImmutableList.of((Object)new Column("result", "boolean", new ClientTypeSignature("boolean", (List)ImmutableList.of())));
                    data = ImmutableSet.of((Object)ImmutableList.of((Object)true));
                }
            }
            URI nextResultsUri = null;
            if (!queryInfo.isFinalQueryInfo() || !this.exchangeClient.isClosed()) {
                nextResultsUri = this.createNextResultsUri(uriInfo);
            }
            this.setSessionProperties = queryInfo.getSetSessionProperties();
            this.resetSessionProperties = queryInfo.getResetSessionProperties();
            this.addedPreparedStatements = queryInfo.getAddedPreparedStatements();
            this.deallocatedPreparedStatements = queryInfo.getDeallocatedPreparedStatements();
            this.startedTransactionId = queryInfo.getStartedTransactionId();
            this.clearTransactionId = queryInfo.isClearTransactionId();
            QueryResults queryResults = new QueryResults(this.queryId.toString(), uriInfo.getRequestUriBuilder().replaceQuery(this.queryId.toString()).replacePath("query.html").build(new Object[0]), Query.findCancelableLeafStage(queryInfo), nextResultsUri, this.columns, data, Query.toStatementStats(queryInfo), Query.toQueryError(queryInfo), queryInfo.getUpdateType(), this.updateCount);
            this.lastResultPath = this.lastResult != null && this.lastResult.getNextUri() != null ? this.lastResult.getNextUri().getPath() : null;
            this.lastResult = queryResults;
            return queryResults;
        }

        private synchronized void setQueryOutputInfo(QueryExecution.QueryOutputInfo outputInfo) {
            if (this.columns != null) {
                return;
            }
            List<String> columnNames = outputInfo.getColumnNames();
            List<Type> columnTypes = outputInfo.getColumnTypes();
            Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"Column names and types size mismatch");
            ImmutableList.Builder list = ImmutableList.builder();
            for (int i = 0; i < columnNames.size(); ++i) {
                String name = columnNames.get(i);
                TypeSignature typeSignature = columnTypes.get(i).getTypeSignature();
                String type = typeSignature.toString();
                list.add((Object)new Column(name, type, new ClientTypeSignature(typeSignature)));
            }
            this.columns = list.build();
            this.types = outputInfo.getColumnTypes();
            for (URI outputLocation : outputInfo.getBufferLocations().values()) {
                this.exchangeClient.addLocation(outputLocation);
            }
            this.exchangeClient.noMoreLocations();
        }

        private ListenableFuture<?> queryDoneFuture(QueryState currentState) {
            if (currentState.isDone()) {
                return Futures.immediateFuture(null);
            }
            return Futures.transformAsync(this.queryManager.getStateChange(this.queryId, currentState), this::queryDoneFuture);
        }

        private synchronized URI createNextResultsUri(UriInfo uriInfo) {
            return uriInfo.getBaseUriBuilder().replacePath("/v1/statement").path(this.queryId.toString()).path(String.valueOf(this.resultId.incrementAndGet())).replaceQuery("").build(new Object[0]);
        }

        private static StatementStats toStatementStats(QueryInfo queryInfo) {
            QueryStats queryStats = queryInfo.getQueryStats();
            StageInfo outputStage = queryInfo.getOutputStage().orElse(null);
            return StatementStats.builder().setState(queryInfo.getState().toString()).setQueued(queryInfo.getState() == QueryState.QUEUED).setScheduled(queryInfo.isScheduled()).setNodes(Query.globalUniqueNodes(outputStage).size()).setTotalSplits(queryStats.getTotalDrivers()).setQueuedSplits(queryStats.getQueuedDrivers()).setRunningSplits(queryStats.getRunningDrivers() + queryStats.getBlockedDrivers()).setCompletedSplits(queryStats.getCompletedDrivers()).setUserTimeMillis(queryStats.getTotalUserTime().toMillis()).setCpuTimeMillis(queryStats.getTotalCpuTime().toMillis()).setWallTimeMillis(queryStats.getTotalScheduledTime().toMillis()).setQueuedTimeMillis(queryStats.getQueuedTime().toMillis()).setElapsedTimeMillis(queryStats.getElapsedTime().toMillis()).setProcessedRows(queryStats.getRawInputPositions()).setProcessedBytes(queryStats.getRawInputDataSize().toBytes()).setRootStage(Query.toStageStats(outputStage)).build();
        }

        private static StageStats toStageStats(StageInfo stageInfo) {
            if (stageInfo == null) {
                return null;
            }
            com.facebook.presto.execution.StageStats stageStats = stageInfo.getStageStats();
            ImmutableList.Builder subStages = ImmutableList.builder();
            for (StageInfo subStage : stageInfo.getSubStages()) {
                subStages.add((Object)Query.toStageStats(subStage));
            }
            HashSet<String> uniqueNodes = new HashSet<String>();
            for (TaskInfo task : stageInfo.getTasks()) {
                URI uri = task.getTaskStatus().getSelf();
                uniqueNodes.add(uri.getHost() + ":" + uri.getPort());
            }
            return StageStats.builder().setStageId(String.valueOf(stageInfo.getStageId().getId())).setState(stageInfo.getState().toString()).setDone(stageInfo.getState().isDone()).setNodes(uniqueNodes.size()).setTotalSplits(stageStats.getTotalDrivers()).setQueuedSplits(stageStats.getQueuedDrivers()).setRunningSplits(stageStats.getRunningDrivers() + stageStats.getBlockedDrivers()).setCompletedSplits(stageStats.getCompletedDrivers()).setUserTimeMillis(stageStats.getTotalUserTime().toMillis()).setCpuTimeMillis(stageStats.getTotalCpuTime().toMillis()).setWallTimeMillis(stageStats.getTotalScheduledTime().toMillis()).setProcessedRows(stageStats.getRawInputPositions()).setProcessedBytes(stageStats.getRawInputDataSize().toBytes()).setSubStages((List)subStages.build()).build();
        }

        private static Set<String> globalUniqueNodes(StageInfo stageInfo) {
            if (stageInfo == null) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder nodes = ImmutableSet.builder();
            for (TaskInfo task : stageInfo.getTasks()) {
                URI uri = task.getTaskStatus().getSelf();
                nodes.add((Object)(uri.getHost() + ":" + uri.getPort()));
            }
            for (StageInfo subStage : stageInfo.getSubStages()) {
                nodes.addAll(Query.globalUniqueNodes(subStage));
            }
            return nodes.build();
        }

        private static URI findCancelableLeafStage(QueryInfo queryInfo) {
            return queryInfo.getOutputStage().map(Query::findCancelableLeafStage).orElse(null);
        }

        private static URI findCancelableLeafStage(StageInfo stage) {
            if (stage.getState().isDone()) {
                return null;
            }
            for (StageInfo subStage : Lists.reverse(stage.getSubStages())) {
                URI leafStage = Query.findCancelableLeafStage(subStage);
                if (leafStage == null) continue;
                return leafStage;
            }
            return stage.getSelf();
        }

        private static QueryError toQueryError(QueryInfo queryInfo) {
            ErrorCode errorCode;
            FailureInfo failure = queryInfo.getFailureInfo();
            if (failure == null) {
                QueryState state = queryInfo.getState();
                if (!state.isDone() || state == QueryState.FINISHED) {
                    return null;
                }
                log.warn("Query %s in state %s has no failure info", new Object[]{queryInfo.getQueryId(), state});
                failure = Failures.toFailure(new RuntimeException(String.format("Query is %s (reason unknown)", new Object[]{state}))).toFailureInfo();
            }
            if (queryInfo.getErrorCode() != null) {
                errorCode = queryInfo.getErrorCode();
            } else {
                errorCode = StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode();
                log.warn("Failed query %s has no error code", new Object[]{queryInfo.getQueryId()});
            }
            return new QueryError(failure.getMessage(), null, errorCode.getCode(), errorCode.getName(), errorCode.getType().toString(), failure.getErrorLocation(), failure);
        }

        private static class RowIterator
        extends AbstractIterator<List<Object>> {
            private final ConnectorSession session;
            private final List<Type> types;
            private final Page page;
            private int position = -1;

            private RowIterator(ConnectorSession session, List<Type> types, Page page) {
                this.session = session;
                this.types = types;
                this.page = page;
            }

            protected List<Object> computeNext() {
                ++this.position;
                if (this.position >= this.page.getPositionCount()) {
                    return (List)this.endOfData();
                }
                ArrayList<Object> values = new ArrayList<Object>(this.page.getChannelCount());
                for (int channel = 0; channel < this.page.getChannelCount(); ++channel) {
                    Type type = this.types.get(channel);
                    Block block = this.page.getBlock(channel);
                    values.add(type.getObjectValue(this.session, block, this.position));
                }
                return Collections.unmodifiableList(values);
            }
        }

        private static class RowIterable
        implements Iterable<List<Object>> {
            private final ConnectorSession session;
            private final List<Type> types;
            private final Page page;

            private RowIterable(ConnectorSession session, List<Type> types, Page page) {
                this.session = session;
                this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
                this.page = Objects.requireNonNull(page, "page is null");
            }

            @Override
            public Iterator<List<Object>> iterator() {
                return new RowIterator(this.session, this.types, this.page);
            }
        }
    }
}

