/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.server.QueryStateInfo;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupInfo;
import com.facebook.presto.spi.resourceGroups.ResourceGroupState;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ResourceGroupStateInfo {
    private final ResourceGroupId id;
    private final ResourceGroupState state;
    private final DataSize softMemoryLimit;
    private final DataSize memoryUsage;
    private final List<ResourceGroupInfo> subGroups;
    private final int softConcurrencyLimit;
    private final int hardConcurrencyLimit;
    private final int maxQueuedQueries;
    private final Duration runningTimeLimit;
    private final Duration queuedTimeLimit;
    private final List<QueryStateInfo> runningQueries;
    private final int numQueuedQueries;

    @JsonCreator
    public ResourceGroupStateInfo(@JsonProperty(value="id") ResourceGroupId id, @JsonProperty(value="state") ResourceGroupState state, @JsonProperty(value="softMemoryLimit") DataSize softMemoryLimit, @JsonProperty(value="memoryUsage") DataSize memoryUsage, @JsonProperty(value="softConcurrencyLimit") int softConcurrencyLimit, @JsonProperty(value="hardConcurrencyLimit") int hardConcurrencyLimit, @JsonProperty(value="maxQueuedQueries") int maxQueuedQueries, @JsonProperty(value="runningTimeLimit") Duration runningTimeLimit, @JsonProperty(value="queuedTimeLimit") Duration queuedTimeLimit, @JsonProperty(value="runningQueries") List<QueryStateInfo> runningQueries, @JsonProperty(value="numQueuedQueries") int numQueuedQueries, @JsonProperty(value="subGroups") List<ResourceGroupInfo> subGroups) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.state = Objects.requireNonNull(state, "state is null");
        this.softMemoryLimit = Objects.requireNonNull(softMemoryLimit, "softMemoryLimit is null");
        this.memoryUsage = Objects.requireNonNull(memoryUsage, "memoryUsage is null");
        this.softConcurrencyLimit = softConcurrencyLimit;
        this.hardConcurrencyLimit = hardConcurrencyLimit;
        this.maxQueuedQueries = maxQueuedQueries;
        this.runningTimeLimit = Objects.requireNonNull(runningTimeLimit, "runningTimeLimit is null");
        this.queuedTimeLimit = Objects.requireNonNull(queuedTimeLimit, "queuedTimeLimit is null");
        this.runningQueries = ImmutableList.copyOf((Collection)Objects.requireNonNull(runningQueries, "runningQueries is null"));
        this.numQueuedQueries = numQueuedQueries;
        this.subGroups = ImmutableList.copyOf((Collection)Objects.requireNonNull(subGroups, "subGroups is null"));
    }

    @JsonProperty
    public ResourceGroupId getId() {
        return this.id;
    }

    @JsonProperty
    public ResourceGroupState getState() {
        return this.state;
    }

    @JsonProperty
    public DataSize getSoftMemoryLimit() {
        return this.softMemoryLimit;
    }

    @JsonProperty
    public DataSize getMemoryUsage() {
        return this.memoryUsage;
    }

    @JsonProperty
    public int getSoftConcurrencyLimit() {
        return this.softConcurrencyLimit;
    }

    @JsonProperty
    public int getHardConcurrencyLimit() {
        return this.hardConcurrencyLimit;
    }

    @JsonProperty
    @Deprecated
    public int getMaxRunningQueries() {
        return this.hardConcurrencyLimit;
    }

    @JsonProperty
    public int getMaxQueuedQueries() {
        return this.maxQueuedQueries;
    }

    @JsonProperty
    public Duration getQueuedTimeLimit() {
        return this.queuedTimeLimit;
    }

    @JsonProperty
    public Duration getRunningTimeLimit() {
        return this.runningTimeLimit;
    }

    @JsonProperty
    public List<QueryStateInfo> getRunningQueries() {
        return this.runningQueries;
    }

    @JsonProperty
    public int getNumQueuedQueries() {
        return this.numQueuedQueries;
    }

    @JsonProperty
    public List<ResourceGroupInfo> getSubGroups() {
        return this.subGroups;
    }
}

