/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.QueryId;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="/v1/query")
public class QueryResource {
    private final QueryManager queryManager;

    @Inject
    public QueryResource(QueryManager queryManager) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
    }

    @GET
    public List<BasicQueryInfo> getAllQueryInfo() {
        return QueryResource.extractBasicQueryInfo(this.queryManager.getAllQueryInfo());
    }

    private static List<BasicQueryInfo> extractBasicQueryInfo(List<QueryInfo> allQueryInfo) {
        ImmutableList.Builder basicQueryInfo = ImmutableList.builder();
        for (QueryInfo queryInfo : allQueryInfo) {
            basicQueryInfo.add((Object)new BasicQueryInfo(queryInfo));
        }
        return basicQueryInfo.build();
    }

    @GET
    @Path(value="{queryId}")
    public Response getQueryInfo(@PathParam(value="queryId") QueryId queryId) {
        Objects.requireNonNull(queryId, "queryId is null");
        try {
            QueryInfo queryInfo = this.queryManager.getQueryInfo(queryId);
            return Response.ok((Object)queryInfo).build();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
    }

    @DELETE
    @Path(value="{queryId}")
    public void cancelQuery(@PathParam(value="queryId") QueryId queryId) {
        Objects.requireNonNull(queryId, "queryId is null");
        this.queryManager.cancelQuery(queryId);
    }

    @DELETE
    @Path(value="stage/{stageId}")
    public void cancelStage(@PathParam(value="stageId") StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        this.queryManager.cancelStage(stageId);
    }
}

