/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.server.CodeCacheGcConfig;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

final class CodeCacheGcTrigger {
    private static final Logger log = Logger.get(CodeCacheGcTrigger.class);
    private static final AtomicBoolean installed = new AtomicBoolean();
    private final Duration interval;
    private final int collectionThreshold;

    @Inject
    public CodeCacheGcTrigger(CodeCacheGcConfig config) {
        this.interval = config.getCodeCacheCheckInterval();
        this.collectionThreshold = config.getCodeCacheCollectionThreshold();
    }

    @PostConstruct
    public void start() {
        this.installCodeCacheGcTrigger();
    }

    public void installCodeCacheGcTrigger() {
        if (installed.getAndSet(true)) {
            return;
        }
        MemoryPoolMXBean codeCacheMbean = CodeCacheGcTrigger.findCodeCacheMBean();
        Thread gcThread = new Thread(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                long max;
                long used = codeCacheMbean.getUsage().getUsed();
                if ((double)used > 0.95 * (double)(max = codeCacheMbean.getUsage().getMax())) {
                    log.error("Code Cache is more than 95% full. JIT may stop working.");
                }
                if (used > max * (long)this.collectionThreshold / 100L) {
                    log.info("Triggering GC to avoid Code Cache eviction bugs");
                    System.gc();
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(this.interval.toMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        gcThread.setDaemon(true);
        gcThread.setName("Code-Cache-GC-Trigger");
        gcThread.start();
    }

    private static MemoryPoolMXBean findCodeCacheMBean() {
        for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!bean.getName().equals("Code Cache")) continue;
            return bean;
        }
        throw new RuntimeException("Could not obtain a reference to the 'Code Cache' MemoryPoolMXBean");
    }
}

