/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class CodeCacheGcConfig {
    private Duration codeCacheCheckInterval = new Duration(20.0, TimeUnit.SECONDS);
    private int codeCacheCollectionThreshold = 70;

    @NotNull
    @MinDuration(value="1s")
    public Duration getCodeCacheCheckInterval() {
        return this.codeCacheCheckInterval;
    }

    @Config(value="code-cache-check-interval")
    @ConfigDescription(value="How often to check if the code cache need to be collected")
    public CodeCacheGcConfig setCodeCacheCheckInterval(Duration codeCacheCheckInterval) {
        this.codeCacheCheckInterval = codeCacheCheckInterval;
        return this;
    }

    @Min(value=1L)
    @Max(value=100L)
    public int getCodeCacheCollectionThreshold() {
        return this.codeCacheCollectionThreshold;
    }

    @Config(value="code-cache-collection-threshold")
    @ConfigDescription(value="Maximum code cache usage (percentage) before attempting to force a collection")
    public CodeCacheGcConfig setCodeCacheCollectionThreshold(int codeCacheCollectionThreshold) {
        this.codeCacheCollectionThreshold = codeCacheCollectionThreshold;
        return this;
    }
}

