/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.annotations;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.ParametricFunctionHelpers;
import com.facebook.presto.operator.ParametricImplementation;
import com.facebook.presto.operator.annotations.FunctionsParserHelper;
import com.facebook.presto.operator.annotations.ImplementationDependency;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class ScalarImplementation
implements ParametricImplementation {
    private final Signature signature;
    private final boolean nullable;
    private final List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties;
    private final MethodHandle methodHandle;
    private final List<ImplementationDependency> dependencies;
    private final Optional<MethodHandle> constructor;
    private final List<ImplementationDependency> constructorDependencies;
    private final List<Class<?>> argumentNativeContainerTypes;
    private final Map<String, Class<?>> specializedTypeParameters;

    public ScalarImplementation(Signature signature, boolean nullable, List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties, MethodHandle methodHandle, List<ImplementationDependency> dependencies, Optional<MethodHandle> constructor, List<ImplementationDependency> constructorDependencies, List<Class<?>> argumentNativeContainerTypes, Map<String, Class<?>> specializedTypeParameters) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.nullable = nullable;
        this.argumentProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentProperties, "argumentProperties is null"));
        this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
        this.dependencies = ImmutableList.copyOf((Collection)Objects.requireNonNull(dependencies, "dependencies is null"));
        this.constructor = Objects.requireNonNull(constructor, "constructor is null");
        this.constructorDependencies = ImmutableList.copyOf((Collection)Objects.requireNonNull(constructorDependencies, "constructorDependencies is null"));
        this.argumentNativeContainerTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentNativeContainerTypes, "argumentNativeContainerTypes is null"));
        this.specializedTypeParameters = ImmutableMap.copyOf(Objects.requireNonNull(specializedTypeParameters, "specializedTypeParameters is null"));
    }

    public Optional<MethodHandleAndConstructor> specialize(Signature boundSignature, BoundVariables boundVariables, TypeManager typeManager, FunctionRegistry functionRegistry) {
        for (Map.Entry<String, Class<?>> entry : this.specializedTypeParameters.entrySet()) {
            if (entry.getValue().isAssignableFrom(boundVariables.getTypeVariable(entry.getKey()).getJavaType())) continue;
            return Optional.empty();
        }
        Class<?> returnContainerType = ScalarImplementation.getNullAwareReturnType(typeManager.getType(boundSignature.getReturnType()).getJavaType(), this.nullable);
        if (!returnContainerType.equals(this.methodHandle.type().returnType())) {
            return Optional.empty();
        }
        for (int i = 0; i < boundSignature.getArgumentTypes().size(); ++i) {
            ScalarFunctionImplementation.ArgumentProperty argumentProperty = this.argumentProperties.get(i);
            if (boundSignature.getArgumentTypes().get(i).getBase().equals("function")) {
                if (argumentProperty.getArgumentType() == ScalarFunctionImplementation.ArgumentType.FUNCTION_TYPE) continue;
                return Optional.empty();
            }
            if (argumentProperty.getArgumentType() != ScalarFunctionImplementation.ArgumentType.VALUE_TYPE) {
                return Optional.empty();
            }
            Class argumentType = typeManager.getType(boundSignature.getArgumentTypes().get(i)).getJavaType();
            Class<?> argumentContainerType = ScalarImplementation.getNullAwareContainerType(argumentType, argumentProperty.getNullConvention());
            if (this.argumentNativeContainerTypes.get(i).isAssignableFrom(argumentContainerType)) continue;
            return Optional.empty();
        }
        MethodHandle boundMethodHandle = ParametricFunctionHelpers.bindDependencies(this.methodHandle, this.dependencies, boundVariables, typeManager, functionRegistry);
        Optional<MethodHandle> boundConstructor = this.constructor.map(handle -> ParametricFunctionHelpers.bindDependencies(handle, this.constructorDependencies, boundVariables, typeManager, functionRegistry));
        return Optional.of(new MethodHandleAndConstructor(boundMethodHandle, boundConstructor));
    }

    private static Class<?> getNullAwareReturnType(Class<?> clazz, boolean nullable) {
        if (nullable) {
            return Primitives.wrap(clazz);
        }
        return clazz;
    }

    private static Class<?> getNullAwareContainerType(Class<?> clazz, ScalarFunctionImplementation.NullConvention nullConvention) {
        if (clazz == Void.TYPE) {
            return Primitives.wrap(clazz);
        }
        if (nullConvention == ScalarFunctionImplementation.NullConvention.USE_BOXED_TYPE) {
            return Primitives.wrap(clazz);
        }
        return clazz;
    }

    @Override
    public boolean hasSpecializedTypeParameters() {
        return !this.specializedTypeParameters.isEmpty();
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public List<ScalarFunctionImplementation.ArgumentProperty> getArgumentProperties() {
        return this.argumentProperties;
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    public List<ImplementationDependency> getDependencies() {
        return this.dependencies;
    }

    @VisibleForTesting
    public List<ImplementationDependency> getConstructorDependencies() {
        return this.constructorDependencies;
    }

    public static final class Parser {
        private final String functionName;
        private final boolean nullable;
        private final List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties = new ArrayList<ScalarFunctionImplementation.ArgumentProperty>();
        private final TypeSignature returnType;
        private final List<TypeSignature> argumentTypes = new ArrayList<TypeSignature>();
        private final List<Class<?>> argumentNativeContainerTypes = new ArrayList();
        private final MethodHandle methodHandle;
        private final List<ImplementationDependency> dependencies = new ArrayList<ImplementationDependency>();
        private final Set<TypeParameter> typeParameters = new LinkedHashSet<TypeParameter>();
        private final Set<String> literalParameters;
        private final ImmutableSet<String> typeParameterNames;
        private final Map<String, Class<?>> specializedTypeParameters;
        private final Optional<MethodHandle> constructorMethodHandle;
        private final List<ImplementationDependency> constructorDependencies = new ArrayList<ImplementationDependency>();
        private final List<LongVariableConstraint> longVariableConstraints;

        private Parser(String functionName, Method method, Map<Set<TypeParameter>, Constructor<?>> constructors) {
            this.functionName = Objects.requireNonNull(functionName, "functionName is null");
            this.nullable = method.getAnnotation(SqlNullable.class) != null;
            Preconditions.checkArgument((this.nullable || !FunctionsParserHelper.containsLegacyNullable(method.getAnnotations()) ? 1 : 0) != 0, (String)"Method [%s] is annotated with @Nullable but not @SqlNullable", (Object)method);
            Stream.of(method.getAnnotationsByType(TypeParameter.class)).forEach(this.typeParameters::add);
            this.literalParameters = FunctionsParserHelper.parseLiteralParameters(method);
            this.typeParameterNames = (ImmutableSet)this.typeParameters.stream().map(TypeParameter::value).collect(ImmutableSet.toImmutableSet());
            SqlType returnType = method.getAnnotation(SqlType.class);
            Preconditions.checkArgument((returnType != null ? 1 : 0) != 0, (Object)String.format("Method [%s] is missing @SqlType annotation", method));
            this.returnType = TypeSignature.parseTypeSignature((String)returnType.value(), this.literalParameters);
            Class<?> actualReturnType = method.getReturnType();
            if (Primitives.isWrapperType(actualReturnType)) {
                Preconditions.checkArgument((boolean)this.nullable, (String)"Method [%s] has wrapper return type %s but is missing @SqlNullable", (Object)method, (Object)actualReturnType.getSimpleName());
            } else if (actualReturnType.isPrimitive()) {
                Preconditions.checkArgument((!this.nullable ? 1 : 0) != 0, (String)"Method [%s] annotated with @SqlNullable has primitive return type %s", (Object)method, (Object)actualReturnType.getSimpleName());
            }
            this.longVariableConstraints = FunctionsParserHelper.parseLongVariableConstraints(method);
            this.specializedTypeParameters = FunctionsParserHelper.getDeclaredSpecializedTypeParameters(method, this.typeParameters);
            for (TypeParameter typeParameter : this.typeParameters) {
                Preconditions.checkArgument((boolean)typeParameter.value().matches("[A-Z][A-Z0-9]*"), (String)"Expected type parameter to only contain A-Z and 0-9 (starting with A-Z), but got %s on method [%s]", (Object)typeParameter.value(), (Object)method);
            }
            this.parseArguments(method);
            this.constructorMethodHandle = this.getConstructor(method, constructors);
            this.methodHandle = this.getMethodHandle(method);
        }

        private void parseArguments(Method method) {
            for (int i = 0; i < method.getParameterCount(); ++i) {
                Parameter parameter = method.getParameters()[i];
                Class<?> parameterType = parameter.getType();
                if (parameterType == ConnectorSession.class) continue;
                Optional<Annotation> implementationDependency = ImplementationDependency.getImplementationDependencyAnnotation(parameter);
                if (implementationDependency.isPresent()) {
                    ImplementationDependency.validateImplementationDependencyAnnotation(method, implementationDependency.get(), this.typeParameterNames, this.literalParameters);
                    this.dependencies.add(ImplementationDependency.Factory.createDependency(implementationDependency.get(), this.literalParameters));
                    continue;
                }
                Annotation[] annotations = parameter.getAnnotations();
                Preconditions.checkArgument((!Stream.of(annotations).anyMatch(IsNull.class::isInstance) ? 1 : 0) != 0, (String)"Method [%s] has @IsNull parameter that does not follow a @SqlType parameter", (Object)method);
                SqlType type = Stream.of(annotations).filter(SqlType.class::isInstance).map(SqlType.class::cast).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Method [%s] is missing @SqlType annotation for parameter", method)));
                TypeSignature typeSignature = TypeSignature.parseTypeSignature((String)type.value(), this.literalParameters);
                boolean nullableArgument = Stream.of(annotations).anyMatch(SqlNullable.class::isInstance);
                Preconditions.checkArgument((nullableArgument || !FunctionsParserHelper.containsLegacyNullable(annotations) ? 1 : 0) != 0, (String)"Method [%s] has parameter annotated with @Nullable but not @SqlNullable", (Object)method);
                boolean hasNullFlag = false;
                if (method.getParameterCount() > i + 1) {
                    Annotation[] parameterAnnotations = method.getParameterAnnotations()[i + 1];
                    if (Stream.of(parameterAnnotations).anyMatch(IsNull.class::isInstance)) {
                        Class<?> isNullType = method.getParameterTypes()[i + 1];
                        Preconditions.checkArgument((boolean)Stream.of(parameterAnnotations).filter(FunctionsParserHelper::isPrestoAnnotation).allMatch(IsNull.class::isInstance), (String)"Method [%s] has @IsNull parameter that has other annotations", (Object)method);
                        Preconditions.checkArgument((isNullType == Boolean.TYPE ? 1 : 0) != 0, (String)"Method [%s] has non-boolean parameter with @IsNull", (Object)method);
                        Preconditions.checkArgument((parameterType == Void.class || !Primitives.isWrapperType(parameterType) ? 1 : 0) != 0, (String)"Method [%s] uses @IsNull following a parameter with boxed primitive type: %s", (Object)method, (Object)parameterType.getSimpleName());
                        nullableArgument = true;
                        hasNullFlag = true;
                    }
                }
                if (Primitives.isWrapperType(parameterType)) {
                    Preconditions.checkArgument((boolean)nullableArgument, (String)"Method [%s] has parameter with wrapper type %s that is missing @SqlNullable", (Object)method, (Object)parameterType.getSimpleName());
                } else if (parameterType.isPrimitive() && !hasNullFlag) {
                    Preconditions.checkArgument((!nullableArgument ? 1 : 0) != 0, (String)"Method [%s] has parameter with primitive type %s annotated with @SqlNullable", (Object)method, (Object)parameterType.getSimpleName());
                }
                if (this.typeParameterNames.contains((Object)type.value()) && (parameterType != Object.class || !nullableArgument)) {
                    Class<?> specialization = this.specializedTypeParameters.get(type.value());
                    Class nativeParameterType = Primitives.unwrap(parameterType);
                    Preconditions.checkArgument((specialization == null || specialization.equals(nativeParameterType) ? 1 : 0) != 0, (String)"Method [%s] type %s has conflicting specializations %s and %s", (Object)method, (Object)type.value(), specialization, (Object)nativeParameterType);
                    this.specializedTypeParameters.put(type.value(), nativeParameterType);
                }
                this.argumentNativeContainerTypes.add(parameterType);
                this.argumentTypes.add(typeSignature);
                if (hasNullFlag) {
                    ++i;
                }
                if (typeSignature.getBase().equals("function")) {
                    Failures.checkCondition(parameterType.isAnnotationPresent(FunctionalInterface.class), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "argument %s is marked as lambda but the function interface class is not annotated: %s", i, this.methodHandle);
                    this.argumentProperties.add(ScalarFunctionImplementation.ArgumentProperty.functionTypeArgumentProperty(parameterType));
                    continue;
                }
                ScalarFunctionImplementation.NullConvention nullConvention = !nullableArgument ? ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL : (hasNullFlag ? ScalarFunctionImplementation.NullConvention.USE_NULL_FLAG : ScalarFunctionImplementation.NullConvention.USE_BOXED_TYPE);
                this.argumentProperties.add(ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(nullConvention));
            }
        }

        private Optional<MethodHandle> getConstructor(Method method, Map<Set<TypeParameter>, Constructor<?>> constructors) {
            if (Modifier.isStatic(method.getModifiers())) {
                return Optional.empty();
            }
            Constructor<?> constructor = constructors.get(this.typeParameters);
            Preconditions.checkArgument((constructor != null ? 1 : 0) != 0, (String)"Method [%s] is an instance method and requires a public constructor to be declared with %s type parameters", (Object)method, this.typeParameters);
            for (int i = 0; i < constructor.getParameterCount(); ++i) {
                Annotation[] annotations = constructor.getParameterAnnotations()[i];
                Preconditions.checkArgument((boolean)FunctionsParserHelper.containsImplementationDependencyAnnotation(annotations), (String)"Constructors may only have meta parameters [%s]", constructor);
                Preconditions.checkArgument((annotations.length == 1 ? 1 : 0) != 0, (String)"Meta parameters may only have a single annotation [%s]", constructor);
                Annotation annotation = annotations[0];
                if (annotation instanceof TypeParameter) {
                    ImplementationDependency.checkTypeParameters(TypeSignature.parseTypeSignature((String)((TypeParameter)annotation).value()), this.typeParameterNames, method);
                }
                this.constructorDependencies.add(ImplementationDependency.Factory.createDependency(annotation, this.literalParameters));
            }
            MethodHandle result = Reflection.constructorMethodHandle(StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, constructor);
            return Optional.of(result.asType(result.type().changeReturnType(Object.class)));
        }

        private MethodHandle getMethodHandle(Method method) {
            MethodHandle methodHandle = Reflection.methodHandle(StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, method);
            if (!Modifier.isStatic(method.getModifiers())) {
                int i;
                methodHandle = methodHandle.asType(methodHandle.type().changeParameterType(0, Object.class));
                int[] permutedIndices = new int[methodHandle.type().parameterCount()];
                permutedIndices[0] = this.dependencies.size();
                MethodType newType = methodHandle.type().changeParameterType(this.dependencies.size(), (Class<?>)methodHandle.type().parameterType(0));
                for (i = 0; i < this.dependencies.size(); ++i) {
                    permutedIndices[i + 1] = i;
                    newType = newType.changeParameterType(i, (Class<?>)methodHandle.type().parameterType(i + 1));
                }
                for (i = this.dependencies.size() + 1; i < permutedIndices.length; ++i) {
                    permutedIndices[i] = i;
                }
                methodHandle = MethodHandles.permuteArguments(methodHandle, newType, permutedIndices);
            }
            return methodHandle;
        }

        public ScalarImplementation get() {
            Signature signature = new Signature(this.functionName, FunctionKind.SCALAR, FunctionsParserHelper.createTypeVariableConstraints(this.typeParameters, this.dependencies), this.longVariableConstraints, this.returnType, this.argumentTypes, false);
            return new ScalarImplementation(signature, this.nullable, this.argumentProperties, this.methodHandle, this.dependencies, this.constructorMethodHandle, this.constructorDependencies, this.argumentNativeContainerTypes, this.specializedTypeParameters);
        }

        public static ScalarImplementation parseImplementation(String functionName, Method method, Map<Set<TypeParameter>, Constructor<?>> constructors) {
            return new Parser(functionName, method, constructors).get();
        }
    }

    public static final class MethodHandleAndConstructor {
        private final MethodHandle methodHandle;
        private final Optional<MethodHandle> constructor;

        public MethodHandleAndConstructor(MethodHandle methodHandle, Optional<MethodHandle> constructor) {
            this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
            this.constructor = Objects.requireNonNull(constructor, "constructor is null");
        }

        public MethodHandle getMethodHandle() {
            return this.methodHandle;
        }

        public Optional<MethodHandle> getConstructor() {
            return this.constructor;
        }
    }
}

