/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;

public final class ZipFunction
extends SqlScalarFunction {
    public static final int MIN_ARITY = 2;
    public static final int MAX_ARITY = 4;
    public static final ZipFunction[] ZIP_FUNCTIONS;
    private static final MethodHandle METHOD_HANDLE;
    private final List<String> typeParameters;

    private ZipFunction(int arity) {
        this((List)IntStream.rangeClosed(1, arity).mapToObj(s -> "T" + s).collect(ImmutableList.toImmutableList()));
    }

    private ZipFunction(List<String> typeParameters) {
        super(new Signature("zip", FunctionKind.SCALAR, (List)typeParameters.stream().map(Signature::typeVariable).collect(ImmutableList.toImmutableList()), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)("array(row(" + String.join((CharSequence)",", typeParameters) + "))")), (List)typeParameters.stream().map(name -> "array(" + name + ")").map(TypeSignature::parseTypeSignature).collect(ImmutableList.toImmutableList()), false));
        this.typeParameters = typeParameters;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Merges the given arrays, element-wise, into a single array of rows.";
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        List types = (List)this.typeParameters.stream().map(boundVariables::getTypeVariable).collect(ImmutableList.toImmutableList());
        List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties = Collections.nCopies(types.size(), ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL));
        List<Class<?>> javaArgumentTypes = Collections.nCopies(types.size(), Block.class);
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(types).asVarargsCollector(Block[].class).asType(MethodType.methodType(Block.class, javaArgumentTypes));
        return new ScalarFunctionImplementation(false, argumentProperties, methodHandle, this.isDeterministic());
    }

    @UsedByGeneratedCode
    public static Block zip(List<Type> types, Block ... arrays) {
        int biggestCardinality = 0;
        for (Block array : arrays) {
            biggestCardinality = Math.max(biggestCardinality, array.getPositionCount());
        }
        RowType rowType = new RowType(types, Optional.empty());
        BlockBuilder outputBuilder = rowType.createBlockBuilder(new BlockBuilderStatus(), biggestCardinality);
        for (int outputPosition = 0; outputPosition < biggestCardinality; ++outputPosition) {
            BlockBuilder rowBuilder = outputBuilder.beginBlockEntry();
            for (int fieldIndex = 0; fieldIndex < arrays.length; ++fieldIndex) {
                if (arrays[fieldIndex].getPositionCount() <= outputPosition) {
                    rowBuilder.appendNull();
                    continue;
                }
                types.get(fieldIndex).appendTo(arrays[fieldIndex], outputPosition, rowBuilder);
            }
            outputBuilder.closeEntry();
        }
        return outputBuilder.build();
    }

    static {
        METHOD_HANDLE = Reflection.methodHandle(ZipFunction.class, "zip", List.class, Block[].class);
        ZIP_FUNCTIONS = new ZipFunction[3];
        for (int arity = 2; arity <= 4; ++arity) {
            ZipFunction.ZIP_FUNCTIONS[arity - 2] = new ZipFunction(arity);
        }
    }
}

