/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.ConnectorSession;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.TypeDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ScalarFunctionImplementation {
    private final boolean nullable;
    private final List<ArgumentProperty> argumentProperties;
    private final MethodHandle methodHandle;
    private final Optional<MethodHandle> instanceFactory;
    private final boolean deterministic;

    public ScalarFunctionImplementation(boolean nullable, List<ArgumentProperty> argumentProperties, MethodHandle methodHandle, boolean deterministic) {
        this(nullable, argumentProperties, methodHandle, Optional.empty(), deterministic);
    }

    public ScalarFunctionImplementation(boolean nullable, List<ArgumentProperty> argumentProperties, MethodHandle methodHandle, Optional<MethodHandle> instanceFactory, boolean deterministic) {
        List<Class<?>> parameterList;
        this.nullable = nullable;
        this.argumentProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentProperties, "argumentProperties is null"));
        this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
        this.instanceFactory = Objects.requireNonNull(instanceFactory, "instanceFactory is null");
        this.deterministic = deterministic;
        if (instanceFactory.isPresent()) {
            TypeDescriptor.OfField instanceType = instanceFactory.get().type().returnType();
            Preconditions.checkArgument((boolean)instanceType.equals(methodHandle.type().parameterType(0)), (Object)"methodHandle is not an instance method");
        }
        if ((parameterList = methodHandle.type().parameterList()).contains(ConnectorSession.class)) {
            Preconditions.checkArgument((parameterList.stream().filter(ConnectorSession.class::equals).count() == 1L ? 1 : 0) != 0, (Object)"function implementation should have exactly one ConnectorSession parameter");
            if (!instanceFactory.isPresent()) {
                Preconditions.checkArgument((parameterList.get(0) == ConnectorSession.class ? 1 : 0) != 0, (Object)"ConnectorSession must be the first argument when instanceFactory is not present");
            } else {
                Preconditions.checkArgument((parameterList.get(1) == ConnectorSession.class ? 1 : 0) != 0, (Object)"ConnectorSession must be the second argument when instanceFactory is present");
            }
        }
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public ArgumentProperty getArgumentProperty(int argumentIndex) {
        return this.argumentProperties.get(argumentIndex);
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    public Optional<MethodHandle> getInstanceFactory() {
        return this.instanceFactory;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public static enum ArgumentType {
        VALUE_TYPE,
        FUNCTION_TYPE;

    }

    public static enum NullConvention {
        RETURN_NULL_ON_NULL,
        USE_BOXED_TYPE,
        USE_NULL_FLAG;

    }

    public static class ArgumentProperty {
        private final ArgumentType argumentType;
        private final Optional<NullConvention> nullConvention;
        private final Optional<Class> lambdaInterface;

        public static ArgumentProperty valueTypeArgumentProperty(NullConvention nullConvention) {
            return new ArgumentProperty(ArgumentType.VALUE_TYPE, Optional.of(nullConvention), Optional.empty());
        }

        public static ArgumentProperty functionTypeArgumentProperty(Class lambdaInterface) {
            return new ArgumentProperty(ArgumentType.FUNCTION_TYPE, Optional.empty(), Optional.of(lambdaInterface));
        }

        private ArgumentProperty(ArgumentType argumentType, Optional<NullConvention> nullConvention, Optional<Class> lambdaInterface) {
            switch (argumentType) {
                case VALUE_TYPE: {
                    Preconditions.checkArgument((boolean)nullConvention.isPresent(), (Object)"nullConvention must present for value type");
                    Preconditions.checkArgument((!lambdaInterface.isPresent() ? 1 : 0) != 0, (Object)"lambdaInterface must not present for value type");
                    break;
                }
                case FUNCTION_TYPE: {
                    Preconditions.checkArgument((!nullConvention.isPresent() ? 1 : 0) != 0, (Object)"nullConvention must not present for function type");
                    Preconditions.checkArgument((boolean)lambdaInterface.isPresent(), (Object)"lambdaInterface must present for function type");
                    Preconditions.checkArgument((boolean)lambdaInterface.get().isAnnotationPresent(FunctionalInterface.class), (Object)"lambdaInterface must be annotated with FunctionalInterface");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported argument type: %s", new Object[]{argumentType}));
                }
            }
            this.argumentType = argumentType;
            this.nullConvention = nullConvention;
            this.lambdaInterface = lambdaInterface;
        }

        public ArgumentType getArgumentType() {
            return this.argumentType;
        }

        public NullConvention getNullConvention() {
            Preconditions.checkState((this.getArgumentType() == ArgumentType.VALUE_TYPE ? 1 : 0) != 0, (Object)"nullConvention only applies to value type argument");
            return this.nullConvention.get();
        }

        public Class getLambdaInterface() {
            Preconditions.checkState((this.getArgumentType() == ArgumentType.FUNCTION_TYPE ? 1 : 0) != 0, (Object)"lambdaInterface only applies to function type argument");
            return this.lambdaInterface.get();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ArgumentProperty other = (ArgumentProperty)obj;
            return this.argumentType == other.argumentType && this.nullConvention.equals(other.nullConvention) && this.lambdaInterface.equals(other.lambdaInterface);
        }

        public int hashCode() {
            return Objects.hash(this.nullConvention, this.lambdaInterface);
        }
    }
}

